--
-- tpcds_ddl_create_obs_table
--
drop schema if exists tpcds CASCADE; 
create schema tpcds;
set search_path to tpcds;
--
-- Name: obs_from_customer_address_001; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create foreign table obs_from_customer_address_001
(
ca_address_sk integer not null,
ca_address_id char(16) not null,
ca_street_number char(10) ,
ca_street_name varchar(60) ,
ca_street_type char(15) ,
ca_suite_number char(10) ,
ca_city varchar(60) ,
ca_county varchar(30) ,
ca_state char(2) ,
ca_zip char(10) ,
ca_country varchar(20) ,
ca_gmt_offset float4 ,
ca_location_type char(20) 
)
--
-- set the configuration item to create foreign table
--
SERVER gsmpp_server
OPTIONS (
location 'gsobs://xxx.xxx.xxx.xxx/dws/download/dws_sample_database_data_files/customer_address/customer_address' ,
format 'text',
delimiter '|',
encoding 'utf8',
noescaping 'true',
access_key 'access_key_value_to_be_replaced',
secret_access_key 'secret_access_key_value_to_be_replaced',
reject_limit 'unlimited',
chunksize '64'
)
--
-- if create foreign table failed,record error message
--
with err_obs_from_customer_address_001;
--
-- Name: obs_from_customer_demographics_001; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create foreign table obs_from_customer_demographics_001
(
    cd_demo_sk                integer               not null,
    cd_gender                 char(1)                       ,
    cd_marital_status         char(1)                       ,
    cd_education_status       char(20)                      ,
    cd_purchase_estimate      integer                       ,
    cd_credit_rating          char(10)                      ,
    cd_dep_count              integer                       ,
    cd_dep_employed_count     integer                       ,
    cd_dep_college_count      integer                       
)
--
-- set the configuration item to create foreign table
--
SERVER gsmpp_server
OPTIONS (
location 'gsobs://xxx.xxx.xxx.xxx/dws/download/dws_sample_database_data_files/customer_demographics/customer_demographics' ,
format 'text',
delimiter '|',
encoding 'utf8',
noescaping 'true',
access_key 'access_key_value_to_be_replaced',
secret_access_key 'secret_access_key_value_to_be_replaced',
reject_limit 'unlimited',
chunksize '64'
)
--
-- if create foreign table failed,record error message
--
with err_obs_from_customer_demographics_001;
--
-- Name: obs_from_date_dim_001; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create foreign table obs_from_date_dim_001
(
    d_date_sk                 integer               not null,
    d_date_id                 char(16)              not null,
    d_date                    date                          ,
    d_month_seq               integer                       ,
    d_week_seq                integer                       ,
    d_quarter_seq             integer                       ,
    d_year                    integer                       ,
    d_dow                     integer                       ,
    d_moy                     integer                       ,
    d_dom                     integer                       ,
    d_qoy                     integer                       ,
    d_fy_year                 integer                       ,
    d_fy_quarter_seq          integer                       ,
    d_fy_week_seq             integer                       ,
    d_day_name                char(9)                       ,
    d_quarter_name            char(6)                       ,
    d_holiday                 char(1)                       ,
    d_weekend                 char(1)                       ,
    d_following_holiday       char(1)                       ,
    d_first_dom               integer                       ,
    d_last_dom                integer                       ,
    d_same_day_ly             integer                       ,
    d_same_day_lq             integer                       ,
    d_current_day             char(1)                       ,
    d_current_week            char(1)                       ,
    d_current_month           char(1)                       ,
    d_current_quarter         char(1)                       ,
    d_current_year            char(1)                       
)
--
-- set the configuration item to create foreign table
--
SERVER gsmpp_server
OPTIONS (
location 'gsobs://xxx.xxx.xxx.xxx/dws/download/dws_sample_database_data_files/date_dim/date_dim' ,
format 'text',
delimiter '|',
encoding 'utf8',
noescaping 'true',
access_key 'access_key_value_to_be_replaced',
secret_access_key 'secret_access_key_value_to_be_replaced',
reject_limit 'unlimited',
chunksize '64'
)
--
-- if create foreign table failed,record error message
--
with err_obs_from_date_dim_001;
--
-- Name: obs_from_warehouse_001; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create foreign table obs_from_warehouse_001
(
    w_warehouse_sk            integer               not null,
    w_warehouse_id            char(16)              not null,
    w_warehouse_name          varchar(20)                   ,
    w_warehouse_sq_ft         integer                       ,
    w_street_number           char(10)                      ,
    w_street_name             varchar(60)                   ,
    w_street_type             char(15)                      ,
    w_suite_number            char(10)                      ,
    w_city                    varchar(60)                   ,
    w_county                  varchar(30)                   ,
    w_state                   char(2)                       ,
    w_zip                     char(10)                      ,
    w_country                 varchar(20)                   ,
    w_gmt_offset              decimal(5,2)                  
)
--
-- set the configuration item to create foreign table
--
SERVER gsmpp_server
OPTIONS (
location 'gsobs://xxx.xxx.xxx.xxx/dws/download/dws_sample_database_data_files/warehouse/warehouse' ,
format 'text',
delimiter '|',
encoding 'utf8',
noescaping 'true',
access_key 'access_key_value_to_be_replaced',
secret_access_key 'secret_access_key_value_to_be_replaced',
reject_limit 'unlimited',
chunksize '64'
)
--
-- if create foreign table failed,record error message
--
with err_obs_from_warehouse_001;
--
-- Name: obs_from_ship_mode_001; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create foreign table obs_from_ship_mode_001
(
    sm_ship_mode_sk           integer               not null,
    sm_ship_mode_id           char(16)              not null,
    sm_type                   char(30)                      ,
    sm_code                   char(10)                      ,
    sm_carrier                char(20)                      ,
    sm_contract               char(20)                      
)
--
-- set the configuration item to create foreign table
--
SERVER gsmpp_server
OPTIONS (
location 'gsobs://xxx.xxx.xxx.xxx/dws/download/dws_sample_database_data_files/ship_mode/ship_mode' ,
format 'text',
delimiter '|',
encoding 'utf8',
noescaping 'true',
access_key 'access_key_value_to_be_replaced',
secret_access_key 'secret_access_key_value_to_be_replaced',
reject_limit 'unlimited',
chunksize '64'
)
--
-- if create foreign table failed,record error message
--
with err_obs_from_ship_mode_001;
--
-- Name: obs_from_time_dim_001; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create foreign table obs_from_time_dim_001
(
    t_time_sk                 integer               not null,
    t_time_id                 char(16)              not null,
    t_time                    integer                       ,
    t_hour                    integer                       ,
    t_minute                  integer                       ,
    t_second                  integer                       ,
    t_am_pm                   char(2)                       ,
    t_shift                   char(20)                      ,
    t_sub_shift               char(20)                      ,
    t_meal_time               char(20)                     
)
--
-- set the configuration item to create foreign table
--
SERVER gsmpp_server
OPTIONS (
location 'gsobs://xxx.xxx.xxx.xxx/dws/download/dws_sample_database_data_files/time_dim/time_dim' ,
format 'text',
delimiter '|',
encoding 'utf8',
noescaping 'true',
access_key 'access_key_value_to_be_replaced',
secret_access_key 'secret_access_key_value_to_be_replaced',
reject_limit 'unlimited',
chunksize '64'
)
--
-- if create foreign table failed,record error message
--
with err_obs_from_time_dim_001;
--
-- Name: obs_from_reason_001; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create foreign table obs_from_reason_001
(
    r_reason_sk               integer               not null,
    r_reason_id               char(16)              not null,
    r_reason_desc             char(100)                    
)
--
-- set the configuration item to create foreign table
--
SERVER gsmpp_server
OPTIONS (
location 'gsobs://xxx.xxx.xxx.xxx/dws/download/dws_sample_database_data_files/reason/reason' ,
format 'text',
delimiter '|',
encoding 'utf8',
noescaping 'true',
access_key 'access_key_value_to_be_replaced',
secret_access_key 'secret_access_key_value_to_be_replaced',
reject_limit 'unlimited',
chunksize '64'
)
--
-- if create foreign table failed,record error message
--
with err_obs_from_reason_001;
--
-- Name: obs_from_income_band_001; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create foreign table obs_from_income_band_001
(
    ib_income_band_sk         integer               not null,
    ib_lower_bound            integer                       ,
    ib_upper_bound            integer                       
)
--
-- set the configuration item to create foreign table
--
SERVER gsmpp_server
OPTIONS (
location 'gsobs://xxx.xxx.xxx.xxx/dws/download/dws_sample_database_data_files/income_band/income_band' ,
format 'text',
delimiter '|',
encoding 'utf8',
noescaping 'true',
access_key 'access_key_value_to_be_replaced',
secret_access_key 'secret_access_key_value_to_be_replaced',
reject_limit 'unlimited',
chunksize '64'
)
--
-- if create foreign table failed,record error message
--
with err_obs_from_income_band_001;
--
-- Name: obs_from_item_001; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create foreign table obs_from_item_001
(
    i_item_sk                 integer               not null,
    i_item_id                 char(16)              not null,
    i_rec_start_date          date                          ,
    i_rec_end_date            date                          ,
    i_item_desc               varchar(200)                  ,
    i_current_price           decimal(7,2)                  ,
    i_wholesale_cost          decimal(7,2)                  ,
    i_brand_id                integer                       ,
    i_brand                   char(50)                      ,
    i_class_id                integer                       ,
    i_class                   char(50)                      ,
    i_category_id             integer                       ,
    i_category                char(50)                      ,
    i_manufact_id             integer                       ,
    i_manufact                char(50)                      ,
    i_size                    char(20)                      ,
    i_formulation             char(20)                      ,
    i_color                   char(20)                      ,
    i_units                   char(10)                      ,
    i_container               char(10)                      ,
    i_manager_id              integer                       ,
    i_product_name            char(50)                      
)
--
-- set the configuration item to create foreign table
--
SERVER gsmpp_server
OPTIONS (
location 'gsobs://xxx.xxx.xxx.xxx/dws/download/dws_sample_database_data_files/item/item' ,
format 'text',
delimiter '|',
encoding 'utf8',
noescaping 'true',
access_key 'access_key_value_to_be_replaced',
secret_access_key 'secret_access_key_value_to_be_replaced',
reject_limit 'unlimited',
chunksize '64'
)
--
-- if create foreign table failed,record error message
--
with err_obs_from_item_001;
--
-- Name: obs_from_store_001; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create foreign table obs_from_store_001
(
    s_store_sk                integer               not null,
    s_store_id                char(16)              not null,
    s_rec_start_date          date                          ,
    s_rec_end_date            date                          ,
    s_closed_date_sk          integer                       ,
    s_store_name              varchar(50)                   ,
    s_number_employees        integer                       ,
    s_floor_space             integer                       ,
    s_hours                   char(20)                      ,
    s_manager                 varchar(40)                   ,
    s_market_id               integer                       ,
    s_geography_class         varchar(100)                  ,
    s_market_desc             varchar(100)                  ,
    s_market_manager          varchar(40)                   ,
    s_division_id             integer                       ,
    s_division_name           varchar(50)                   ,
    s_company_id              integer                       ,
    s_company_name            varchar(50)                   ,
    s_street_number           varchar(10)                   ,
    s_street_name             varchar(60)                   ,
    s_street_type             char(15)                      ,
    s_suite_number            char(10)                      ,
    s_city                    varchar(60)                   ,
    s_county                  varchar(30)                   ,
    s_state                   char(2)                       ,
    s_zip                     char(10)                      ,
    s_country                 varchar(20)                   ,
    s_gmt_offset              decimal(5,2)                  ,
    s_tax_precentage          decimal(5,2)                  
)
--
-- set the configuration item to create foreign table
--
SERVER gsmpp_server
OPTIONS (
location 'gsobs://xxx.xxx.xxx.xxx/dws/download/dws_sample_database_data_files/store/store' ,
format 'text',
delimiter '|',
encoding 'utf8',
noescaping 'true',
access_key 'access_key_value_to_be_replaced',
secret_access_key 'secret_access_key_value_to_be_replaced',
reject_limit 'unlimited',
chunksize '64'
)
--
-- if create foreign table failed,record error message
--
with err_obs_from_store_001;
--
-- Name: obs_from_call_center_001; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create foreign table obs_from_call_center_001
(
    cc_call_center_sk         integer               not null,
    cc_call_center_id         char(16)              not null,
    cc_rec_start_date         date                          ,
    cc_rec_end_date           date                          ,
    cc_closed_date_sk         integer                       ,
    cc_open_date_sk           integer                       ,
    cc_name                   varchar(50)                   ,
    cc_class                  varchar(50)                   ,
    cc_employees              integer                       ,
    cc_sq_ft                  integer                       ,
    cc_hours                  char(20)                      ,
    cc_manager                varchar(40)                   ,
    cc_mkt_id                 integer                       ,
    cc_mkt_class              char(50)                      ,
    cc_mkt_desc               varchar(100)                  ,
    cc_market_manager         varchar(40)                   ,
    cc_division               integer                       ,
    cc_division_name          varchar(50)                   ,
    cc_company                integer                       ,
    cc_company_name           char(50)                      ,
    cc_street_number          char(10)                      ,
    cc_street_name            varchar(60)                   ,
    cc_street_type            char(15)                      ,
    cc_suite_number           char(10)                      ,
    cc_city                   varchar(60)                   ,
    cc_county                 varchar(30)                   ,
    cc_state                  char(2)                       ,
    cc_zip                    char(10)                      ,
    cc_country                varchar(20)                   ,
    cc_gmt_offset             decimal(5,2)                  ,
    cc_tax_percentage         decimal(5,2)                  
)
--
-- set the configuration item to create foreign table
--
SERVER gsmpp_server
OPTIONS (
location 'gsobs://xxx.xxx.xxx.xxx/dws/download/dws_sample_database_data_files/call_center/call_center' ,
format 'text',
delimiter '|',
encoding 'utf8',
noescaping 'true',
access_key 'access_key_value_to_be_replaced',
secret_access_key 'secret_access_key_value_to_be_replaced',
reject_limit 'unlimited',
chunksize '64'
)
--
-- if create foreign table failed,record error message
--
with err_obs_from_call_center_001;
--
-- Name: obs_from_customer_001; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create foreign table obs_from_customer_001
(
    c_customer_sk             integer               not null,
    c_customer_id             char(16)              not null,
    c_current_cdemo_sk        integer                       ,
    c_current_hdemo_sk        integer                       ,
    c_current_addr_sk         integer                       ,
    c_first_shipto_date_sk    integer                       ,
    c_first_sales_date_sk     integer                       ,
    c_salutation              char(10)                      ,
    c_first_name              char(20)                      ,
    c_last_name               char(30)                      ,
    c_preferred_cust_flag     char(1)                       ,
    c_birth_day               integer                       ,
    c_birth_month             integer                       ,
    c_birth_year              integer                       ,
    c_birth_country           varchar(20)                   ,
    c_login                   char(13)                      ,
    c_email_address           char(50)                      ,
    c_last_review_date        char(10)                      
)
--
-- set the configuration item to create foreign table
--
SERVER gsmpp_server
OPTIONS (
location 'gsobs://xxx.xxx.xxx.xxx/dws/download/dws_sample_database_data_files/customer/customer' ,
format 'text',
delimiter '|',
encoding 'utf8',
noescaping 'true',
access_key 'access_key_value_to_be_replaced',
secret_access_key 'secret_access_key_value_to_be_replaced',
reject_limit 'unlimited',
chunksize '64'
)
--
-- if create foreign table failed,record error message
--
with err_obs_from_customer_001;
--
-- Name: obs_from_web_site_001; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create foreign table obs_from_web_site_001
(
    web_site_sk               integer               not null,
    web_site_id               char(16)              not null,
    web_rec_start_date        date                          ,
    web_rec_end_date          date                          ,
    web_name                  varchar(50)                   ,
    web_open_date_sk          integer                       ,
    web_close_date_sk         integer                       ,
    web_class                 varchar(50)                   ,
    web_manager               varchar(40)                   ,
    web_mkt_id                integer                       ,
    web_mkt_class             varchar(50)                   ,
    web_mkt_desc              varchar(100)                  ,
    web_market_manager        varchar(40)                   ,
    web_company_id            integer                       ,
    web_company_name          char(50)                      ,
    web_street_number         char(10)                      ,
    web_street_name           varchar(60)                   ,
    web_street_type           char(15)                      ,
    web_suite_number          char(10)                      ,
    web_city                  varchar(60)                   ,
    web_county                varchar(30)                   ,
    web_state                 char(2)                       ,
    web_zip                   char(10)                      ,
    web_country               varchar(20)                   ,
    web_gmt_offset            decimal(5,2)                  ,
    web_tax_percentage        decimal(5,2)                  
)
--
-- set the configuration item to create foreign table
--
SERVER gsmpp_server
OPTIONS (
location 'gsobs://xxx.xxx.xxx.xxx/dws/download/dws_sample_database_data_files/web_site/web_site' ,
format 'text',
delimiter '|',
encoding 'utf8',
noescaping 'true',
access_key 'access_key_value_to_be_replaced',
secret_access_key 'secret_access_key_value_to_be_replaced',
reject_limit 'unlimited',
chunksize '64'
)
--
-- if create foreign table failed,record error message
--
with err_obs_from_web_site_001;
--
-- Name: obs_from_store_returns_001; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create foreign table obs_from_store_returns_001
(
    sr_returned_date_sk       integer                       ,
    sr_return_time_sk         integer                       ,
    sr_item_sk                integer               not null,
    sr_customer_sk            integer                       ,
    sr_cdemo_sk               integer                       ,
    sr_hdemo_sk               integer                       ,
    sr_addr_sk                integer                       ,
    sr_store_sk               integer                       ,
    sr_reason_sk              integer                       ,
    sr_ticket_number          bigint               not null,
    sr_return_quantity        integer                       ,
    sr_return_amt             decimal(7,2)                  ,
    sr_return_tax             decimal(7,2)                  ,
    sr_return_amt_inc_tax     decimal(7,2)                  ,
    sr_fee                    decimal(7,2)                  ,
    sr_return_ship_cost       decimal(7,2)                  ,
    sr_refunded_cash          decimal(7,2)                  ,
    sr_reversed_charge        decimal(7,2)                  ,
    sr_store_credit           decimal(7,2)                  ,
    sr_net_loss               decimal(7,2)                  
)
--
-- set the configuration item to create foreign table
--
SERVER gsmpp_server
OPTIONS (
location 'gsobs://xxx.xxx.xxx.xxx/dws/download/dws_sample_database_data_files/store_returns/store_returns' ,
format 'text',
delimiter '|',
encoding 'utf8',
noescaping 'true',
access_key 'access_key_value_to_be_replaced',
secret_access_key 'secret_access_key_value_to_be_replaced',
reject_limit 'unlimited',
chunksize '64'
)
--
-- if create foreign table failed,record error message
--
with err_obs_from_store_returns_001;
--
-- Name: obs_from_household_demographics_001; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create foreign table obs_from_household_demographics_001
(
    hd_demo_sk                integer               not null,
    hd_income_band_sk         integer                       ,
    hd_buy_potential          char(15)                      ,
    hd_dep_count              integer                       ,
    hd_vehicle_count          integer                       
)
--
-- set the configuration item to create foreign table
--
SERVER gsmpp_server
OPTIONS (
location 'gsobs://xxx.xxx.xxx.xxx/dws/download/dws_sample_database_data_files/household_demographics/household_demographics' ,
format 'text',
delimiter '|',
encoding 'utf8',
noescaping 'true',
access_key 'access_key_value_to_be_replaced',
secret_access_key 'secret_access_key_value_to_be_replaced',
reject_limit 'unlimited',
chunksize '64'
)
--
-- if create foreign table failed,record error message
--
with err_obs_from_household_demographics_001;
--
-- Name: obs_from_web_page_001; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create foreign table obs_from_web_page_001
(
    wp_web_page_sk            integer               not null,
    wp_web_page_id            char(16)              not null,
    wp_rec_start_date         date                          ,
    wp_rec_end_date           date                          ,
    wp_creation_date_sk       integer                       ,
    wp_access_date_sk         integer                       ,
    wp_autogen_flag           char(1)                       ,
    wp_customer_sk            integer                       ,
    wp_url                    varchar(100)                  ,
    wp_type                   char(50)                      ,
    wp_char_count             integer                       ,
    wp_link_count             integer                       ,
    wp_image_count            integer                       ,
    wp_max_ad_count           integer                       
)
--
-- set the configuration item to create foreign table
--
SERVER gsmpp_server
OPTIONS (
location 'gsobs://xxx.xxx.xxx.xxx/dws/download/dws_sample_database_data_files/web_page/web_page' ,
format 'text',
delimiter '|',
encoding 'utf8',
noescaping 'true',
access_key 'access_key_value_to_be_replaced',
secret_access_key 'secret_access_key_value_to_be_replaced',
reject_limit 'unlimited',
chunksize '64'
)
--
-- if create foreign table failed,record error message
--
with err_obs_from_web_page_001;
--
-- Name: obs_from_promotion_001; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create foreign table obs_from_promotion_001
(
    p_promo_sk                integer               not null,
    p_promo_id                char(16)              not null,
    p_start_date_sk           integer                       ,
    p_end_date_sk             integer                       ,
    p_item_sk                 integer                       ,
    p_cost                    decimal(15,2)                 ,
    p_response_target         integer                       ,
    p_promo_name              char(50)                      ,
    p_channel_dmail           char(1)                       ,
    p_channel_email           char(1)                       ,
    p_channel_catalog         char(1)                       ,
    p_channel_tv              char(1)                       ,
    p_channel_radio           char(1)                       ,
    p_channel_press           char(1)                       ,
    p_channel_event           char(1)                       ,
    p_channel_demo            char(1)                       ,
    p_channel_details         varchar(100)                  ,
    p_purpose                 char(15)                      ,
    p_discount_active         char(1)                       
)
--
-- set the configuration item to create foreign table
--
SERVER gsmpp_server
OPTIONS (
location 'gsobs://xxx.xxx.xxx.xxx/dws/download/dws_sample_database_data_files/promotion/promotion' ,
format 'text',
delimiter '|',
encoding 'utf8',
noescaping 'true',
access_key 'access_key_value_to_be_replaced',
secret_access_key 'secret_access_key_value_to_be_replaced',
reject_limit 'unlimited',
chunksize '64'
)
--
-- if create foreign table failed,record error message
--
with err_obs_from_promotion_001;
--
-- Name: obs_from_catalog_page_001; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create foreign table obs_from_catalog_page_001
(
    cp_catalog_page_sk        integer               not null,
    cp_catalog_page_id        char(16)              not null,
    cp_start_date_sk          integer                       ,
    cp_end_date_sk            integer                       ,
    cp_department             varchar(50)                   ,
    cp_catalog_number         integer                       ,
    cp_catalog_page_number    integer                       ,
    cp_description            varchar(100)                  ,
    cp_type                   varchar(100)                 
)
--
-- set the configuration item to create foreign table
--
SERVER gsmpp_server
OPTIONS (
location 'gsobs://xxx.xxx.xxx.xxx/dws/download/dws_sample_database_data_files/catalog_page/catalog_page' ,
format 'text',
delimiter '|',
encoding 'utf8',
noescaping 'true',
access_key 'access_key_value_to_be_replaced',
secret_access_key 'secret_access_key_value_to_be_replaced',
reject_limit 'unlimited',
chunksize '64'
)
--
-- if create foreign table failed,record error message
--
with err_obs_from_catalog_page_001;
--
-- Name: obs_from_inventory_001; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create foreign table obs_from_inventory_001
(
    inv_date_sk               integer               not null,
    inv_item_sk               integer               not null,
    inv_warehouse_sk          integer               not null,
    inv_quantity_on_hand      integer                       
)
--
-- set the configuration item to create foreign table
--
SERVER gsmpp_server
OPTIONS (
location 'gsobs://xxx.xxx.xxx.xxx/dws/download/dws_sample_database_data_files/inventory/inventory' ,
format 'text',
delimiter '|',
encoding 'utf8',
noescaping 'true',
access_key 'access_key_value_to_be_replaced',
secret_access_key 'secret_access_key_value_to_be_replaced',
reject_limit 'unlimited',
chunksize '64'
)
--
-- if create foreign table failed,record error message
--
with err_obs_from_inventory_001;
--
-- Name: obs_from_catalog_returns_001; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create foreign table obs_from_catalog_returns_001
(
    cr_returned_date_sk       integer                       ,
    cr_returned_time_sk       integer                       ,
    cr_item_sk                integer               not null,
    cr_refunded_customer_sk   integer                       ,
    cr_refunded_cdemo_sk      integer                       ,
    cr_refunded_hdemo_sk      integer                       ,
    cr_refunded_addr_sk       integer                       ,
    cr_returning_customer_sk  integer                       ,
    cr_returning_cdemo_sk     integer                       ,
    cr_returning_hdemo_sk     integer                       ,
    cr_returning_addr_sk      integer                       ,
    cr_call_center_sk         integer                       ,
    cr_catalog_page_sk        integer                       ,
    cr_ship_mode_sk           integer                       ,
    cr_warehouse_sk           integer                       ,
    cr_reason_sk              integer                       ,
    cr_order_number           bigint               not null,
    cr_return_quantity        integer                       ,
    cr_return_amount          decimal(7,2)                  ,
    cr_return_tax             decimal(7,2)                  ,
    cr_return_amt_inc_tax     decimal(7,2)                  ,
    cr_fee                    decimal(7,2)                  ,
    cr_return_ship_cost       decimal(7,2)                  ,
    cr_refunded_cash          decimal(7,2)                  ,
    cr_reversed_charge        decimal(7,2)                  ,
    cr_store_credit           decimal(7,2)                  ,
    cr_net_loss               decimal(7,2)                 
)
--
-- set the configuration item to create foreign table
--
SERVER gsmpp_server
OPTIONS (
location 'gsobs://xxx.xxx.xxx.xxx/dws/download/dws_sample_database_data_files/catalog_returns/catalog_returns' ,
format 'text',
delimiter '|',
encoding 'utf8',
noescaping 'true',
access_key 'access_key_value_to_be_replaced',
secret_access_key 'secret_access_key_value_to_be_replaced',
reject_limit 'unlimited',
chunksize '64'
)
--
-- if create foreign table failed,record error message
--
with err_obs_from_catalog_returns_001;
--
-- Name: obs_from_web_returns_001; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create foreign table obs_from_web_returns_001
(
    wr_returned_date_sk       integer                       ,
    wr_returned_time_sk       integer                       ,
    wr_item_sk                integer               not null,
    wr_refunded_customer_sk   integer                       ,
    wr_refunded_cdemo_sk      integer                       ,
    wr_refunded_hdemo_sk      integer                       ,
    wr_refunded_addr_sk       integer                       ,
    wr_returning_customer_sk  integer                       ,
    wr_returning_cdemo_sk     integer                       ,
    wr_returning_hdemo_sk     integer                       ,
    wr_returning_addr_sk      integer                       ,
    wr_web_page_sk            integer                       ,
    wr_reason_sk              integer                       ,
    wr_order_number           bigint               not null,
    wr_return_quantity        integer                       ,
    wr_return_amt             decimal(7,2)                  ,
    wr_return_tax             decimal(7,2)                  ,
    wr_return_amt_inc_tax     decimal(7,2)                  ,
    wr_fee                    decimal(7,2)                  ,
    wr_return_ship_cost       decimal(7,2)                  ,
    wr_refunded_cash          decimal(7,2)                  ,
    wr_reversed_charge        decimal(7,2)                  ,
    wr_account_credit         decimal(7,2)                  ,
    wr_net_loss               decimal(7,2)                 
)
--
-- set the configuration item to create foreign table
--
SERVER gsmpp_server
OPTIONS (
location 'gsobs://xxx.xxx.xxx.xxx/dws/download/dws_sample_database_data_files/web_returns/web_returns' ,
format 'text',
delimiter '|',
encoding 'utf8',
noescaping 'true',
access_key 'access_key_value_to_be_replaced',
secret_access_key 'secret_access_key_value_to_be_replaced',
reject_limit 'unlimited',
chunksize '64'
)
--
-- if create foreign table failed,record error message
--
with err_obs_from_web_returns_001;
--
-- Name: obs_from_web_sales_001; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create foreign table obs_from_web_sales_001
(
    ws_sold_date_sk           integer                       ,
    ws_sold_time_sk           integer                       ,
    ws_ship_date_sk           integer                       ,
    ws_item_sk                integer               not null,
    ws_bill_customer_sk       integer                       ,
    ws_bill_cdemo_sk          integer                       ,
    ws_bill_hdemo_sk          integer                       ,
    ws_bill_addr_sk           integer                       ,
    ws_ship_customer_sk       integer                       ,
    ws_ship_cdemo_sk          integer                       ,
    ws_ship_hdemo_sk          integer                       ,
    ws_ship_addr_sk           integer                       ,
    ws_web_page_sk            integer                       ,
    ws_web_site_sk            integer                       ,
    ws_ship_mode_sk           integer                       ,
    ws_warehouse_sk           integer                       ,
    ws_promo_sk               integer                       ,
    ws_order_number           bigint               not null,
    ws_quantity               integer                       ,
    ws_wholesale_cost         decimal(7,2)                  ,
    ws_list_price             decimal(7,2)                  ,
    ws_sales_price            decimal(7,2)                  ,
    ws_ext_discount_amt       decimal(7,2)                  ,
    ws_ext_sales_price        decimal(7,2)                  ,
    ws_ext_wholesale_cost     decimal(7,2)                  ,
    ws_ext_list_price         decimal(7,2)                  ,
    ws_ext_tax                decimal(7,2)                  ,
    ws_coupon_amt             decimal(7,2)                  ,
    ws_ext_ship_cost          decimal(7,2)                  ,
    ws_net_paid               decimal(7,2)                  ,
    ws_net_paid_inc_tax       decimal(7,2)                  ,
    ws_net_paid_inc_ship      decimal(7,2)                  ,
    ws_net_paid_inc_ship_tax  decimal(7,2)                  ,
    ws_net_profit             decimal(7,2)                  
)
--
-- set the configuration item to create foreign table
--
SERVER gsmpp_server
OPTIONS (
location 'gsobs://xxx.xxx.xxx.xxx/dws/download/dws_sample_database_data_files/web_sales/web_sales' ,
format 'text',
delimiter '|',
encoding 'utf8',
noescaping 'true',
access_key 'access_key_value_to_be_replaced',
secret_access_key 'secret_access_key_value_to_be_replaced',
reject_limit 'unlimited',
chunksize '64'
)
--
-- if create foreign table failed,record error message
--
with err_obs_from_web_sales_001;
--
-- Name: obs_from_catalog_sales_001; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create foreign table obs_from_catalog_sales_001
(
    cs_sold_date_sk           integer                       ,
    cs_sold_time_sk           integer                       ,
    cs_ship_date_sk           integer                       ,
    cs_bill_customer_sk       integer                       ,
    cs_bill_cdemo_sk          integer                       ,
    cs_bill_hdemo_sk          integer                       ,
    cs_bill_addr_sk           integer                       ,
    cs_ship_customer_sk       integer                       ,
    cs_ship_cdemo_sk          integer                       ,
    cs_ship_hdemo_sk          integer                       ,
    cs_ship_addr_sk           integer                       ,
    cs_call_center_sk         integer                       ,
    cs_catalog_page_sk        integer                       ,
    cs_ship_mode_sk           integer                       ,
    cs_warehouse_sk           integer                       ,
    cs_item_sk                integer               not null,
    cs_promo_sk               integer                       ,
    cs_order_number           bigint               not null,
    cs_quantity               integer                       ,
    cs_wholesale_cost         decimal(7,2)                  ,
    cs_list_price             decimal(7,2)                  ,
    cs_sales_price            decimal(7,2)                  ,
    cs_ext_discount_amt       decimal(7,2)                  ,
    cs_ext_sales_price        decimal(7,2)                  ,
    cs_ext_wholesale_cost     decimal(7,2)                  ,
    cs_ext_list_price         decimal(7,2)                  ,
    cs_ext_tax                decimal(7,2)                  ,
    cs_coupon_amt             decimal(7,2)                  ,
    cs_ext_ship_cost          decimal(7,2)                  ,
    cs_net_paid               decimal(7,2)                  ,
    cs_net_paid_inc_tax       decimal(7,2)                  ,
    cs_net_paid_inc_ship      decimal(7,2)                  ,
    cs_net_paid_inc_ship_tax  decimal(7,2)                  ,
    cs_net_profit             decimal(7,2)                  
)
--
-- set the configuration item to create foreign table
--
SERVER gsmpp_server
OPTIONS (
location 'gsobs://xxx.xxx.xxx.xxx/dws/download/dws_sample_database_data_files/catalog_sales/catalog_sales' ,
format 'text',
delimiter '|',
encoding 'utf8',
noescaping 'true',
access_key 'access_key_value_to_be_replaced',
secret_access_key 'secret_access_key_value_to_be_replaced',
reject_limit 'unlimited',
chunksize '64'
)
--
-- if create foreign table failed,record error message
--
with err_obs_from_catalog_sales_001;
--
-- Name: obs_from_store_sales_001; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create foreign table obs_from_store_sales_001
(
    ss_sold_date_sk           integer                       ,
    ss_sold_time_sk           integer                       ,
    ss_item_sk                integer               not null,
    ss_customer_sk            integer                       ,
    ss_cdemo_sk               integer                       ,
    ss_hdemo_sk               integer                       ,
    ss_addr_sk                integer                       ,
    ss_store_sk               integer                       ,
    ss_promo_sk               integer                       ,
    ss_ticket_number          bigint               not null,
    ss_quantity               integer                       ,
    ss_wholesale_cost         decimal(7,2)                  ,
    ss_list_price             decimal(7,2)                  ,
    ss_sales_price            decimal(7,2)                  ,
    ss_ext_discount_amt       decimal(7,2)                  ,
    ss_ext_sales_price        decimal(7,2)                  ,
    ss_ext_wholesale_cost     decimal(7,2)                  ,
    ss_ext_list_price         decimal(7,2)                  ,
    ss_ext_tax                decimal(7,2)                  ,
    ss_coupon_amt             decimal(7,2)                  ,
    ss_net_paid               decimal(7,2)                  ,
    ss_net_paid_inc_tax       decimal(7,2)                  ,
    ss_net_profit             decimal(7,2)                  
)
--
-- set the configuration item to create foreign table
--
SERVER gsmpp_server
OPTIONS (
location 'gsobs://xxx.xxx.xxx.xxx/dws/download/dws_sample_database_data_files/store_sales/store_sales' ,
format 'text',
delimiter '|',
encoding 'utf8',
noescaping 'true',
access_key 'access_key_value_to_be_replaced',
secret_access_key 'secret_access_key_value_to_be_replaced',
reject_limit 'unlimited',
chunksize '64'
)
--
-- if create foreign table failed,record error message
--
with err_obs_from_store_sales_001;



--
-- Load TPC-DS schema to GaussDB Database
--
--
-- Name: customer_address; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create table customer_address
(
    ca_address_sk             integer               not null,
    ca_address_id             char(16)              not null,
    ca_street_number          char(10)                      ,
    ca_street_name            varchar(60)                   ,
    ca_street_type            char(15)                      ,
    ca_suite_number           char(10)                      ,
    ca_city                   varchar(60)                   ,
    ca_county                 varchar(30)                   ,
    ca_state                  char(2)                       ,
    ca_zip                    char(10)                      ,
    ca_country                varchar(20)                   ,
    ca_gmt_offset             decimal(5,2)                  ,
    ca_location_type          char(20)                     
) 
 with (orientation = column,compression=middle)
 distribute by hash (ca_address_sk);

--
-- Name: customer_demographics; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create table customer_demographics
(
    cd_demo_sk                integer               not null,
    cd_gender                 char(1)                       ,
    cd_marital_status         char(1)                       ,
    cd_education_status       char(20)                      ,
    cd_purchase_estimate      integer                       ,
    cd_credit_rating          char(10)                      ,
    cd_dep_count              integer                       ,
    cd_dep_employed_count     integer                       ,
    cd_dep_college_count      integer                       
) 
 with (orientation = column,compression=middle)
 distribute by hash (cd_demo_sk);

--
-- Name: date_dim; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create table date_dim
(
    d_date_sk                 integer               not null,
    d_date_id                 char(16)              not null,
    d_date                    date                          ,
    d_month_seq               integer                       ,
    d_week_seq                integer                       ,
    d_quarter_seq             integer                       ,
    d_year                    integer                       ,
    d_dow                     integer                       ,
    d_moy                     integer                       ,
    d_dom                     integer                       ,
    d_qoy                     integer                       ,
    d_fy_year                 integer                       ,
    d_fy_quarter_seq          integer                       ,
    d_fy_week_seq             integer                       ,
    d_day_name                char(9)                       ,
    d_quarter_name            char(6)                       ,
    d_holiday                 char(1)                       ,
    d_weekend                 char(1)                       ,
    d_following_holiday       char(1)                       ,
    d_first_dom               integer                       ,
    d_last_dom                integer                       ,
    d_same_day_ly             integer                       ,
    d_same_day_lq             integer                       ,
    d_current_day             char(1)                       ,
    d_current_week            char(1)                       ,
    d_current_month           char(1)                       ,
    d_current_quarter         char(1)                       ,
    d_current_year            char(1)                       
) 
 with (orientation = column,compression=middle)
 distribute by hash (d_date_sk);

--
-- Name: warehouse; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create table warehouse
(
    w_warehouse_sk            integer               not null,
    w_warehouse_id            char(16)              not null,
    w_warehouse_name          varchar(20)                   ,
    w_warehouse_sq_ft         integer                       ,
    w_street_number           char(10)                      ,
    w_street_name             varchar(60)                   ,
    w_street_type             char(15)                      ,
    w_suite_number            char(10)                      ,
    w_city                    varchar(60)                   ,
    w_county                  varchar(30)                   ,
    w_state                   char(2)                       ,
    w_zip                     char(10)                      ,
    w_country                 varchar(20)                   ,
    w_gmt_offset              decimal(5,2)                  
) 
 with (orientation = column,compression=middle)
 distribute by replication;

--
-- Name: ship_mode; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create table ship_mode
(
    sm_ship_mode_sk           integer               not null,
    sm_ship_mode_id           char(16)              not null,
    sm_type                   char(30)                      ,
    sm_code                   char(10)                      ,
    sm_carrier                char(20)                      ,
    sm_contract               char(20)                      
) 
 with (orientation = column,compression=middle)
 distribute by replication;

--
-- Name: time_dim; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create table time_dim
(
    t_time_sk                 integer               not null,
    t_time_id                 char(16)              not null,
    t_time                    integer                       ,
    t_hour                    integer                       ,
    t_minute                  integer                       ,
    t_second                  integer                       ,
    t_am_pm                   char(2)                       ,
    t_shift                   char(20)                      ,
    t_sub_shift               char(20)                      ,
    t_meal_time               char(20)                     
) 
 with (orientation = column,compression=middle)
 distribute by hash (t_time_sk);

--
-- Name: reason; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create table reason
(
    r_reason_sk               integer               not null,
    r_reason_id               char(16)              not null,
    r_reason_desc             char(100)                    
) 
 with (orientation = column,compression=middle)
 distribute by replication;

--
-- Name: income_band; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create table income_band
(
    ib_income_band_sk         integer               not null,
    ib_lower_bound            integer                       ,
    ib_upper_bound            integer                       
) 
 with (orientation = column,compression=middle)
 distribute by replication;

--
-- Name: item; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create table item
(
    i_item_sk                 integer               not null,
    i_item_id                 char(16)              not null,
    i_rec_start_date          date                          ,
    i_rec_end_date            date                          ,
    i_item_desc               varchar(200)                  ,
    i_current_price           decimal(7,2)                  ,
    i_wholesale_cost          decimal(7,2)                  ,
    i_brand_id                integer                       ,
    i_brand                   char(50)                      ,
    i_class_id                integer                       ,
    i_class                   char(50)                      ,
    i_category_id             integer                       ,
    i_category                char(50)                      ,
    i_manufact_id             integer                       ,
    i_manufact                char(50)                      ,
    i_size                    char(20)                      ,
    i_formulation             char(20)                      ,
    i_color                   char(20)                      ,
    i_units                   char(10)                      ,
    i_container               char(10)                      ,
    i_manager_id              integer                       ,
    i_product_name            char(50)                      
) 
 with (orientation = column,compression=middle)
 distribute by hash (i_item_sk);

--
-- Name: store; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create table store
(
    s_store_sk                integer               not null,
    s_store_id                char(16)              not null,
    s_rec_start_date          date                          ,
    s_rec_end_date            date                          ,
    s_closed_date_sk          integer                       ,
    s_store_name              varchar(50)                   ,
    s_number_employees        integer                       ,
    s_floor_space             integer                       ,
    s_hours                   char(20)                      ,
    s_manager                 varchar(40)                   ,
    s_market_id               integer                       ,
    s_geography_class         varchar(100)                  ,
    s_market_desc             varchar(100)                  ,
    s_market_manager          varchar(40)                   ,
    s_division_id             integer                       ,
    s_division_name           varchar(50)                   ,
    s_company_id              integer                       ,
    s_company_name            varchar(50)                   ,
    s_street_number           varchar(10)                   ,
    s_street_name             varchar(60)                   ,
    s_street_type             char(15)                      ,
    s_suite_number            char(10)                      ,
    s_city                    varchar(60)                   ,
    s_county                  varchar(30)                   ,
    s_state                   char(2)                       ,
    s_zip                     char(10)                      ,
    s_country                 varchar(20)                   ,
    s_gmt_offset              decimal(5,2)                  ,
    s_tax_precentage          decimal(5,2)                  
) 
 with (orientation = column,compression=middle)
 distribute by replication;

--
-- Name: call_center; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create table call_center
(
    cc_call_center_sk         integer               not null,
    cc_call_center_id         char(16)              not null,
    cc_rec_start_date         date                          ,
    cc_rec_end_date           date                          ,
    cc_closed_date_sk         integer                       ,
    cc_open_date_sk           integer                       ,
    cc_name                   varchar(50)                   ,
    cc_class                  varchar(50)                   ,
    cc_employees              integer                       ,
    cc_sq_ft                  integer                       ,
    cc_hours                  char(20)                      ,
    cc_manager                varchar(40)                   ,
    cc_mkt_id                 integer                       ,
    cc_mkt_class              char(50)                      ,
    cc_mkt_desc               varchar(100)                  ,
    cc_market_manager         varchar(40)                   ,
    cc_division               integer                       ,
    cc_division_name          varchar(50)                   ,
    cc_company                integer                       ,
    cc_company_name           char(50)                      ,
    cc_street_number          char(10)                      ,
    cc_street_name            varchar(60)                   ,
    cc_street_type            char(15)                      ,
    cc_suite_number           char(10)                      ,
    cc_city                   varchar(60)                   ,
    cc_county                 varchar(30)                   ,
    cc_state                  char(2)                       ,
    cc_zip                    char(10)                      ,
    cc_country                varchar(20)                   ,
    cc_gmt_offset             decimal(5,2)                  ,
    cc_tax_percentage         decimal(5,2)                  
) 
 with (orientation = column,compression=middle)
 distribute by replication;

--
-- Name: customer; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create table customer
(
    c_customer_sk             integer               not null,
    c_customer_id             char(16)              not null,
    c_current_cdemo_sk        integer                       ,
    c_current_hdemo_sk        integer                       ,
    c_current_addr_sk         integer                       ,
    c_first_shipto_date_sk    integer                       ,
    c_first_sales_date_sk     integer                       ,
    c_salutation              char(10)                      ,
    c_first_name              char(20)                      ,
    c_last_name               char(30)                      ,
    c_preferred_cust_flag     char(1)                       ,
    c_birth_day               integer                       ,
    c_birth_month             integer                       ,
    c_birth_year              integer                       ,
    c_birth_country           varchar(20)                   ,
    c_login                   char(13)                      ,
    c_email_address           char(50)                      ,
    c_last_review_date        char(10)                      
) 
 with (orientation = column,compression=middle)
 distribute by hash (c_customer_sk);

--
-- Name: web_site; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create table web_site
(
    web_site_sk               integer               not null,
    web_site_id               char(16)              not null,
    web_rec_start_date        date                          ,
    web_rec_end_date          date                          ,
    web_name                  varchar(50)                   ,
    web_open_date_sk          integer                       ,
    web_close_date_sk         integer                       ,
    web_class                 varchar(50)                   ,
    web_manager               varchar(40)                   ,
    web_mkt_id                integer                       ,
    web_mkt_class             varchar(50)                   ,
    web_mkt_desc              varchar(100)                  ,
    web_market_manager        varchar(40)                   ,
    web_company_id            integer                       ,
    web_company_name          char(50)                      ,
    web_street_number         char(10)                      ,
    web_street_name           varchar(60)                   ,
    web_street_type           char(15)                      ,
    web_suite_number          char(10)                      ,
    web_city                  varchar(60)                   ,
    web_county                varchar(30)                   ,
    web_state                 char(2)                       ,
    web_zip                   char(10)                      ,
    web_country               varchar(20)                   ,
    web_gmt_offset            decimal(5,2)                  ,
    web_tax_percentage        decimal(5,2)                  
) 
 with (orientation = column,compression=middle)
 distribute by replication;

--
-- Name: store_returns; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create table store_returns
(
    sr_returned_date_sk       integer                       ,
    sr_return_time_sk         integer                       ,
    sr_item_sk                integer               not null,
    sr_customer_sk            integer                       ,
    sr_cdemo_sk               integer                       ,
    sr_hdemo_sk               integer                       ,
    sr_addr_sk                integer                       ,
    sr_store_sk               integer                       ,
    sr_reason_sk              integer                       ,
    sr_ticket_number          bigint               not null,
    sr_return_quantity        integer                       ,
    sr_return_amt             decimal(7,2)                  ,
    sr_return_tax             decimal(7,2)                  ,
    sr_return_amt_inc_tax     decimal(7,2)                  ,
    sr_fee                    decimal(7,2)                  ,
    sr_return_ship_cost       decimal(7,2)                  ,
    sr_refunded_cash          decimal(7,2)                  ,
    sr_reversed_charge        decimal(7,2)                  ,
    sr_store_credit           decimal(7,2)                  ,
    sr_net_loss               decimal(7,2)                  
) 
 with (orientation = column,compression=middle)
 distribute by hash (sr_item_sk);

--
-- Name: household_demographics; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create table household_demographics
(
    hd_demo_sk                integer               not null,
    hd_income_band_sk         integer                       ,
    hd_buy_potential          char(15)                      ,
    hd_dep_count              integer                       ,
    hd_vehicle_count          integer                       
) 
 with (orientation = column,compression=middle)
 distribute by hash (hd_demo_sk);

--
-- Name: web_page; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create table web_page
(
    wp_web_page_sk            integer               not null,
    wp_web_page_id            char(16)              not null,
    wp_rec_start_date         date                          ,
    wp_rec_end_date           date                          ,
    wp_creation_date_sk       integer                       ,
    wp_access_date_sk         integer                       ,
    wp_autogen_flag           char(1)                       ,
    wp_customer_sk            integer                       ,
    wp_url                    varchar(100)                  ,
    wp_type                   char(50)                      ,
    wp_char_count             integer                       ,
    wp_link_count             integer                       ,
    wp_image_count            integer                       ,
    wp_max_ad_count           integer                       
) 
 with (orientation = column,compression=middle)
 distribute by replication;

--
-- Name: promotion; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create table promotion
(
    p_promo_sk                integer               not null,
    p_promo_id                char(16)              not null,
    p_start_date_sk           integer                       ,
    p_end_date_sk             integer                       ,
    p_item_sk                 integer                       ,
    p_cost                    decimal(15,2)                 ,
    p_response_target         integer                       ,
    p_promo_name              char(50)                      ,
    p_channel_dmail           char(1)                       ,
    p_channel_email           char(1)                       ,
    p_channel_catalog         char(1)                       ,
    p_channel_tv              char(1)                       ,
    p_channel_radio           char(1)                       ,
    p_channel_press           char(1)                       ,
    p_channel_event           char(1)                       ,
    p_channel_demo            char(1)                       ,
    p_channel_details         varchar(100)                  ,
    p_purpose                 char(15)                      ,
    p_discount_active         char(1)                       
) 
 with (orientation = column,compression=middle)
 distribute by replication;

--
-- Name: catalog_page; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create table catalog_page
(
    cp_catalog_page_sk        integer               not null,
    cp_catalog_page_id        char(16)              not null,
    cp_start_date_sk          integer                       ,
    cp_end_date_sk            integer                       ,
    cp_department             varchar(50)                   ,
    cp_catalog_number         integer                       ,
    cp_catalog_page_number    integer                       ,
    cp_description            varchar(100)                  ,
    cp_type                   varchar(100)                 
) 
 with (orientation = column,compression=middle)
 distribute by hash (cp_catalog_page_sk);

--
-- Name: inventory; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create table inventory
(
    inv_date_sk               integer               not null,
    inv_item_sk               integer               not null,
    inv_warehouse_sk          integer               not null,
    inv_quantity_on_hand      integer                       
) 
 with (orientation = column,compression=middle)
 distribute by hash (inv_date_sk);

--
-- Name: catalog_returns; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create table catalog_returns
(
    cr_returned_date_sk       integer                       ,
    cr_returned_time_sk       integer                       ,
    cr_item_sk                integer               not null,
    cr_refunded_customer_sk   integer                       ,
    cr_refunded_cdemo_sk      integer                       ,
    cr_refunded_hdemo_sk      integer                       ,
    cr_refunded_addr_sk       integer                       ,
    cr_returning_customer_sk  integer                       ,
    cr_returning_cdemo_sk     integer                       ,
    cr_returning_hdemo_sk     integer                       ,
    cr_returning_addr_sk      integer                       ,
    cr_call_center_sk         integer                       ,
    cr_catalog_page_sk        integer                       ,
    cr_ship_mode_sk           integer                       ,
    cr_warehouse_sk           integer                       ,
    cr_reason_sk              integer                       ,
    cr_order_number           bigint               not null,
    cr_return_quantity        integer                       ,
    cr_return_amount          decimal(7,2)                  ,
    cr_return_tax             decimal(7,2)                  ,
    cr_return_amt_inc_tax     decimal(7,2)                  ,
    cr_fee                    decimal(7,2)                  ,
    cr_return_ship_cost       decimal(7,2)                  ,
    cr_refunded_cash          decimal(7,2)                  ,
    cr_reversed_charge        decimal(7,2)                  ,
    cr_store_credit           decimal(7,2)                  ,
    cr_net_loss               decimal(7,2)                 
) 
 with (orientation = column,compression=middle)
 distribute by hash (cr_item_sk);

--
-- Name: web_returns; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create table web_returns
(
    wr_returned_date_sk       integer                       ,
    wr_returned_time_sk       integer                       ,
    wr_item_sk                integer               not null,
    wr_refunded_customer_sk   integer                       ,
    wr_refunded_cdemo_sk      integer                       ,
    wr_refunded_hdemo_sk      integer                       ,
    wr_refunded_addr_sk       integer                       ,
    wr_returning_customer_sk  integer                       ,
    wr_returning_cdemo_sk     integer                       ,
    wr_returning_hdemo_sk     integer                       ,
    wr_returning_addr_sk      integer                       ,
    wr_web_page_sk            integer                       ,
    wr_reason_sk              integer                       ,
    wr_order_number           bigint               not null,
    wr_return_quantity        integer                       ,
    wr_return_amt             decimal(7,2)                  ,
    wr_return_tax             decimal(7,2)                  ,
    wr_return_amt_inc_tax     decimal(7,2)                  ,
    wr_fee                    decimal(7,2)                  ,
    wr_return_ship_cost       decimal(7,2)                  ,
    wr_refunded_cash          decimal(7,2)                  ,
    wr_reversed_charge        decimal(7,2)                  ,
    wr_account_credit         decimal(7,2)                  ,
    wr_net_loss               decimal(7,2)                 
) 
 with (orientation = column,compression=middle)
 distribute by hash (wr_item_sk);

--
-- Name: web_sales; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create table web_sales
(
    ws_sold_date_sk           integer                       ,
    ws_sold_time_sk           integer                       ,
    ws_ship_date_sk           integer                       ,
    ws_item_sk                integer               not null,
    ws_bill_customer_sk       integer                       ,
    ws_bill_cdemo_sk          integer                       ,
    ws_bill_hdemo_sk          integer                       ,
    ws_bill_addr_sk           integer                       ,
    ws_ship_customer_sk       integer                       ,
    ws_ship_cdemo_sk          integer                       ,
    ws_ship_hdemo_sk          integer                       ,
    ws_ship_addr_sk           integer                       ,
    ws_web_page_sk            integer                       ,
    ws_web_site_sk            integer                       ,
    ws_ship_mode_sk           integer                       ,
    ws_warehouse_sk           integer                       ,
    ws_promo_sk               integer                       ,
    ws_order_number           bigint               not null,
    ws_quantity               integer                       ,
    ws_wholesale_cost         decimal(7,2)                  ,
    ws_list_price             decimal(7,2)                  ,
    ws_sales_price            decimal(7,2)                  ,
    ws_ext_discount_amt       decimal(7,2)                  ,
    ws_ext_sales_price        decimal(7,2)                  ,
    ws_ext_wholesale_cost     decimal(7,2)                  ,
    ws_ext_list_price         decimal(7,2)                  ,
    ws_ext_tax                decimal(7,2)                  ,
    ws_coupon_amt             decimal(7,2)                  ,
    ws_ext_ship_cost          decimal(7,2)                  ,
    ws_net_paid               decimal(7,2)                  ,
    ws_net_paid_inc_tax       decimal(7,2)                  ,
    ws_net_paid_inc_ship      decimal(7,2)                  ,
    ws_net_paid_inc_ship_tax  decimal(7,2)                  ,
    ws_net_profit             decimal(7,2)                  
) 
 with (orientation = column,compression=middle)
 distribute by hash (ws_item_sk);

--
-- Name: catalog_sales; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create table catalog_sales
(
    cs_sold_date_sk           integer                       ,
    cs_sold_time_sk           integer                       ,
    cs_ship_date_sk           integer                       ,
    cs_bill_customer_sk       integer                       ,
    cs_bill_cdemo_sk          integer                       ,
    cs_bill_hdemo_sk          integer                       ,
    cs_bill_addr_sk           integer                       ,
    cs_ship_customer_sk       integer                       ,
    cs_ship_cdemo_sk          integer                       ,
    cs_ship_hdemo_sk          integer                       ,
    cs_ship_addr_sk           integer                       ,
    cs_call_center_sk         integer                       ,
    cs_catalog_page_sk        integer                       ,
    cs_ship_mode_sk           integer                       ,
    cs_warehouse_sk           integer                       ,
    cs_item_sk                integer               not null,
    cs_promo_sk               integer                       ,
    cs_order_number           bigint               not null,
    cs_quantity               integer                       ,
    cs_wholesale_cost         decimal(7,2)                  ,
    cs_list_price             decimal(7,2)                  ,
    cs_sales_price            decimal(7,2)                  ,
    cs_ext_discount_amt       decimal(7,2)                  ,
    cs_ext_sales_price        decimal(7,2)                  ,
    cs_ext_wholesale_cost     decimal(7,2)                  ,
    cs_ext_list_price         decimal(7,2)                  ,
    cs_ext_tax                decimal(7,2)                  ,
    cs_coupon_amt             decimal(7,2)                  ,
    cs_ext_ship_cost          decimal(7,2)                  ,
    cs_net_paid               decimal(7,2)                  ,
    cs_net_paid_inc_tax       decimal(7,2)                  ,
    cs_net_paid_inc_ship      decimal(7,2)                  ,
    cs_net_paid_inc_ship_tax  decimal(7,2)                  ,
    cs_net_profit             decimal(7,2)                  
) 
 with (orientation = column,compression=middle)
 distribute by hash (cs_item_sk);

--
-- Name: store_sales; Type: TABLE; Schema: public; Owner: gaussdb; Tablespace:
--
create table store_sales
(
    ss_sold_date_sk           integer                       ,
    ss_sold_time_sk           integer                       ,
    ss_item_sk                integer               not null,
    ss_customer_sk            integer                       ,
    ss_cdemo_sk               integer                       ,
    ss_hdemo_sk               integer                       ,
    ss_addr_sk                integer                       ,
    ss_store_sk               integer                       ,
    ss_promo_sk               integer                       ,
    ss_ticket_number          bigint               not null,
    ss_quantity               integer                       ,
    ss_wholesale_cost         decimal(7,2)                  ,
    ss_list_price             decimal(7,2)                  ,
    ss_sales_price            decimal(7,2)                  ,
    ss_ext_discount_amt       decimal(7,2)                  ,
    ss_ext_sales_price        decimal(7,2)                  ,
    ss_ext_wholesale_cost     decimal(7,2)                  ,
    ss_ext_list_price         decimal(7,2)                  ,
    ss_ext_tax                decimal(7,2)                  ,
    ss_coupon_amt             decimal(7,2)                  ,
    ss_net_paid               decimal(7,2)                  ,
    ss_net_paid_inc_tax       decimal(7,2)                  ,
    ss_net_profit             decimal(7,2)                  
) 
 with (orientation = column,compression=middle)
 distribute by hash (ss_item_sk);



--
-- load data from OBS to DWS
--
\timing on
set session_timeout=7200;
\parallel on 4
-- copy table obs_from_customer_address_001 to table customer_address
insert into customer_address select * from obs_from_customer_address_001 ;

-- copy table obs_from_customer_demographics_001 to table customer_demographics
insert into customer_demographics select * from obs_from_customer_demographics_001 ;

-- copy table obs_from_date_dim_001 to table date_dim
insert into date_dim select * from obs_from_date_dim_001;

-- copy table obs_from_warehouse_001 to table warehouse
insert into warehouse select * from obs_from_warehouse_001;

-- copy table obs_from_ship_mode_001 to table ship_mode
insert into ship_mode select * from obs_from_ship_mode_001;

-- copy table obs_from_time_dim_001 to table time_dim
insert into time_dim select * from obs_from_time_dim_001;

-- copy table obs_from_reason_001 to table reason
insert into reason select * from obs_from_reason_001;

-- copy table obs_from_income_band_001 to table income_band
insert into income_band select * from obs_from_income_band_001;

-- copy table obs_from_item_001 to table item
insert into item select * from obs_from_item_001;

-- copy table obs_from_store_001 to table store
insert into store select * from obs_from_store_001;

-- copy table obs_from_call_center_001 to table call_center
insert into call_center select * from obs_from_call_center_001;

-- copy table obs_from_customer_001 to table customer
insert into customer select * from obs_from_customer_001;

-- copy table obs_from_web_site_001 to table web_site
insert into web_site select * from obs_from_web_site_001;

-- copy table obs_from_store_returns_001 to table store_returns
insert into store_returns select * from obs_from_store_returns_001;

-- copy table obs_from_household_demographics_001 to table household_demographics
insert into household_demographics select * from obs_from_household_demographics_001;

-- copy table obs_from_web_page_001 to table web_page
insert into web_page select * from obs_from_web_page_001;

-- copy table obs_from_promotion_001 to table promotion
insert into promotion select * from obs_from_promotion_001;

-- copy table obs_from_catalog_page_001 to table catalog_page
insert into catalog_page select * from obs_from_catalog_page_001;

-- copy table obs_from_inventory_001 to table inventory
insert into inventory select * from obs_from_inventory_001;

-- copy table obs_from_catalog_returns_001 to table catalog_returns
insert into catalog_returns select * from obs_from_catalog_returns_001;

-- copy table obs_from_web_returns_001 to table web_returns
insert into web_returns select * from obs_from_web_returns_001;

-- copy table obs_from_web_sales_001 to table web_sales
insert into web_sales select * from obs_from_web_sales_001;

-- copy table obs_from_catalog_sales_001 to table catalog_sales
insert into catalog_sales select * from obs_from_catalog_sales_001;

-- copy table obs_from_store_sales_001 to table store_sales
insert into store_sales select * from obs_from_store_sales_001;
\parallel off

\parallel on 4
--customer_address
analyze customer_address;
--customer_demographics
analyze customer_demographics;
--date_dim
analyze date_dim;
--warehouse
analyze warehouse;
--ship_mode
analyze ship_mode;
--time_dim
analyze time_dim;
--reason
analyze reason;
--income_band
analyze income_band;
--item
analyze item;
--store
analyze store;
--call_center
analyze call_center;
--customer
analyze customer;
--web_site
analyze web_site;
--store_returns
analyze store_returns;
--household_demographics
analyze household_demographics;
--web_page
analyze web_page;
--promotion
analyze promotion;
--catalog_page
analyze catalog_page;
--inventory
analyze inventory;
--catalog_returns
analyze catalog_returns;
--web_returns
analyze web_returns;
--web_sales
analyze web_sales;
--catalog_sales
analyze catalog_sales;
--store_sales
analyze store_sales;
\parallel off
