#!/usr/bin/env python3
#-*- coding:utf-8 -*-
try:
    import sys
    import subprocess
    import importlib
    importlib.reload(sys)
    from gspylib.inspection.common import SharedFuncs
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
except ImportError as e:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(e))


class CheckBootItems(BaseItem):
    def __init__(self):
        super(CheckBootItems, self).__init__(self.__class__.__name__)

    def doCheck(self):
        self.result.rst = ResultStatus.OK
        checkItems = ["checksum", "mtu", "cgroup", "rx", "tx"]
        bootitem = []
        bootfile = ""
        if (SharedFuncs.isRedHat()):
            bootfile = "/etc/rc.d/rc.local"
        else:
            bootfile = "/etc/init.d/boot.local"
        for item in checkItems:
            cmd = "grep -i %s %s" % (item, bootfile)
            (_, output) = subprocess.getstatusoutput(cmd)
            if(output):
                bootitem.append(item)
                self.result.rst = ResultStatus.NG
        if(self.result.rst == ResultStatus.OK):
            self.result.val = "no boot item added"
        else:
            self.result.val = "boot items is added:\n%s" % "\n".join(bootitem)
