#!/usr/bin/env python3
#-*- coding:utf-8 -*-
try:
    import sys
    import importlib
    importlib.reload(sys)
    from gspylib.inspection.common import SharedFuncs
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
except ImportError as e:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(e))


class CheckIdleSession(BaseItem):
    def __init__(self):
        super(CheckIdleSession, self).__init__(self.__class__.__name__)

    def doCheck(self):
        sqlcmd = "select pid, query_id, application_name, query_start, state, query from pg_catalog.pg_stat_activity" \
                 " where state <> 'idle' and application_name not in ('JobScheduler', 'CalculateSpaceInfo'," \
                 " 'WorkloadManager', 'WLMArbiter', 'workload', 'WorkloadMonitor') and query_id <> 0 " \
                 "and query <> 'WLM fetch collect info from data nodes' and query not like '%pg_stat_activity%';"
        self.result.raw = sqlcmd
        output = SharedFuncs.runSqlCmd(sqlcmd, self.user, "", self.port, self.tmpPath, "postgres", self.mpprcFile)
        if (output != ''):
            self.result.rst = ResultStatus.NG
            self.result.val = output
        else:
            self.result.rst = ResultStatus.OK
            self.result.val = "No idle process."
