#!/usr/bin/env python3
#-*- coding:utf-8 -*-
try:
    import sys
    import importlib
    importlib.reload(sys)
    from gspylib.inspection.common import SharedFuncs
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
except ImportError as ie:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(ie))

dbList = []


class CheckDilateSysTab(BaseItem):
    def __init__(self):
        super(CheckDilateSysTab, self).__init__(self.__class__.__name__)
        self.Threshold_NG = None
        self.Threshold_Warning = None

    def preCheck(self):
        super(CheckDilateSysTab, self).preCheck()
        if (not (self.threshold.__contains__('Threshold_NG') and self.threshold.__contains__('Threshold_Warning'))):
            raise Exception("The threshold Threshold_NG and Threshold_Warning can not be empty.")
        if (not self.threshold['Threshold_NG'].isdigit() or not self.threshold['Threshold_Warning'].isdigit()):
            raise Exception("The threshold Threshold_NG and Threshold_Warning must be integer.")
        self.Threshold_NG = int(self.threshold['Threshold_NG'])
        self.Threshold_Warning = int(self.threshold['Threshold_Warning'])

    def doCheck(self):
        global dbList
        self.result.rst = ResultStatus.OK
        sqldb = "select datname from pg_catalog.pg_database;"
        output = SharedFuncs.runSqlCmd(sqldb, self.user, "", self.port, self.tmpPath, "postgres", self.mpprcFile)
        dbList = output.split("\n")
        dbList.remove("template0")
        sql = "select (pg_table_size(1259)/count(*)/247.172)::numeric(10,3) from pg_catalog.pg_class;"
        result = []
        for db in dbList:
            # Calculate the size with sql cmd
            output = SharedFuncs.runSqlCmd(sql, self.user, "", self.port, self.tmpPath, db, self.mpprcFile)
            if(float(output) > self.Threshold_NG):
                self.result.rst = ResultStatus.NG
                result.append(db)
            elif(float(output) > self.Threshold_Warning):
                result.append(db)
                if(self.result.rst == ResultStatus.OK):
                    self.result.rst = ResultStatus.WARNING

        if(self.result.rst == ResultStatus.OK):
            self.result.val = "no system table dilate"
        else:
            self.result.val = "there is system table dilate in databases:\n%s" % "\n".join(result)

    def doSet(self):
        reslutStr = ""
        sqlCmd = "cluster pg_catalog.pg_attribute using pg_attribute_relid_attnum_index;"\
                 "cluster pg_catalog.pg_class using pg_class_oid_index;"\
                 "cluster pg_catalog.pg_type using pg_type_oid_index;"\
                 "cluster pg_catalog.pg_proc using pg_proc_oid_index;"\
                 "cluster pg_catalog.pg_depend using pg_depend_depender_index;"\
                 "cluster pg_catalog.pg_index using pg_index_indexrelid_index;"\
                 "cluster pg_catalog.pg_namespace using pg_namespace_oid_index;"\
                 "cluster pg_catalog.pgxc_class using pgxc_class_pcrelid_index;"\
                 "vacuum full pg_catalog.pg_statistic;"
        for databaseName in dbList:
            for sql in sqlCmd.split(';'):
                output = SharedFuncs.runSqlCmd(sql, self.user, "", self.port, self.tmpPath, databaseName,
                                               self.mpprcFile)
                reslutStr += output
        self.result.val = reslutStr
