#!/usr/bin/env python3
# -*- coding:utf-8 -*-
#############################################################################
# Copyright (c): 2012-2017, Huawei Tech. Co., Ltd.
# Description  : instanceInfo.py is a utility to get instance information
#############################################################################
INSTANCE_TYPE_UNDEFINED = -1
INSTANCE_ROLE_UNDEFINED = -1


class instanceInfo():
    """
    Instance information
    """

    def __init__(self, instId=0, mirrorId=0):
        """
        Constructor
        """
        # instance id
        self.instanceId = instId
        self.mirrorId = mirrorId
        # host name
        self.hostname = ""
        # listen ip
        self.listenIps = []
        # ha ip
        self.haIps = []
        # port
        self.port = 0
        # It's pool port for coordinator, and ha port for other instance
        self.haPort = 0
        # data directory
        self.datadir = ""
        # ssd data directory
        self.ssdDir = ""
        # instance type
        self.instanceType = INSTANCE_TYPE_UNDEFINED
        # instance role
        self.instanceRole = INSTANCE_ROLE_UNDEFINED

        self.level = 1
        # we use port and haPort to save peerPort/clientPort for etcd
        # datanode: use haPort to save replport
        # repl port
        self.replport = 0
        self.azName = ""
        self.clusterName = ""
        # peer port etcd
        self.peerPort = 0
        # client port  etcd
        self.clientPort = 0
        # instance name
        self.name = ""
        # only init value
        # sctp port for tp/ap
        self.sctpPort = 0
        # control port for tp/ap
        self.controlPort = 0
        # service port for ap
        self.servicePort = 0

    def __cmp__(self, target):
        """
        Type compare
        """
        if type(self) != type(target):
            return 1
        if not isinstance(target, instanceInfo):
            return 1
        if not hasattr(target, "instanceId"):
            return 1
        else:
            return self.instanceId - target.instanceId

    def __str__(self):
        """
        Construct a printable string representation of a instanceInfo
        """
        ret = "InstanceId=%s,MirrorId=%s,Host=%s,Port=%s,DataDir=%s,SsdDir=%s," \
              "InstanceType=%s,Role=%s,ListenIps=%s,HaIps=%s" % \
              (self.instanceId, self.mirrorId, self.hostname, self.port, self.datadir, self.ssdDir,
               self.instanceType, self.instanceRole, self.listenIps, self.haIps)
        if self.replport:
            ret += ",replport=%s" % self.replport
        if self.sctpPort:
            ret += ",sctpPort=%s" % self.sctpPort
        if self.controlPort:
            ret += ",controlPort=%s" % self.controlPort
        if self.servicePort:
            ret += ",servicePort=%s" % self.servicePort
        if self.azName:
            ret += ",azName=%s" % self.azName
        if self.clusterName:
            ret += ",clusterName=%s" % self.clusterName
        if self.peerPort:
            ret += ",peerPort=%s" % self.peerPort
        if self.clientPort:
            ret += ",clientPort=%s" % self.clientPort
        if self.name:
            ret += ",name=%s" % self.name
        return ret
