/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLInput;
import java.sql.SQLNonTransientException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;

public class SQLInputFromChunk
implements SQLInput {
    private ByteBuffer m_bb;
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static ByteOrder scalarOrder;
    private static ByteOrder mirrorOrder;

    public SQLInputFromChunk(ByteBuffer byteBuffer, boolean bl) throws SQLException {
        this.m_bb = byteBuffer;
        if (bl) {
            if (null == scalarOrder) {
                scalarOrder = this.getOrder(true);
            }
            this.m_bb.order(scalarOrder);
        } else {
            if (null == mirrorOrder) {
                mirrorOrder = this.getOrder(false);
            }
            this.m_bb.order(mirrorOrder);
        }
    }

    private ByteOrder getOrder(boolean bl) throws SQLException {
        ByteOrder byteOrder;
        String string = "org.postgresql.pljava.udt.byteorder." + (bl ? "scalar" : "mirror") + ".p2j";
        String string2 = System.getProperty(string);
        if ("big_endian".equals(string2)) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        } else if ("little_endian".equals(string2)) {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else if ("native".equals(string2)) {
            byteOrder = ByteOrder.nativeOrder();
        } else {
            throw new SQLNonTransientException("System property " + string + " must be big_endian, little_endian, or native", "F0000");
        }
        return byteOrder;
    }

    @Override
    public Array readArray() throws SQLException {
        throw this.unsupportedOperationException("readArray");
    }

    @Override
    public InputStream readAsciiStream() throws SQLException {
        throw this.unsupportedOperationException("readAsciiStream");
    }

    @Override
    public BigDecimal readBigDecimal() throws SQLException {
        return new BigDecimal(this.readString());
    }

    @Override
    public InputStream readBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.readBytes());
    }

    @Override
    public Blob readBlob() throws SQLException {
        throw this.unsupportedOperationException("readBlob");
    }

    @Override
    public boolean readBoolean() throws SQLException {
        try {
            return 0 != this.m_bb.get();
        }
        catch (Exception exception) {
            throw this.badRepresentation(exception);
        }
    }

    @Override
    public byte readByte() throws SQLException {
        try {
            return this.m_bb.get();
        }
        catch (Exception exception) {
            throw this.badRepresentation(exception);
        }
    }

    @Override
    public byte[] readBytes() throws SQLException {
        try {
            int n = this.m_bb.getShort() & 0xFFFF;
            byte[] byArray = new byte[n];
            this.m_bb.get(byArray);
            return byArray;
        }
        catch (Exception exception) {
            throw this.badRepresentation(exception);
        }
    }

    @Override
    public Reader readCharacterStream() throws SQLException {
        return new StringReader(this.readString());
    }

    @Override
    public Clob readClob() throws SQLException {
        throw this.unsupportedOperationException("readClob");
    }

    @Override
    public Date readDate() throws SQLException {
        try {
            return new Date(this.m_bb.getLong());
        }
        catch (Exception exception) {
            throw this.badRepresentation(exception);
        }
    }

    @Override
    public double readDouble() throws SQLException {
        try {
            return this.m_bb.getDouble();
        }
        catch (Exception exception) {
            throw this.badRepresentation(exception);
        }
    }

    @Override
    public float readFloat() throws SQLException {
        try {
            return this.m_bb.getFloat();
        }
        catch (Exception exception) {
            throw this.badRepresentation(exception);
        }
    }

    @Override
    public int readInt() throws SQLException {
        try {
            return this.m_bb.getInt();
        }
        catch (Exception exception) {
            throw this.badRepresentation(exception);
        }
    }

    @Override
    public long readLong() throws SQLException {
        try {
            return this.m_bb.getLong();
        }
        catch (Exception exception) {
            throw this.badRepresentation(exception);
        }
    }

    @Override
    public Object readObject() throws SQLException {
        throw this.unsupportedOperationException("readObject");
    }

    @Override
    public Ref readRef() throws SQLException {
        throw this.unsupportedOperationException("readRef");
    }

    @Override
    public short readShort() throws SQLException {
        try {
            return this.m_bb.getShort();
        }
        catch (Exception exception) {
            throw this.badRepresentation(exception);
        }
    }

    @Override
    public String readString() throws SQLException {
        try {
            int n = this.m_bb.getShort() & 0xFFFF;
            ByteBuffer byteBuffer = (ByteBuffer)this.m_bb.slice().limit(n);
            this.m_bb.position(this.m_bb.position() + n);
            return UTF8.newDecoder().decode(byteBuffer).toString();
        }
        catch (Exception exception) {
            throw this.badRepresentation(exception);
        }
    }

    @Override
    public Time readTime() throws SQLException {
        try {
            return new Time(this.m_bb.getLong());
        }
        catch (Exception exception) {
            throw this.badRepresentation(exception);
        }
    }

    @Override
    public Timestamp readTimestamp() throws SQLException {
        try {
            return new Timestamp(this.m_bb.getLong());
        }
        catch (Exception exception) {
            throw this.badRepresentation(exception);
        }
    }

    @Override
    public URL readURL() throws SQLException {
        try {
            return new URL(this.readString());
        }
        catch (Exception exception) {
            throw this.badRepresentation(exception);
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        return false;
    }

    void close() {
        this.m_bb = null;
    }

    private SQLException badRepresentation(Throwable throwable) {
        if (throwable instanceof NullPointerException) {
            return new SQLNonTransientException("attempted read from SQLInput after closing it", "55000", throwable);
        }
        return new SQLDataException("Could not read binary representation of user-defined type", "22P03", throwable);
    }

    private SQLException unsupportedOperationException(String string) {
        return new SQLFeatureNotSupportedException(this.getClass() + "." + string + "() not implemented yet.", "0A000");
    }

    @Override
    public RowId readRowId() throws SQLException {
        throw this.unsupportedOperationException("readRowId");
    }

    @Override
    public SQLXML readSQLXML() throws SQLException {
        throw this.unsupportedOperationException("readSQLXML");
    }

    @Override
    public String readNString() throws SQLException {
        throw this.unsupportedOperationException("readNString");
    }

    @Override
    public NClob readNClob() throws SQLException {
        throw this.unsupportedOperationException("readNClob");
    }
}

