# ---------------platforms--------------------
SUPPORTED_DISTS = (
    'SuSE', 'UnitedLinux',
    'debian', 'kylin', 'uos',
    'fedora', 'redhat', 'centos', 'oracle', 'euleros', 'rocks', 'yellowdog', 'turbolinux',
    'mandriva', 'mandrake',
    'slackware',
    'gentoo', 'HopeOS',
    'hce', 'bclinux')

# global variable for our platform
SUSE = "suse"

REDHAT = "redhat"
CENTOS = "centos"
ORACLE = "oracle"
HCEOS = "hce"

EULEROS = "euleros"

KYLIN = "kylin"
UNIONTECH = "uos"
OPENEULER = "openeuler"
FUSIONOS = "fusionos"
BCLINUX = "bclinux"
HOPEOS = "hopeos"

RHEL_MASTER_PLATFORM_LIST = [REDHAT, CENTOS, ORACLE]
RHEL_DERIVATION_PLATFORM_LIST = [EULEROS, HCEOS]
RHEL_SERIES_VERSION_LIST = RHEL_MASTER_PLATFORM_LIST + RHEL_DERIVATION_PLATFORM_LIST
# Compatible new OSs are Euler variants.
OTHER_PLATFORM_LIST = [KYLIN, UNIONTECH, OPENEULER, FUSIONOS, BCLINUX, HOPEOS]
SUPPORT_WHOLE_PLATFORM_LIST = [SUSE] + RHEL_SERIES_VERSION_LIST + OTHER_PLATFORM_LIST
# OS dependency library conflicting version list
# SuSE15 Sp4
CONFLICTING_OS_LIST = [SUSE, KYLIN]
CONFLICTING_SUSE_LARGE_VERSION_LIST = ['15']
CONFLICTING_SUSE_MINOR_VERSION_LIST = ['15.1', '15.2', '15.3', '15.4', '15.5']
CONFLICTING_KYLIN_LARGE_VERSION_LIST = ['10']
CONFLICTING_KYLIN_MINOR_VERSION_LIST = ['SP1', 'SP2','SP3']

BIT_VERSION = "64bit"
JRE = "JRE"
########################################################################################################
# do not support systemctl
########################################################################################################
RHEL6 = "6"
SUSE11 = "11"

########################################################################################################
# Mapping for lvs module files
# SuSE11.1              -> SUSE11SP1
# SuSE11.2 11.2 11.4    -> SUSE11SP2
# SuSE12.0 12.1         -> SUSE11SP2
# SuSE12.2 ...          -> SUSE12SP2
# SuSE15.0 ...         -> SUSE12SP2
#
# RHEL_MASTER_PLATFORM_LIST 6.4     ->RHEL6_4
# Other RHEL_MASTER_PLATFORM_LIST   ->RHEL6_5
# OTHER_PLATFORM_LIST               ->RHEL6_5
######################################################################################################
SUSE15 = "15"
MODULE_FILE_LIST_FOR_RHEL6_4 = ["ip_vs.ko", "ip_vs_dh.ko", "ip_vs_ftp.ko", "ip_vs_lblc.ko", "ip_vs_lblcr.ko",
                                "ip_vs_lc.ko", "ip_vs_nq.ko", "ip_vs_rr.ko", "ip_vs_sed.ko", "ip_vs_sh.ko",
                                "ip_vs_wlc.ko", "ip_vs_wrr.ko"]
MODULE_FILE_LIST_FOR_RHEL6_5 = ["ip_vs.ko", "ip_vs_dh.ko", "ip_vs_ftp.ko", "ip_vs_lblc.ko", "ip_vs_lblcr.ko",
                                "ip_vs_lc.ko", "ip_vs_nq.ko", "ip_vs_pe_sip.ko", "ip_vs_rr.ko", "ip_vs_sed.ko",
                                "ip_vs_sh.ko", "ip_vs_wlc.ko", "ip_vs_wrr.ko"]
MODULE_FILE_LIST_FOR_SUSE11SP1 = ["ip_vs.ko", "ip_vs_dh.ko", "ip_vs_ftp.ko", "ip_vs_lblc.ko", "ip_vs_lblcr.ko",
                                  "ip_vs_lc.ko", "ip_vs_nq.ko", "ip_vs_rr.ko", "ip_vs_sed.ko", "ip_vs_sh.ko",
                                  "ip_vs_wlc.ko", "ip_vs_wrr.ko"]
MODULE_FILE_LIST_FOR_SUSE11SP2 = ["ip_vs.ko", "ip_vs_dh.ko", "ip_vs_ftp.ko", "ip_vs_lblc.ko", "ip_vs_lblcr.ko",
                                  "ip_vs_lc.ko", "ip_vs_nq.ko", "ip_vs_pe_sip.ko", "ip_vs_rr.ko", "ip_vs_sed.ko",
                                  "ip_vs_sh.ko", "ip_vs_wlc.ko", "ip_vs_wrr.ko"]
MODULE_FILE_LIST_FOR_SUSE12SP2 = ["ip_vs.ko", "ip_vs_dh.ko", "ip_vs_fo.ko", "ip_vs_ftp.ko", "ip_vs_lblc.ko",
                                  "ip_vs_lblcr.ko", "ip_vs_lc.ko", "ip_vs_nq.ko", "ip_vs_ovf.ko", "ip_vs_pe_sip.ko",
                                  "ip_vs_rr.ko", "ip_vs_sed.ko", "ip_vs_sh.ko", "ip_vs_wlc.ko", "ip_vs_wrr.ko"]

# ---------------command path--------------------
CMD_PATH = ['/bin', '/usr/local/bin', '/usr/bin', '/sbin', '/usr/sbin']
BLANK_SPACE = " "
COLON = ":"
