#!/usr/bin/env python3
#-*- coding:utf-8 -*-
try:
    import sys
    import importlib
    importlib.reload(sys)
    import os
    import subprocess
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
    from gspylib.os.gsfile import g_file
    from gspylib.os.gsplatform import g_Platform
except ImportError as ie:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(ie))

rmDir = []


class CheckDirLeft(BaseItem):
    def __init__(self):
        super(CheckDirLeft, self).__init__(self.__class__.__name__)
        self.directoryList = None

    def preCheck(self):
        # check current node contains cn instances if not raise  exception
        super(CheckDirLeft, self).preCheck()
        # check the threshold was set correctly
        if (not self.threshold.__contains__('directoryList')):
            raise Exception("threshold directoryList can not be empty")
        self.directoryList = self.threshold['directoryList'].split(',')

    def doCheck(self):
        global rmDir
        parRes = ""
        flag = 0
        mountDir = []
        mountList = g_file.readFile(g_Platform.getMtablFile())
        for line in mountList:
            mountInfo = line.strip()
            if (not mountInfo.startswith('#') and len(mountInfo.split()) > 5):
                mountDir.append(mountInfo.split()[1])
        for dirName in self.directoryList:
            if (os.path.exists(dirName)):
                flagNumber = True
                for mdir in mountDir:
                    if (len(mdir) >= len(dirName)):
                        if (mdir[0:len(dirName)] == dirName):
                            flagNumber = False
                            break
                if (not flagNumber):
                    continue

                parRes += "\nThe directory of %s exists." % dirName
                rmDir.append(dirName)
                flag = 1

        if (flag == 1):
            self.result.rst = ResultStatus.NG
        else:
            self.result.rst = ResultStatus.OK
        self.result.val = parRes
        self.result.raw = "mount directory: %s" % mountDir

    def doSet(self):
        errMsg = ""
        for path in rmDir:
            if (os.path.exists(path)):
                cmd = "rm -rf %s" % path
                (status, output) = subprocess.getstatusoutput(cmd)
                if (status != 0):
                    errMsg += "Failed to delete %s.Error: %s\n" % (path, output)
        if (errMsg):
            self.result.val = errMsg
        else:
            self.result.val = "Successfully clean up file residues.\n"
