#!/usr/bin/env python3
# -*- coding:utf-8 -*-

try:
    import sys
    import importlib

    importlib.reload(sys)
    from gspylib.inspection.common import SharedFuncs
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
    from gspylib.os.gsfile import g_file
except ImportError as ie:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(ie))


class CheckUsedPort(BaseItem):
    def __init__(self):
        super(CheckUsedPort, self).__init__(self.__class__.__name__)

    def getPortRange(self):
        portRangeValue = g_file.readFile('/proc/sys/net/ipv4/ip_local_port_range')[0]
        (startPort, endPort) = portRangeValue.split()
        portRange = int(endPort) - int(startPort)

        return portRange

    def getTcpUsedPort(self):
        cmd = "netstat -ano|awk '{print $4}'|grep '%s'|sort|uniq -c|grep ' 1 '|wc -l" % self.ipAddr
        tcpUsed = SharedFuncs.runShellCmd(cmd)

        return int(tcpUsed)

    def getSctpUsedPort(self):
        cmd = "cat /proc/net/sctp/assocs|awk '{print $12}'|sort|uniq -c |wc -l"
        sctpUsed = SharedFuncs.runShellCmd(cmd)

        return int(sctpUsed)

    def doCheck(self):
        self.ipAddr, self.service_network_adapt, self.service_network_adapts = \
            SharedFuncs.getLocalIP(self.nodes, self.all_network_info)

        portRange = self.getPortRange()
        tcpUsed = self.getTcpUsedPort()
        sctpUsed = self.getSctpUsedPort()
        defaultPortRange = 60000 - 32768
        if (portRange < defaultPortRange):
            self.result.rst = ResultStatus.WARNING
            self.result.val = "port range is %s,Check items are not passed." % portRange
            return

        if (tcpUsed > portRange * 0.8):
            self.result.rst = ResultStatus.WARNING
            self.result.val = "tcp port used is %s,Check items are not passed." % tcpUsed
            return

        if (sctpUsed > portRange * 0.8):
            self.result.rst = ResultStatus.WARNING
            self.result.val = "sctp port used is %s,Check items are not passed." % sctpUsed
            return

        self.result.rst = ResultStatus.OK
        self.result.val = "port range is %s,tcp port used is %s,sctp port used is %d,Check items pass." \
                          % (portRange, tcpUsed, sctpUsed)
        return
