#!/usr/bin/env python3
# coding: UTF-8
try:
    import sys
    import importlib
    importlib.reload(sys)
    from gspylib.inspection.common import SharedFuncs
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
except ImportError as ie:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(ie))


class CheckSysadminUser(BaseItem):
    def __init__(self):
        super(CheckSysadminUser, self).__init__(self.__class__.__name__)

    def doCheck(self):
        sqlcmd = "select rolname from pg_catalog.pg_roles where rolsystemadmin=True and rolname !='%s';" % self.user
        self.result.raw = sqlcmd
        output = SharedFuncs.runSqlCmd(sqlcmd, self.user, "", self.port, self.tmpPath, "postgres", self.mpprcFile)
        if (output):
            self.result.rst = ResultStatus.NG
            self.result.val = "There are sysadmin users except %s:\n%s" % (self.user, output)
        else:
            self.result.rst = ResultStatus.OK
            self.result.val = "Sysadmin user does not exist except %s." % self.user
