#!/usr/bin/env python3
#-*- coding:utf-8 -*-
try:
    import sys
    import importlib
    importlib.reload(sys)
    import subprocess
    from gspylib.inspection.common import SharedFuncs
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
except ImportError as e:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(e))


class CheckArchiveParameter(BaseItem):
    def __init__(self):
        super(CheckArchiveParameter, self).__init__(self.__class__.__name__)

    def doCheck(self):
        sqlcmd = "show archive_mode;"
        self.result.raw = sqlcmd

        output = SharedFuncs.runSqlCmd(sqlcmd, self.user, "", self.port, self.tmpPath, "postgres", self.mpprcFile)
        if output.strip() == "on":
            sqlcmd = "show archive_command;"
            self.result.raw = sqlcmd
            output = SharedFuncs.runSqlCmd(sqlcmd, self.user, "", self.port, self.tmpPath, "postgres", self.mpprcFile)
            if self.cluster.isSingleInstCluster():
                dataInst = self.cluster.getDbNodeByName(self.host).datanodes[0]
                if not (output.find("%s" % dataInst.datadir) >= 0):
                    self.result.rst = ResultStatus.NG
                else:
                    self.result.rst = ResultStatus.OK
            else:
                cooInst = self.cluster.getDbNodeByName(self.host).coordinators[0]
                if not (output.find("%s" % cooInst.datadir) >= 0):
                    self.result.rst = ResultStatus.NG
                else:
                    self.result.rst = ResultStatus.OK
        else:
            self.result.rst = ResultStatus.OK
        self.result.val = output

    def doSet(self):
        resultStr = ""
        cooInst = None
        dataInst = None
        if self.cluster.isSingleInstCluster():
            dataInst = self.cluster.getDbNodeByName(self.host).datanodes[0]
            cmd = "gs_guc reload -N all -Z datanode -I all -c \"archive_command = 'cp -P --remove-destination %s" \
                  " %s/pg_xlog/archive/%s'\" " % ("%p", dataInst.datadir, "%f")
        else:
            cooInst = self.cluster.getDbNodeByName(self.host).coordinators[0]
            cmd = "gs_guc reload -N all -Z coordinator -I all -c \"archive_command = 'cp -P --remove-destination %s" \
                  " %s/pg_xlog/archive/%s'\"" % ("%p", cooInst.datadir, "%f")
        (status, output) = subprocess.getstatusoutput(cmd)
        if (status != 0):
            resultStr = "Failed to set ArchiveMode.\n Error : %s" % output
        else:
            resultStr = "Set ArchiveMode successfully."
        self.result.val = resultStr
