#!/usr/bin/env python3
#-*- coding:utf-8 -*-

try:
    import sys
    import importlib
    importlib.reload(sys)
    import os
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
    from gspylib.os.gsfile import g_file
except ImportError as ie:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(ie))


class CheckUpVer(BaseItem):
    def __init__(self):
        super(CheckUpVer, self).__init__(self.__class__.__name__)
        self.upgradepath = None

    def preCheck(self):
        # check the threshold was set correctly
        if (not self.threshold.__contains__("upgradepath")):
            raise Exception("The upgrade path should be set in scene config file.")
        self.upgradepath = self.threshold['upgradepath']
        if (not os.path.isfile(os.path.join(self.upgradepath, "version.cfg"))):
            raise Exception("The new version file[%s] is not exist." % os.path.join(self.upgradepath, "version.cfg"))

    def doCheck(self):
        packageFile = os.path.realpath(os.path.join(self.upgradepath, "version.cfg"))
        output = g_file.readFile(packageFile)
        self.result.rst = ResultStatus.OK
        self.result.val = "".join(output)
