#!/usr/bin/env python3
# -*- coding:utf-8 -*-

try:
    import sys
    import importlib

    importlib.reload(sys)
    import subprocess
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
except ImportError as ie:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(ie))


class CheckProcessStatus(BaseItem):
    def __init__(self):
        super(CheckProcessStatus, self).__init__(self.__class__.__name__)

    def doCheck(self):
        parRes = ""
        flag = 0
        self.result.raw = ""
        processList = ['om_monitor', 'cm_agent', 'cm_server', 'gs_gtm', 'gaussdb --coordinator', 'gaussdb --datanode']
        for process in processList:
            # Query process status
            cmd = "ps -u %s -N | grep '\<%s\>'" % (self.user, process)
            self.result.raw = "%s%s\n" % (self.result.raw, cmd)
            (status, output) = subprocess.getstatusoutput(cmd)
            # Resolve and outputs the execution results
            if status == 0 and output.find("%s" % process) >= 0:
                parRes = "%s\n        %s" % (parRes, output)
                flag = 1
        if flag == 1:
            self.result.rst = ResultStatus.NG
            self.result.val = parRes
        else:
            self.result.rst = ResultStatus.OK
            self.result.val = "All process Status is Normal."
