#!/usr/bin/env python3
#-*- coding:utf-8 -*-

try:
    import sys
    import importlib
    importlib.reload(sys)
    import os
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
    from gspylib.os.gsfile import g_file
except ImportError as ie:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(ie))


class CheckIntegrity(BaseItem):
    def __init__(self):
        super(CheckIntegrity, self).__init__(self.__class__.__name__)

    def doCheck(self):
        gaussHome = self.cluster.appPath
        gaussdbFile = os.path.join(gaussHome, "bin/gaussdb")
        gaussdbIntegrity = g_file.getFileSHA256(gaussdbFile)
        self.result.raw = gaussdbIntegrity
        if (gaussdbIntegrity != "" and len(gaussdbIntegrity) == 64):
            self.result.rst = ResultStatus.OK
            self.result.val = "gaussdb sha256sum: %s" % gaussdbIntegrity
        else:
            self.result.rst = ResultStatus.NG
            self.result.val = "Filed to obtain gaussdb sha256 value. Error:\n%s" % gaussdbIntegrity
