#!/usr/bin/env python3
#-*- coding:utf-8 -*-
try:
    import sys
    import importlib
    importlib.reload(sys)
    from gspylib.inspection.common import SharedFuncs
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
    from gspylib.common.Common import ClusterCommand
except ImportError as e:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(e))


class CheckBalanceState(BaseItem):
    def __init__(self):
        super(CheckBalanceState, self).__init__(self.__class__.__name__)

    def doCheck(self):
        balanceResult = ""
        # Check whether the cluster needs to be balanced
        cmd = ClusterCommand.getQueryStatusCmd(self.user) + 'C'
        Result = SharedFuncs.runShellCmd(cmd, self.user, self.mpprcFile)
        for line in Result.split('\n'):
            if (line.find('balanced') >= 0):
                balanceResult = line
                break
        self.result.val = balanceResult
        if (balanceResult == ""):
            self.result.val = "No info of balanced."
            self.result.rst = ResultStatus.NG
        elif (balanceResult.split(":")[1].strip() != "Yes"):
            self.result.rst = ResultStatus.WARNING
        else:
            self.result.rst = ResultStatus.OK
