#!/usr/bin/env python3
# -*- coding:utf-8 -*-
#############################################################################
# Copyright (c): 2012-2017, Huawei Tech. Co., Ltd.
# Description  : temp file management is a utility with a lot of manage temp file functions
#############################################################################
try:
    import os
    import sys

    localDirPath = os.path.dirname(os.path.realpath(__file__))
    sys.path.insert(0, localDirPath + "/../../../../lib")
    sys.path.append(localDirPath + "/../../../")
    from gspylib.os.gsfile import g_file
    from gspylib.common.common.default_value import DefaultValue
except ImportError as ie:
    sys.exit("[GAUSS-52200] : Unable to import module: %s." % str(ie))


class TempfileManagement():
    """
    create and remove temp file or directory
    """

    def __init__(self):
        """
        function: init function
        input: NA
        output: NA
        """
        return None

    @staticmethod
    def getTempDir(dirName):
        """
        function: create temp directory in PGHOST
        input: dirName
        output:
              pathName
        """
        tmpPath = DefaultValue.getTmpDirFromEnv()
        pathName = os.path.join(tmpPath, dirName)
        return pathName

    @staticmethod
    def removeTempFile(filename, Fuzzy=False):
        """
        function: remove temp files in PGHOST
        input:
              fileName string  Specified file name or keywords
              Fuzzy    bool    Whether to remove files with the same prefix, default is False
        output: NA
        """

        if Fuzzy:
            keywords = filename + "*"
            g_file.removeFile(keywords, "shell")
        else:
            g_file.removeFile(filename)
