/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.management;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.postgresql.pljava.Session;
import org.postgresql.pljava.SessionManager;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.sqlgen.Lexicals;

public abstract class DDRExecutor {
    private static final DDRExecutor PLAIN = new Plain();
    private static final DDRExecutor NOOP = new Noop();
    private static final Pattern settingsRx = Pattern.compile(String.format("\\G(%1$s)(,\\s*)?", Lexicals.ISO_PG_JAVA_IDENTIFIER));

    protected DDRExecutor() {
    }

    public abstract void execute(String var1, Connection var2) throws SQLException;

    public static DDRExecutor forImplementor(String string) throws SQLException {
        String[] stringArray;
        if (null == string) {
            return PLAIN;
        }
        for (String string2 : stringArray = DDRExecutor.implementors()) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return PLAIN;
        }
        return NOOP;
    }

    private static String[] implementors() throws SQLException {
        String string = Backend.getConfigOption("pljava.implementors");
        ArrayList<String> arrayList = new ArrayList<String>();
        Matcher matcher = settingsRx.matcher(string);
        while (matcher.find()) {
            arrayList.add(matcher.group(1));
            if (-1 != matcher.start(2) || !matcher.hitEnd()) continue;
            return arrayList.toArray(new String[arrayList.size()]);
        }
        throw new SQLException("Failed to parse current pljava.implementors");
    }

    static class Plain
    extends DDRExecutor {
        Plain() {
        }

        @Override
        public void execute(String string, Connection connection) throws SQLException {
            Session session = SessionManager.current();
            session.executeAsOuterUser(connection, string);
        }
    }

    static class Noop
    extends DDRExecutor {
        Noop() {
        }

        @Override
        public void execute(String string, Connection connection) throws SQLException {
        }
    }
}

