/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.postgresql.pljava.ObjectPool;
import org.postgresql.pljava.SavepointListener;
import org.postgresql.pljava.TransactionListener;
import org.postgresql.pljava.internal.AclId;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.ELogHandler;
import org.postgresql.pljava.internal.ObjectPoolImpl;
import org.postgresql.pljava.internal.SubXactListener;
import org.postgresql.pljava.internal.TransactionalMap;
import org.postgresql.pljava.internal.XactListener;
import org.postgresql.pljava.jdbc.SQLUtils;

public class Session
implements org.postgresql.pljava.Session {
    private final TransactionalMap m_attributes = new TransactionalMap((Map)new HashMap());

    @Override
    public void addTransactionListener(TransactionListener transactionListener) {
        XactListener.addListener(transactionListener);
    }

    @Override
    public void addSavepointListener(SavepointListener savepointListener) {
        SubXactListener.addListener(savepointListener);
    }

    @Override
    public Object getAttribute(String string) {
        return this.m_attributes.get(string);
    }

    @Override
    public ObjectPool getObjectPool(Class clazz) {
        return ObjectPoolImpl.getObjectPool(clazz);
    }

    @Override
    public String getUserName() {
        return AclId.getUser().getName();
    }

    @Override
    public String getOuterUserName() {
        return AclId.getOuterUser().getName();
    }

    @Override
    public String getSessionUserName() {
        return this.getOuterUserName();
    }

    @Override
    public void removeAttribute(String string) {
        this.m_attributes.remove(string);
    }

    @Override
    public void setAttribute(String string, Object object) {
        this.m_attributes.put(string, object);
    }

    @Override
    public void removeTransactionListener(TransactionListener transactionListener) {
        XactListener.removeListener(transactionListener);
    }

    @Override
    public void removeSavepointListener(SavepointListener savepointListener) {
        SubXactListener.removeListener(savepointListener);
    }

    @Override
    public void executeAsSessionUser(Connection connection, String string) throws SQLException {
        this.executeAsOuterUser(connection, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeAsOuterUser(Connection connection, String string) throws SQLException {
        Statement statement = connection.createStatement();
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            ResultSet resultSet = null;
            AclId aclId = AclId.getOuterUser();
            AclId aclId2 = AclId.getUser();
            boolean bl = false;
            boolean bl2 = false;
            try {
                bl = Session._setUser(aclId, true);
                bl2 = true;
                if (statement.execute(string)) {
                    resultSet = statement.getResultSet();
                    resultSet.next();
                }
            }
            finally {
                SQLUtils.close(resultSet);
                SQLUtils.close(statement);
                if (bl2) {
                    Session._setUser(aclId2, bl);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getOuterUserSchema() throws SQLException {
        Statement statement = SQLUtils.getDefaultConnection().createStatement();
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            block7: {
                String string;
                ResultSet resultSet = null;
                AclId aclId2 = AclId.getSessionUser();
                AclId aclId = AclId.getUser();
                boolean bl2 = false;
                boolean bl = false;
                try {
                    bl2 = Session._setUser(aclId2, true);
                    bl = true;
                    resultSet = statement.executeQuery("SELECT current_schema()");
                    if (!resultSet.next()) break block7;
                    string = resultSet.getString(1);
                }
                catch (Throwable throwable) {
                    SQLUtils.close(resultSet);
                    SQLUtils.close(statement);
                    if (bl) {
                        Session._setUser(aclId, bl2);
                    }
                    throw throwable;
                }
                SQLUtils.close(resultSet);
                SQLUtils.close(statement);
                if (bl) {
                    Session._setUser(aclId, bl2);
                }
                return string;
            }
            throw new SQLException("Unable to obtain current schema");
        }
    }

    static long init() throws SQLException {
        ELogHandler.init();
        return System.identityHashCode(Thread.currentThread());
    }

    private static native boolean _setUser(AclId var0, boolean var1);
}

