/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ReflectPermission;
import java.net.NetPermission;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.security.SecurityPermission;
import java.sql.SQLException;
import java.util.PropertyPermission;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.postgresql.pljava.internal.Session;
import org.postgresql.pljava.management.Commands;

public class Backend {
    public static final Object THREADLOCK = new Object();
    private static Session s_session;
    private static boolean s_inSetTrusted;
    private static final SecurityManager s_untrustedSecurityManager;
    private static final SecurityManager s_trustedSecurityManager;
    private static final SecurityManager s_strictSecurityManager;

    public static synchronized Session getSession() {
        if (s_session == null) {
            s_session = new Session();
        }
        return s_session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getConfigOption(String string) {
        Object object = THREADLOCK;
        synchronized (object) {
            return Backend._getConfigOption(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLibraryPath() {
        Object object = THREADLOCK;
        synchronized (object) {
            return Backend._getLibraryPath();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getStatementCacheSize() {
        Object object = THREADLOCK;
        synchronized (object) {
            return Backend._getStatementCacheSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void log(int n, String string) {
        Object object = THREADLOCK;
        synchronized (object) {
            Backend._log(n, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addClassImages(int n, String string) throws SQLException {
        Object object;
        boolean bl;
        block23: {
            InputStream inputStream = null;
            boolean bl2 = bl = System.getSecurityManager() == s_trustedSecurityManager;
            if (bl) {
                s_inSetTrusted = true;
                try {
                    object = Logger.getAnonymousLogger();
                    if (((Logger)object).isLoggable(Level.FINER)) {
                        ((Logger)object).finer("Using SecurityManager for untrusted language");
                    }
                    System.setSecurityManager(s_untrustedSecurityManager);
                }
                finally {
                    s_inSetTrusted = false;
                }
            }
            try {
                object = new URL(string);
                URLConnection uRLConnection = ((URL)object).openConnection();
                uRLConnection.connect();
                int n2 = uRLConnection.getContentLength();
                inputStream = uRLConnection.getInputStream();
                Commands.addClassImages(n, inputStream, n2);
                if (inputStream == null) break block23;
            }
            catch (IOException iOException) {
                try {
                    throw new SQLException("I/O exception reading jar file: " + iOException.getMessage());
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                    }
                    if (!bl) throw throwable;
                    s_inSetTrusted = true;
                    try {
                        Logger logger = Logger.getAnonymousLogger();
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("Using SecurityManager for trusted language");
                        }
                        System.setSecurityManager(Backend.javaudfIsEnableAll() ? s_trustedSecurityManager : s_strictSecurityManager);
                        throw throwable;
                    }
                    finally {
                        s_inSetTrusted = false;
                    }
                }
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!bl) return;
        s_inSetTrusted = true;
        try {
            object = Logger.getAnonymousLogger();
            if (((Logger)object).isLoggable(Level.FINER)) {
                ((Logger)object).finer("Using SecurityManager for trusted language");
            }
            System.setSecurityManager(Backend.javaudfIsEnableAll() ? s_trustedSecurityManager : s_strictSecurityManager);
            return;
        }
        finally {
            s_inSetTrusted = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearFunctionCache() {
        Object object = THREADLOCK;
        synchronized (object) {
            Backend._clearFunctionCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCreatingExtension() {
        Object object = THREADLOCK;
        synchronized (object) {
            return Backend._isCreatingExtension();
        }
    }

    private static void setTrusted(boolean bl) {
        if (!Backend.IsInternalSetTrusted()) {
            return;
        }
        s_inSetTrusted = true;
        try {
            Logger logger = Logger.getAnonymousLogger();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Using SecurityManager for " + (bl ? "trusted" : "untrusted") + " language");
            }
            System.setSecurityManager(bl ? (Backend.javaudfIsEnableAll() ? s_trustedSecurityManager : s_strictSecurityManager) : s_untrustedSecurityManager);
        }
        finally {
            s_inSetTrusted = false;
        }
    }

    public static native boolean isCallingJava();

    public static native boolean isReleaseLingeringSavepoints();

    public static native boolean javaudfIsEnableAll();

    public static native boolean IsInternalSetTrusted();

    public static native boolean javaudfIsDisableExtdir();

    public static native boolean javaudfIsDisableHadoop();

    public static native boolean javaudfIsDisableReflection();

    public static native boolean javaudfIsDisableLoadlibrary();

    public static native boolean javaudfIsDisableNet();

    public static native boolean javaudfIsDisableSecurity();

    public static native boolean javaudfIsDisableAccessDeclared();

    public static native boolean javaudfIsDisableClassLoader();

    public static native boolean javaudfIsDisableSocket();

    private static native String _getConfigOption(String var0);

    private static native String _getLibraryPath();

    private static native int _getStatementCacheSize();

    private static native void _log(int var0, String var1);

    private static native void _clearFunctionCache();

    private static native boolean _isCreatingExtension();

    static {
        s_inSetTrusted = false;
        s_untrustedSecurityManager = new PLJavaSecurityManager();
        s_trustedSecurityManager = new PLJavaSecurityManager(){

            @Override
            void assertPermission(Permission permission) {
                if (permission instanceof FilePermission) {
                    Class<?>[] classArray;
                    String string = permission.getActions();
                    if ("execute".equals(string) && permission.getName().equals("<<ALL FILES>>") && (System.getProperty("hadoop.home.dir") != null || System.getenv("HADOOP_HOME") != null)) {
                        classArray = this.getClassContext();
                        for (int i = 0; i < classArray.length; ++i) {
                            if (!classArray[i].getName().equals("org.apache.hadoop.security.UserGroupInformation")) continue;
                            return;
                        }
                    }
                    if ("read".equals(string)) {
                        classArray = permission.getName();
                        if ("/dev/random".equals(classArray) || "/dev/urandom".equals(classArray)) {
                            return;
                        }
                        String string2 = Backend.getLibraryPath() + "/java";
                        if (string2.equals(classArray)) {
                            return;
                        }
                        String string3 = System.getProperty("java.library.path");
                        String[] stringArray = string3.split(":");
                        String string4 = System.getProperty("java.ext.dirs");
                        String[] stringArray2 = string4.split(":");
                        File file = new File(string2);
                        try {
                            file = file.getCanonicalFile();
                        }
                        catch (IOException iOException) {
                            file = file.getAbsoluteFile();
                        }
                        File file2 = new File(System.getProperty("java.home"));
                        try {
                            file2 = file2.getCanonicalFile();
                        }
                        catch (IOException iOException) {
                            file2 = file2.getAbsoluteFile();
                        }
                        File file3 = new File(permission.getName());
                        try {
                            file3 = file3.getCanonicalFile();
                        }
                        catch (IOException iOException) {
                            file3 = file3.getAbsoluteFile();
                        }
                        for (File file4 = file3.getParentFile(); file4 != null; file4 = file4.getParentFile()) {
                            File file5;
                            int n;
                            if (file4.equals(file2)) {
                                return;
                            }
                            if (file4.equals(file)) {
                                return;
                            }
                            for (n = 0; n < stringArray.length; ++n) {
                                file5 = new File(stringArray[n]);
                                if (!file4.equals(file5.getPath()) && !file4.equals(file5.getParentFile())) continue;
                                return;
                            }
                            for (n = 0; n < stringArray2.length; ++n) {
                                file5 = new File(stringArray2[n]);
                                if (!file4.equals(file5.getPath()) && !file4.equals(file5.getParentFile())) continue;
                                return;
                            }
                        }
                    }
                    throw new SecurityException(permission.getActions() + " on " + permission.getName());
                }
                super.assertPermission(permission);
            }
        };
        s_strictSecurityManager = new PLJavaSecurityManager(){

            File tryGetCanonicalFile(String string) {
                File file = new File(string);
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException iOException) {
                    throw new SecurityException("get " + string + " failed.");
                }
                return file;
            }

            boolean isPljavaStack() {
                StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                return stackTraceElementArray[stackTraceElementArray.length - 1].getClassName().equals("org.postgresql.pljava.sqlj.Loader");
            }

            boolean hasLogStack() {
                StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                for (int i = 0; i < stackTraceElementArray.length; ++i) {
                    if (!stackTraceElementArray[i].getClassName().equals("java.util.logging.Logger")) continue;
                    return true;
                }
                return false;
            }

            @Override
            void assertPermission(Permission permission) {
                Object object;
                if (permission instanceof ReflectPermission && Backend.javaudfIsDisableReflection() && permission.getName().equals("suppressAccessChecks") && !this.isPljavaStack() && !this.hasLogStack()) {
                    throw new SecurityException("reflection is not allowed.");
                }
                if (permission instanceof RuntimePermission) {
                    if (Backend.javaudfIsDisableLoadlibrary() && permission.getName().startsWith("loadLibrary.")) {
                        throw new SecurityException("loadLibrary is not allowed.");
                    }
                    if (Backend.javaudfIsDisableAccessDeclared() && permission.getName().equals("accessDeclaredMembers")) {
                        throw new SecurityException("accessDeclaredMembers is not allowed.");
                    }
                    if (Backend.javaudfIsDisableClassLoader() && permission.getName().equals("createClassLoader") && !(object = Thread.currentThread().getStackTrace())[((StackTraceElement[])object).length - 1].getClassName().equals("org.postgresql.pljava.sqlj.Loader")) {
                        throw new SecurityException("classLoader is not allowed.");
                    }
                }
                if (permission instanceof SocketPermission && Backend.javaudfIsDisableSocket()) {
                    throw new SecurityException("SocketPermission is not allowed.");
                }
                if (permission instanceof NetPermission && Backend.javaudfIsDisableNet()) {
                    throw new SecurityException("NetPermission is not allowed.");
                }
                if (permission instanceof SecurityPermission && Backend.javaudfIsDisableSecurity() && !this.isPljavaStack()) {
                    throw new SecurityException("security operation is not allowed.");
                }
                if (permission instanceof FilePermission) {
                    Class<?>[] classArray;
                    object = permission.getActions();
                    if (!Backend.javaudfIsDisableHadoop() && "execute".equals(object) && permission.getName().equals("<<ALL FILES>>") && System.getenv("HADOOP_HOME") != null) {
                        classArray = this.getClassContext();
                        for (int i = 0; i < classArray.length; ++i) {
                            if (!classArray[i].getName().equals("org.apache.hadoop.security.UserGroupInformation")) continue;
                            return;
                        }
                    }
                    if ("read".equals(object)) {
                        classArray = permission.getName();
                        if ("/dev/random".equals(classArray) || "/dev/urandom".equals(classArray)) {
                            return;
                        }
                        if ((Backend.getLibraryPath() + "/java/pljava.jar").equals(classArray)) {
                            return;
                        }
                        String string = Backend.getLibraryPath() + "/java";
                        if (string.equals(classArray)) {
                            return;
                        }
                        File file = this.tryGetCanonicalFile(System.getProperty("java.home"));
                        String string2 = System.getProperty("java.ext.dirs");
                        String[] stringArray = string2.split(":");
                        File file2 = this.tryGetCanonicalFile(string);
                        File file3 = this.tryGetCanonicalFile(permission.getName());
                        File file4 = this.tryGetCanonicalFile(".");
                        if (file3.getPath().startsWith(file4.getPath())) {
                            return;
                        }
                        for (File file5 = file3.getParentFile(); file5 != null; file5 = file5.getParentFile()) {
                            if (file5.equals(file2)) {
                                return;
                            }
                            if (file5.equals(file)) {
                                return;
                            }
                            if (Backend.javaudfIsDisableExtdir()) continue;
                            for (int i = 0; i < stringArray.length; ++i) {
                                File file6 = new File(stringArray[i]);
                                if (!file5.equals(file6.getPath())) continue;
                                return;
                            }
                        }
                    }
                    classArray = permission.getName();
                    String[] stringArray = classArray.split("/");
                    throw new SecurityException(permission.getActions() + " on " + stringArray[stringArray.length - 1]);
                }
                super.assertPermission(permission);
            }
        };
    }

    private static class PLJavaSecurityManager
    extends SecurityManager {
        private boolean m_recursion = false;

        private PLJavaSecurityManager() {
        }

        @Override
        public void checkPermission(Permission permission) {
            this.nonRecursiveCheck(permission);
        }

        @Override
        public void checkPermission(Permission permission, Object object) {
            this.nonRecursiveCheck(permission);
        }

        private synchronized void nonRecursiveCheck(Permission permission) {
            if (this.m_recursion) {
                return;
            }
            this.m_recursion = true;
            try {
                this.assertPermission(permission);
            }
            finally {
                this.m_recursion = false;
            }
        }

        void assertPermission(Permission permission) {
            String string;
            if (permission instanceof RuntimePermission) {
                String string2 = permission.getName();
                if ("*".equals(string2) || "exitVM".equals(string2)) {
                    throw new SecurityException();
                }
                if ("setSecurityManager".equals(string2) && !s_inSetTrusted) {
                    throw new SecurityException();
                }
            } else if (permission instanceof PropertyPermission && permission.getActions().indexOf("write") >= 0 && ((string = permission.getName()).equals("java.home") || string.matches("org\\.postgresql\\.pljava\\.udt\\.byteorder(?:\\..*)?"))) {
                throw new SecurityException();
            }
        }
    }
}

