#!/bin/sh

#-----------------------------------------------------
#Copyright (c): 2017, Huawei Tech. Co., Ltd.
#FileName     : gsql_env.sh
#Version      : Gauss200 OLAP
#Date         : 2017-04-06
#Description  : This file is to configure environment variables of gsql
#-----------------------------------------------------

#find the absolute path of this script
curpath=$0
if [ x${curpath:0:1} = "x-" ] || [ x${curpath} = "x/bin/bash" ] || [ x${curpath} = "x/bin/sh" ]; then
	curpath="`pwd`"
elif [ x${curpath:0:1} != "x/" ]; then
	curpath="`pwd`/`dirname ${curpath}`";
fi

function logerr()
{
	printf "ERROR: $* \n" >&2
}

function loghint()
{
	printf "HINT: $* \n" >&2
}

function logwarning()
{
	printf "WARNING: $* \n" >&2
}

function doing()
{
	length_of_line=60
	printf "$1 ";
	for ((i=${#1};i<$length_of_line;i++)); do 
		printf '.';
	done;
	printf " "
}

#------------------------------
#       gsql things
#------------------------------
function cofiggsql()
{
	doing 'Configuring LD_LIBRARY_PATH and PATH for gsql'
	libpath="${curpath}/lib"
	binpath="${curpath}/bin"
	if [ ! -f "${curpath}/bin/gsql" ]; then
		logerr "failed to locate ./bin/gsql, please source this file at the path where it is. "
		return 1;
	fi;
	export LD_LIBRARY_PATH=${libpath}:${LD_LIBRARY_PATH}
	export PATH=${binpath}:${PATH}
	echo 'done'
	return 0
}

if [ ! -z $1 ]; then
	echo "Usage:"
	echo "	source $0"
else
	cofiggsql
	if [ 0 -eq $? ]; then
		echo 'All things done.'
	fi
fi
