#!/usr/bin/env python3
#-*- coding:utf-8 -*-
try:
    import sys
    import importlib
    importlib.reload(sys)
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
    from gspylib.os.gsservice import g_service
except ImportError as ie:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(ie))


class CheckSshdService(BaseItem):
    def __init__(self):
        super(CheckSshdService, self).__init__(self.__class__.__name__)

    def doCheck(self):
        (status, output) = g_service.manageOSService('sshd', 'status')
        self.result.raw = output
        if (status == 0 and output.find('running')):
            self.result.rst = ResultStatus.OK
            self.result.val = "The sshd service is normal."
        else:
            self.result.val = "There is no sshd service."
            self.result.rst = ResultStatus.NG
