#!/usr/bin/env python3
#-*- coding:utf-8 -*-
try:
    import sys
    import importlib
    importlib.reload(sys)
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
    from gspylib.os.gsfile import g_file
except ImportError as ie:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(ie))


class CheckHyperThread(BaseItem):
    def __init__(self):
        super(CheckHyperThread, self).__init__(self.__class__.__name__)

    def doCheck(self):
        flag = "open"
        idList = []
        idCount = 0
        cores = 0
        cpuCount = 0
        cpuInfo = g_file.readFile('/proc/cpuinfo')
        for eachLine in cpuInfo:
            if (eachLine.find('physical id') >= 0):
                #get different CPU id
                cpuID = eachLine.split(':')[1].strip()
                if cpuID not in idList:
                    idList.append(cpuID)
                    #Calculate the number of CPUs
                    idCount += 1
            if (eachLine.find('cores') >= 0):
                cores = int(eachLine.split(':')[1].strip())
            if (eachLine.find('processor') >= 0):
                cpuCount += 1

        if (cpuCount == 2 * idCount * cores):
            self.result.rst = ResultStatus.OK
        else:
            flag = "down"
            self.result.rst = ResultStatus.NG

        self.result.val = "Hyper-threading is %s." % flag
        self.result.raw = "the number of physical id: %d, cores: %d, cpu counts: %d" % (idCount, cores, cpuCount)
