#!/usr/bin/env python3
#-*- coding:utf-8 -*-

try:
    import sys
    import importlib
    importlib.reload(sys)
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
    from gspylib.os.gsfile import g_file
except Exception as ie:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(ie))


class CheckEtcHosts(BaseItem):
    def __init__(self):
        super(CheckEtcHosts, self).__init__(self.__class__.__name__)

    def doCheck(self):
        flag = "Normal"
        conflictsMapping = []
        commentsMapping = []
        IPMapping = {}
        IpList = []

        mappingList = g_file.readFile('/etc/hosts')
        for eachLine in mappingList:
            eachLine = eachLine.strip()
            if (eachLine == ""):
                continue
            if (not eachLine.startswith('#') and '::' not in eachLine):
                mappingInfo = " ".join(eachLine.split())
                IpList.append(mappingInfo)
        IpList.sort()
        self.result.raw = "\n".join(IpList)

        # Check localhost Mapping
        localHost = False
        for eachIP in IpList:
            if eachIP.find("127.0.0.1 localhost") == 0:
                localHost = True
                break
        if not localHost:
            self.result.rst = ResultStatus.NG
            self.result.val = "The /etc/hosts does not match localhosts."
            return

        # Check conflicts Mapping and GAUSS comments Mapping
        for IPInfo in IpList:
            ipHost = IPInfo.split()
            if len(ipHost) < 2:
                continue
            ip = IPInfo.split()[0]
            host = IPInfo.split()[1]
            if ip == "127.0.0.1":
                continue
            if ip in IPMapping.keys() and host != IPMapping[ip]:
                conflictsMapping.append(IPInfo)
                conflictsMapping.append("%s %s" % (ip, IPMapping[ip]))
                flag = "Error_conflicts"
            else:
                IPMapping[ip] = host
            if len(IPInfo.split()) > 2 and IPInfo.split()[2] == "#Gauss":
                commentsMapping.append(IPInfo + " IP Hosts Mapping")
                flag = "Error_comments"

        self.judge_status_by_flag(flag, commentsMapping)

    def judge_status_by_flag(self, flag, comments_mapping):
        """
        function: judge flag status
        input: flag, comments_mapping
        output: NA
        """
        if flag == "Normal":
            self.result.rst = ResultStatus.OK
            self.result.val = "The /etc/hosts is configured correctly."
        elif flag == "Error_comments":
            self.result.rst = ResultStatus.NG
            self.result.val = "The /etc/hosts has comments Mapping:\n" + "\n".join(comments_mapping)
        else:
            self.result.rst = ResultStatus.NG
            self.result.val = "The /etc/hosts has conflicts Mapping:\n" + "\n".join(comments_mapping)
            if len(comments_mapping) > 0:
                self.result.val += "\n\nThe /etc/hosts has comments Mapping:\n" + "\n".join(comments_mapping)
