#!/usr/bin/env python3
#-*- coding:utf-8 -*-
try:
    import sys
    import importlib
    importlib.reload(sys)
    from gspylib.inspection.common import SharedFuncs
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
except ImportError as ie:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(ie))


class CheckReturnType(BaseItem):
    def __init__(self):
        super(CheckReturnType, self).__init__(self.__class__.__name__)

    def doCheck(self):
        sqlcmd = "select proname from pg_catalog.pg_proc, pg_catalog.pg_type" \
                 " where pg_proc.prorettype=pg_type.oid and pg_type.typisdefined=false;"
        self.result.raw = sqlcmd
        output = SharedFuncs.runSqlCmd(sqlcmd, self.user, "", self.port, self.tmpPath, "postgres", self.mpprcFile)
        if not output:
            self.result.rst = ResultStatus.OK
            self.result.val = "User-defined functions do not contain illegal return types."
        else:
            self.result.rst = ResultStatus.NG
            self.result.val = "User-defined function contains illegal return type."
