#!/usr/bin/env python3
#-*- coding:utf-8 -*-
try:
    import sys
    import importlib
    importlib.reload(sys)
    import os
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
    from gspylib.common.DbClusterInfo import compareObject, dbClusterInfo
except ImportError as e:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(e))


class CheckConfigFileDiff(BaseItem):
    def __init__(self):
        super(CheckConfigFileDiff, self).__init__(self.__class__.__name__)
        self.newclusterFile = None

    def preCheck(self):
        #Get a new xml path in xml
        if (not self.threshold.__contains__('newclusterconfig')):
            raise Exception("The new cluster config file configuration is required")
        self.newclusterFile = self.threshold['newclusterconfig']
        #Judge whether the document
        if (not os.path.isfile(self.newclusterFile)):
            raise Exception("The new cluster config file does not exist. %s" % self.newclusterFile)

    def doCheck(self):
        staticConfigInfo = self.cluster
        newclusterInfo = dbClusterInfo()
        newclusterInfo.initFromXml(self.newclusterFile)
        #Determine whether the static configuration file and the new xml file cluster name is the same
        if (staticConfigInfo.name != newclusterInfo.name):
            self.result.rst = ResultStatus.NG
            self.result.val = "The Cluster name does not match with old name. Old name: %s. New name: %s." % (
                staticConfigInfo.name, newclusterInfo.name)
            return
        #Judge app path is the same
        if (staticConfigInfo.appPath != newclusterInfo.appPath):
            self.result.rst = ResultStatus.ERROR
            self.result.val = "The Cluster appPath does not match with old appPath.Old appPath: %s." \
                              " New appPath: %s." % (staticConfigInfo.appPath, newclusterInfo.appPath)
            return
        #check cmsFloatIp
        if (staticConfigInfo.cmsFloatIp != newclusterInfo.cmsFloatIp):
            self.result.rst = ResultStatus.ERROR
            self.result.val = "The Cluster cmsFloatIp does not match with old cmsFloatIp.Old cmsFloatIp: %s." \
                              " New cmsFloatIp: %s." % (staticConfigInfo.cmsFloatIp, newclusterInfo.cmsFloatIp)
            return
        #Get node information
        oldNodes = []
        for dbNode in newclusterInfo.dbNodes:
            if (dbNode not in newclusterInfo.newNodes):
                oldNodes.append(dbNode)
        theSameOld, tempbuffer = compareObject(staticConfigInfo.dbNodes, oldNodes, "dbNodes")
        if (not theSameOld):
            self.result.val = "Instance[%s] are not the same.\nA: %s\nB: %s\n" % (
                tempbuffer[0], tempbuffer[1], tempbuffer[2])
            self.result.rst = ResultStatus.NG
            return

        newNodesCount = len(newclusterInfo.newNodes)
        if (newNodesCount <= 2):
            self.result.rst = ResultStatus.NG
            self.result.val = "The number of capacity expansion nodes less than three."
            return

        dnNodes = []
        for dbNode in newclusterInfo.newNodes:
            if (len(dbNode.datanodes) > 0):
                dnNodes.append(dbNode.datanodes)
        if (len(dnNodes) == 0):
            self.result.rst = ResultStatus.NG
        self.result.rst = ResultStatus.OK
