#!/usr/bin/env python3
# -*- coding:utf-8 -*-
#############################################################################
# Copyright (c): 2012-2017, Huawei Tech. Co., Ltd.
# Description  : digital compare is a utility with a lot of compare digital functions
#############################################################################
try:
    import sys
    import os
    localDirPath = os.path.dirname(os.path.realpath(__file__))
    sys.path.insert(0, localDirPath + "/../../../../lib")
    sys.path.append(localDirPath + "/../../../")
    from gspylib.common.common.default_value import DefaultValue
except ImportError as ie:
    sys.exit("[GAUSS-52200] : Unable to import module: %s." % str(ie))


class Digital(object):
    @staticmethod
    def float_more_than(one, two):
        """
        """
        if float(one) - float(two) > float(DefaultValue.DELTA_NUM):
            return True
        return False

    @staticmethod
    def float_less_than(one, two):
        """
        """
        if float(one) - float(two) < float(-DefaultValue.DELTA_NUM):
            return True
        return False

    @staticmethod
    def float_equal_to(one, two):
        """
        """
        if float(-DefaultValue.DELTA_NUM) < (float(one) - float(two)) < float(DefaultValue.DELTA_NUM):
            return True
        return False

    @staticmethod
    def float_greater_or_equal_to(one, two):
        """
        """
        if Digital.float_more_than(one, two) or Digital.float_equal_to(one, two):
            return True
        return False
