/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.text.ParseException;
import java.util.Scanner;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.jdbc.SQLUtils;
import org.postgresql.pljava.management.SQLDeploymentDescriptor;
import org.postgresql.pljava.sqlgen.DDRWriter;

public class InstallHelper {
    private static final SchemaVariant currentSchema = SchemaVariant.REL_1_5_0;

    private static void setPropertyIfNull(String string, String string2) {
        if (null == System.getProperty(string)) {
            System.setProperty(string, string2);
        }
    }

    public static String hello(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        String string9 = InstallHelper.class.getPackage().getImplementationVersion();
        System.clearProperty("visualvm.display.name");
        System.setProperty("user.name", string2);
        InstallHelper.setPropertyIfNull("java.awt.headless", "true");
        InstallHelper.setPropertyIfNull("org.postgresql.database", string3);
        if (null != string4) {
            InstallHelper.setPropertyIfNull("org.postgresql.cluster", string4);
        }
        InstallHelper.setPropertyIfNull("org.postgresql.datadir", string5);
        InstallHelper.setPropertyIfNull("org.postgresql.libdir", string6);
        InstallHelper.setPropertyIfNull("org.postgresql.sharedir", string7);
        InstallHelper.setPropertyIfNull("org.postgresql.sysconfdir", string8);
        if (string9 != null && string9.length() > 0) {
            InstallHelper.setPropertyIfNull("org.postgresql.pljava.version", string9);
        }
        InstallHelper.setPropertyIfNull("org.postgresql.pljava.native.version", string);
        InstallHelper.setPropertyIfNull("org.postgresql.version", Backend.getConfigOption("server_version"));
        InstallHelper.setPropertyIfNull("sqlj.defaultconnection", "jdbc:default:connection");
        String string10 = "org.postgresql.pljava.udt.byteorder";
        String string11 = System.getProperty(string10);
        String string12 = System.getProperty(string10 + ".scalar");
        String string13 = System.getProperty(string10 + ".mirror");
        if (null == string12) {
            String string14 = string12 = null != string11 ? string11 : "big_endian";
        }
        if (null == string13) {
            string13 = null != string11 ? string11 : "native";
        }
        InstallHelper.setPropertyIfNull(string10 + ".scalar.p2j", string12);
        InstallHelper.setPropertyIfNull(string10 + ".scalar.j2p", string12);
        InstallHelper.setPropertyIfNull(string10 + ".mirror.p2j", string13);
        InstallHelper.setPropertyIfNull(string10 + ".mirror.j2p", string13);
        System.clearProperty(string10);
        System.clearProperty(string10 + ".scalar");
        System.clearProperty(string10 + ".mirror");
        String string15 = System.getProperty("java.runtime.name");
        String string16 = System.getProperty("java.runtime.version");
        if (null == string15 || null == string16) {
            string15 = System.getProperty("java.vendor");
            string16 = System.getProperty("java.version");
        }
        String string17 = System.getProperty("java.vm.name");
        String string18 = System.getProperty("java.vm.version");
        String string19 = System.getProperty("java.vm.info");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PL/Java native code (").append(string).append(")\n");
        stringBuilder.append("PL/Java common code (").append(string9).append(")\n");
        stringBuilder.append(string15).append(" (").append(string16).append(")\n");
        stringBuilder.append(string17).append(" (").append(string18);
        if (null != string19) {
            stringBuilder.append(", ").append(string19);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void groundwork(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException, ParseException {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = SQLUtils.getDefaultConnection();
            statement = connection.createStatement();
            InstallHelper.schema(connection, statement);
            SchemaVariant schemaVariant = InstallHelper.recognizeSchema(connection, statement, string2);
            if (null == schemaVariant) {
                throw new SQLNonTransientException("Failed to recognize schema of PL/Java installation", "55000");
            }
            if (bl && bl2 && SchemaVariant.EMPTY != schemaVariant) {
                throw new SQLNonTransientException("sqlj schema not empty for CREATE EXTENSION pljava", "55000");
            }
            InstallHelper.handlers(connection, statement, string);
            InstallHelper.languages(connection, statement);
            InstallHelper.deployment(connection, statement, schemaVariant);
            if (bl) {
                statement.execute("DROP TABLE sqlj." + string3);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.close(statement);
            SQLUtils.close(connection);
            throw throwable;
        }
        SQLUtils.close(statement);
        SQLUtils.close(connection);
    }

    private static void schema(Connection connection, Statement statement) throws SQLException {
        block2: {
            Savepoint savepoint = null;
            try {
                savepoint = connection.setSavepoint();
                statement.execute("CREATE SCHEMA sqlj");
                statement.execute("COMMENT ON SCHEMA sqlj IS 'Schema for objects pertaining to PL/Java, as specified by \"SQL/JRT\" part 13 of the SQL standard, Java Routines and Types.'");
                statement.execute("GRANT USAGE ON SCHEMA sqlj TO public");
                connection.releaseSavepoint(savepoint);
            }
            catch (SQLException sQLException) {
                connection.rollback(savepoint);
                if ("42P06".equals(sQLException.getSQLState())) break block2;
                throw sQLException;
            }
        }
    }

    private static void handlers(Connection connection, Statement statement, String string) throws SQLException {
        statement.execute("CREATE OR REPLACE FUNCTION sqlj.java_call_handler() RETURNS language_handler AS " + DDRWriter.eQuote(string) + " LANGUAGE C");
        statement.execute("REVOKE ALL PRIVILEGES ON FUNCTION sqlj.java_call_handler() FROM public");
        ResultSet resultSet = statement.executeQuery("SELECT pg_catalog.obj_description(CAST('sqlj.java_call_handler()' AS pg_catalog.regprocedure), 'pg_proc')");
        resultSet.next();
        resultSet.getString(1);
        boolean bl = resultSet.wasNull();
        resultSet.close();
        if (bl) {
            statement.execute("COMMENT ON FUNCTION sqlj.java_call_handler() IS 'Function-call handler for PL/Java''s trusted/sandboxed language.'");
        }
        statement.execute("CREATE OR REPLACE FUNCTION sqlj.javau_call_handler() RETURNS language_handler AS " + DDRWriter.eQuote(string) + " LANGUAGE C");
        statement.execute("REVOKE ALL PRIVILEGES ON FUNCTION sqlj.javau_call_handler() FROM public");
        resultSet = statement.executeQuery("SELECT pg_catalog.obj_description(CAST('sqlj.javau_call_handler()' AS pg_catalog.regprocedure), 'pg_proc')");
        resultSet.next();
        resultSet.getString(1);
        bl = resultSet.wasNull();
        resultSet.close();
        if (bl) {
            statement.execute("COMMENT ON FUNCTION sqlj.javau_call_handler() IS 'Function-call handler for PL/Java''s untrusted/unsandboxed language.'");
        }
    }

    private static void languages(Connection connection, Statement statement) throws SQLException {
        block5: {
            Savepoint savepoint;
            block4: {
                savepoint = null;
                try {
                    savepoint = connection.setSavepoint();
                    statement.execute("CREATE TRUSTED LANGUAGE java HANDLER sqlj.java_call_handler");
                    statement.execute("COMMENT ON LANGUAGE java IS 'Trusted/sandboxed language for routines and types in Java; http://tada.github.io/pljava/'");
                    statement.execute("REVOKE USAGE ON LANGUAGE java FROM PUBLIC");
                    connection.releaseSavepoint(savepoint);
                }
                catch (SQLException sQLException) {
                    connection.rollback(savepoint);
                    if ("42710".equals(sQLException.getSQLState())) break block4;
                    throw sQLException;
                }
            }
            try {
                savepoint = connection.setSavepoint();
                statement.execute("CREATE LANGUAGE javaU HANDLER sqlj.javau_call_handler");
                statement.execute("COMMENT ON LANGUAGE javau IS 'Untrusted/unsandboxed language for routines and types in Java; http://tada.github.io/pljava/'");
                connection.releaseSavepoint(savepoint);
            }
            catch (SQLException sQLException) {
                connection.rollback(savepoint);
                if ("42710".equals(sQLException.getSQLState())) break block5;
                throw sQLException;
            }
        }
    }

    private static void deployment(Connection connection, Statement statement, SchemaVariant schemaVariant) throws SQLException, ParseException {
        if (currentSchema == schemaVariant) {
            return;
        }
        if (SchemaVariant.EMPTY != schemaVariant) {
            currentSchema.migrateFrom(schemaVariant, connection, statement);
            return;
        }
        InputStream inputStream = InstallHelper.class.getResourceAsStream("/pljava.ddr");
        String string = new Scanner(inputStream, "utf-8").useDelimiter("\\A").next();
        SQLDeploymentDescriptor sQLDeploymentDescriptor = new SQLDeploymentDescriptor(string);
        sQLDeploymentDescriptor.install(connection);
    }

    private static SchemaVariant recognizeSchema(Connection connection, Statement statement, String string) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet resultSet = databaseMetaData.getColumns(null, "sqlj", "jar_descriptor", null);
        boolean bl = resultSet.next();
        resultSet.close();
        if (bl) {
            return SchemaVariant.UNREL20130301b;
        }
        resultSet = databaseMetaData.getColumns(null, "sqlj", "jar_descriptors", null);
        bl = resultSet.next();
        resultSet.close();
        if (bl) {
            return SchemaVariant.UNREL20130301a;
        }
        resultSet = databaseMetaData.getColumns(null, "sqlj", "jar_repository", "jarmanifest");
        bl = resultSet.next();
        resultSet.close();
        if (bl) {
            return SchemaVariant.REL_1_3_0;
        }
        resultSet = databaseMetaData.getColumns(null, "sqlj", "typemap_entry", null);
        bl = resultSet.next();
        resultSet.close();
        if (bl) {
            return SchemaVariant.UNREL20060212;
        }
        resultSet = databaseMetaData.getColumns(null, "sqlj", "jar_repository", "jarowner");
        if (resultSet.next()) {
            int n = resultSet.getInt("DATA_TYPE");
            resultSet.close();
            if (12 == n) {
                return SchemaVariant.UNREL20060125;
            }
            return SchemaVariant.REL_1_1_0;
        }
        resultSet.close();
        resultSet = databaseMetaData.getColumns(null, "sqlj", "jar_repository", "deploymentdesc");
        bl = resultSet.next();
        resultSet.close();
        if (bl) {
            return SchemaVariant.REL_1_0_0;
        }
        resultSet = databaseMetaData.getColumns(null, "sqlj", "jar_entry", null);
        bl = resultSet.next();
        resultSet.close();
        if (bl) {
            return SchemaVariant.UNREL20040121;
        }
        resultSet = databaseMetaData.getColumns(null, "sqlj", "jar_repository", "jarimage");
        bl = resultSet.next();
        resultSet.close();
        if (bl) {
            return SchemaVariant.UNREL20040120;
        }
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT count(*) FROM pg_catalog.pg_depend d, pg_catalog.pg_namespace n WHERE refclassid = 'pg_catalog.pg_namespace'::regclass AND refobjid = n.oid AND nspname = 'sqlj' AND deptype = 'n' AND NOT EXISTS ( \tSELECT 1 FROM \tpg_catalog.pg_class sqc JOIN pg_catalog.pg_namespace sqn \tON relnamespace = sqn.oid \tWHERE \t\tnspname = 'pg_catalog' AND relname = 'pg_extension' \t\tAND classid = sqc.oid \tOR \t\tnspname = 'sqlj' AND relname = ?\t\tAND classid = 'pg_catalog.pg_class'::regclass \t\tAND objid = sqc.oid)");
        preparedStatement.setString(1, string);
        resultSet = preparedStatement.executeQuery();
        if (resultSet.next() && 0 == resultSet.getInt(1)) {
            resultSet.close();
            preparedStatement.close();
            return SchemaVariant.EMPTY;
        }
        resultSet.close();
        preparedStatement.close();
        return null;
    }

    private static enum SchemaVariant {
        REL_1_5_0("c51cffa34acd5a228325143ec29563174891a873"){

            @Override
            void migrateFrom(SchemaVariant schemaVariant, Connection connection, Statement statement) throws SQLException {
                switch (schemaVariant) {
                    case REL_1_3_0: {
                        statement.execute("CREATE TABLE sqlj.jar_descriptor (jarId, ordinal, entryId) AS SELECT CAST(jarId AS INT), CAST(0 AS INT2), deploymentDesc FROM sqlj.jar_repository WHERE deploymentDesc IS NOT NULL");
                        statement.execute("ALTER TABLE sqlj.jar_repository DROP deploymentDesc");
                        statement.execute("ALTER TABLE sqlj.jar_descriptor ADD FOREIGN KEY (jarId) REFERENCES sqlj.jar_repository ON DELETE CASCADE, ADD PRIMARY KEY (jarId, ordinal), ALTER COLUMN entryId SET NOT NULL, ADD FOREIGN KEY (entryId) REFERENCES sqlj.jar_entry ON DELETE CASCADE");
                        statement.execute("GRANT SELECT ON sqlj.jar_descriptor TO PUBLIC");
                        break;
                    }
                    case UNREL20130301a: {
                        statement.execute("ALTER TABLE sqlj.jar_descriptors RENAME TO jar_descriptor");
                        break;
                    }
                    default: {
                        super.migrateFrom(schemaVariant, connection, statement);
                    }
                }
            }
        }
        ,
        UNREL20130301a("624d78ca98d80ff2ded215eeca92035da5126bc0"),
        REL_1_3_0("d23804a7e1154de58181a8aa48bfbbb2c8adf68b"),
        UNREL20060212("671eadf7f13a7996af31f1936946bf6677ecdc73"),
        UNREL20060125("8afd33ccb8a2a56e92dee9c9ced81185ff0bb34d"),
        REL_1_1_0("039db412fa91a23b67ceb8d90d30bc540fef7c5d"),
        REL_1_0_0("94e23ba02b55e8008a935fcf3e397db0adb4671b"),
        UNREL20040121("67eea979bcd4575f285c30c581fd0d674c13c1fa"),
        UNREL20040120("5e4131738cd095b7ff6367d64f809f6cec6a7ba7"),
        EMPTY(null);

        static final SchemaVariant REL_1_5_0_BETA3;
        static final SchemaVariant REL_1_5_0_BETA2;
        static final SchemaVariant REL_1_5_0_BETA1;
        static final SchemaVariant UNREL20130301b;
        String sha;

        private SchemaVariant(String string2) {
            this.sha = string2;
        }

        void migrateFrom(SchemaVariant schemaVariant, Connection connection, Statement statement) throws SQLException {
            throw new SQLNonTransientException("Detected older PL/Java SQLJ schema " + schemaVariant.name() + ", from which no automatic migration is implemented", "55000");
        }

        static {
            UNREL20130301b = REL_1_5_0_BETA1 = (REL_1_5_0_BETA2 = (REL_1_5_0_BETA3 = REL_1_5_0));
        }
    }
}

