#!/usr/bin/env python3
# -*- coding:utf-8 -*-
#############################################################################
# Copyright (c): 2010-2020, Huawei Tech. Co., Ltd.
# Date         : 2018-03-26
# Description  : gsservice.py is a utility to do something for service information.
#############################################################################
try:
    import subprocess
    import sys
    import time

    sys.path.append(sys.path[0] + "/../../")
    from gspylib.common.ErrorCode import ErrorCode
    from gspylib.os.gsplatform import g_Platform
except Exception as ie:
    sys.exit("[GAUSS-52200] : Unable to import module: %s." % str(ie))

# ---------------OS service action --------------------
ACTION_LIST = ["start", "stop", "restart", "status", "reload", "enable"]
FIREWALL = "firewall"
CROND = "crond"
SSHD = "sshd"
SYSLOG = "syslog"
RSYSLOG = "rsyslog"
SYSTEMD_JOURNALD = "systemd-journald"
NTPD = "ntp"
GS_OS_SERVER = "gs-OS-set"
SERVICE_LIST = [FIREWALL, CROND, SSHD, SYSLOG, RSYSLOG, SYSTEMD_JOURNALD, NTPD, GS_OS_SERVER]


class Service():
    """
    function: Init the Service options
    """

    def __init__(self):
        pass

    def checkService(self, service):
        """
        """
        if (service not in SERVICE_LIST):
            raise Exception(ErrorCode.GAUSS_500["GAUSS_50011"] % ("service", service))

    def checkAction(self, action):
        """
        """
        if (action not in ACTION_LIST):
            raise Exception(ErrorCode.GAUSS_500["GAUSS_50011"] % ("action", action))

    def manageOSService(self, service, action):
        """
        """
        self.checkService(service)
        self.checkAction(action)

        # get service commands
        if service == FIREWALL:
            cmd = g_Platform.getManageFirewallCmd(action)
        elif service == CROND:
            cmd = g_Platform.getManageCrondCmd(action)
        elif service == SSHD:
            cmd = g_Platform.getManageSshdCmd(action)
        elif service == SYSTEMD_JOURNALD:
            # systemd-journald now only supported on SuSE Platform
            cmd = g_Platform.getManageSystemdJournaldCmd(action)
        elif service == SYSLOG:
            # syslog-ng only supported on SuSE Platform
            cmd = g_Platform.getManageSyslogCmd(action)
        elif service == RSYSLOG:
            # rsyslog only supported on SuSE Platform
            cmd = g_Platform.getManageRsyslogCmd(action)
        elif service == GS_OS_SERVER:
            cmd = g_Platform.getManageGsOsServerCmd(action)
        else:
            return (1, "Server(%s) is not support." % service)
        # Retry is added to solve that execution fails in large cluster.
        retry_times = 10
        for i in range(retry_times):
            (status, output) = subprocess.getstatusoutput(cmd)
            if status == 0:
                break
            time.sleep(3)
        return status, output

    def getFirewallStatus(self):
        """
        """
        return g_Platform.getLinuxFirewallStatus()


g_service = Service()
