#!/bin/bash

file_pwd=$(cd `dirname $0`;pwd)
log_dir=$file_pwd/out
PORT=25308

#Base check
if [ `whoami` == root ]; then
    echo "current user is root"
else
    echo "Please run the scripts as root user"
    exit 0
fi

if [ ! -f $file_pwd/hostfile ];then
    echo "Make sure the file \"$file_pwd/hostfile\" exists !!!"
    exit 0
fi

mkdir -p $log_dir

#check command
#get OS info
function os_info
{
  export LD_LIBRARY_PATH=/lib64:$LD_LIBRARY_PATH;
  echo $host
  #firewall info
  echo "Get firewall info" | tee $log_dir/${host}_osinfo.log
  if [ `cat /etc/*release| grep SUSE|wc -l` -gt 0 ];then
    echo "OS is SUSE" | tee -a $log_dir/${host}_osinfo.log
    echo "filewall info" | tee -a $log_dir/${host}_osinfo.log
    ssh $host "/sbin/SuSEfirewall2 status" >> $log_dir/${host}_osinfo.log 2>&1
  elif [ `cat /etc/*release| grep -E 'REDHAT|Red Hat'|wc -l` -gt 0 ];then
    echo "OS is REDHAT" | tee -a $log_dir/${host}_osinfo.log
    echo "filewall info" | tee -a $log_dir/${host}_osinfo.log
    ssh $host "service iptables status" >> $log_dir/${host}_osinfo.log 2>&1
  else
    echo "ERROR: NOT SUPPORT OS !!!"
  fi
}

for host in `cat $file_pwd/hostfile`
do
  os_info
done
