GSPORT=''

function usage()
{
    echo "***********************************************************************"
    echo "*                         DBCheck.sh usage                            *"
    echo "* -p: coordinator port number                                         *"
    echo "* example:  ./DBCheck.sh -p 25308                                     *"
    echo "***********************************************************************"
}

function parse_para()
{
    while getopts "p:h" opt
    do
        case $opt in
            p)
                if [ -z $GSPORT ]; then
                    let GSPORT=$OPTARG
                else
                    echo "ERROR: duplicate port number"
                    usage
                    exit 1
                fi
                ;;
            h)
                usage
                exit 1
                ;;
            ?)
                echo "ERROR: unkonw argument"
                usage
                exit 1
                ;;
        esac
    done

    if [ -z $GSPORT ]; then
        echo "ERROR: must designate -p"
        usage
        exit 1
    fi
}

function BlacklistCheck
{
    blacklistSQL="blacklist_check-"$dateFlag".sql"
    #only used from v1r5 to v1r6
    Version=`gaussdb -V | awk -F 'Gauss200 OLAP' '{print $2}' | awk -F ' ' '{print $1}'`
    sed s/OMVersion/$Version/g blacklist_check.sql >$blacklistSQL
    
    
    echo "==========================================================================================================================="
    echo "==                                                                                                                       =="
    echo "==                                            Check Blacklist                                                            =="
    echo "==                                                                                                                       =="
    echo "==========================================================================================================================="

    for db in `gsql -d postgres -p $GSPORT -c "select datname||'  GAUSSDB' from pg_catalog.pg_database where datname != 'template0'" | grep GAUSSDB | awk '{print $1}'`
    do
        echo "Blacklist Check for DataBase: "$db
        checkLOG="checklog-"$db"-"$dateFlag".log"
        gsql -d $db -p $GSPORT -f $blacklistSQL > $checkLOG
		if [ `cat $checkLOG | grep FAILED | wc -l` -gt 0 ]; then
			echo "NOTICE: Violation of blacklist rule"
			cat $checkLOG
		else
			echo "NOTICE: Comply with the blacklist rule"
		fi

        for sqlfile in `cat $checkLOG | grep FAILED | awk -F '|' '{print $NF}'`
        do
            sqlfilelog=`echo $logPath/$sqlfile|awk -F '.' '{print $1}'`-$db.log
            gsql -d $db -p $GSPORT -f $sqlfile > $sqlfilelog
            cat $sqlfilelog
        done
    done
}

function DroppedColumnTableCheck
{
    echo "==========================================================================================================================="
    echo "==                                                                                                                       =="
    echo "==                                        Check DroppedColumnTable                                                       =="
    echo "==                                                                                                                       =="
    echo "==========================================================================================================================="

    droppedColumnTableLog=$logPath/GetDroppedColumnTable.log
    ./ExecuteSQLOnAllDB.sh -p $GSPORT -f GetDroppedColumnTable.sql > $droppedColumnTableLog
    cat $droppedColumnTableLog
}

function RecurrentGrantCheck
{
    echo "==========================================================================================================================="
    echo "==                                                                                                                       =="
    echo "==                                         Check RecurrentGrant                                                          =="
    echo "==                                                                                                                       =="
    echo "==========================================================================================================================="

    tableRecurrentGrantLog=$logPath/GetTableRecurrentGrant.log
    ./ExecuteSQLOnAllDB.sh -p $GSPORT -f GetTableRecurrentGrant.sql > $tableRecurrentGrantLog
    cat $tableRecurrentGrantLog
}

function main
{
    dateFlag=`date "+%Y%m%d-%H%M%S"`
    if [ ! -d ./log ]; then mkdir ./log ;fi
    if [ ! -d ./log/"checkBlack-"$dateFlag ]; then mkdir ./log/"checkBlack-"$dateFlag ;fi
    logPath=`pwd`"/log/checkBlack-"$dateFlag
    source /opt/huawei/Bigdata/mppdb/.mppdbgs_profile 
    parse_para $*

    BlacklistCheck
    DroppedColumnTableCheck
    RecurrentGrantCheck
}

main $*
