#!/usr/bin/env python3
#-*- coding:utf-8 -*-
try:
    import sys
    import importlib
    importlib.reload(sys)
    import subprocess
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
    from gspylib.common.Common import DefaultValue
except ImportError as ie:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(ie))


class CheckSctpService(BaseItem):
    def __init__(self):
        super(CheckSctpService, self).__init__(self.__class__.__name__)

    def doCheck(self):

        parRes = ""
        flag = "Normal"
        cmd = "ls -l /lib/modules/`uname -r`/kernel/net/sctp/sctp.ko*"
        (status, output) = subprocess.getstatusoutput(cmd)
        if(status != 0 or output == "" or output.find("No such file or directory") > 0):
            flag = "Error"
            parRes += "There is no sctp service."
        else:
            cmd = "modprobe sctp;"
            cmd += "lsmod |grep sctp"
            (status, output) = subprocess.getstatusoutput(cmd)
            if(output == ""):
                flag = "Error"
                parRes += "sctp service is not loaded."

        cmd = "cat %s | grep '^insmod.*sctp.ko'" % DefaultValue.getOSInitFile()
        (status, output) = subprocess.getstatusoutput(cmd)
        if(status != 0 or output == ""):
            if (flag == "Normal"):
                flag = "Warning"
            parRes += "Sctp service is not set to boot from power on."

        self.result.val = parRes
        self.result.raw = output
        if (flag == "Error"):
            self.result.rst = ResultStatus.NG
        elif (flag == "Warning"):
            self.result.rst = ResultStatus.WARNING
        else:
            self.result.rst = ResultStatus.OK
            self.result.val = "Sctp service is Normal."

    def doSet(self):
        self.result.val = ""
        parRes = ""
        sctpFile = ""
        cmd = "ls -l /lib/modules/`uname -r`/kernel/net/sctp/sctp.ko*"
        (status, output) = subprocess.getstatusoutput(cmd)
        if(status != 0 or output == "" or output.find("No such file or directory") > 0):
            parRes = "There is no sctp service.\n"
        else:
            sctpFile = output.split()[-1]
            cmd = "modprobe sctp"
            (status, output) = subprocess.getstatusoutput(cmd)
            if (status != 0):
                cmd = "insmod %s >/dev/null 2>&1;lsmod |grep sctp" % sctpFile
                (status, output) = subprocess.getstatusoutput(cmd)
                if status != 0 or output == "":
                    parRes = "Filed to load sctp service.\n"
        cmd = "cat %s | grep sctp" % DefaultValue.getOSInitFile()
        (status, output) = subprocess.getstatusoutput(cmd)
        if(status != 0 or output == ""):
            cmd = "echo 'modprobe sctp' >> %s;" % DefaultValue.getOSInitFile()
            cmd += "echo 'insmod %s >/dev/null 2>&1' >> %s " % (sctpFile, DefaultValue.getOSInitFile())
            (status, output) = subprocess.getstatusoutput(cmd)
            if (status != 0):
                parRes += "Filed to add sctp service to boot.\n"

        self.result.val = parRes
