#!/usr/bin/env python3
#-*- coding:utf-8 -*-
try:
    import sys
    import importlib
    importlib.reload(sys)
    import subprocess
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
except ImportError as ie:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(ie))


class CheckOmmUserExist(BaseItem):
    def __init__(self):
        super(CheckOmmUserExist, self).__init__(self.__class__.__name__)

    def doCheck(self):
        cmd = "id omm"
        (_, output) = subprocess.getstatusoutput(cmd)
        self.result.raw = output
        if (output.lower().find('no such user') < 0):
            self.result.rst = ResultStatus.NG
            self.result.val = "User omm already exists. please delete this omm used by 'userdel -rf omm'."
        else:
            self.result.rst = ResultStatus.OK
            self.result.val = output

    def doSet(self):
        cmd = "userdel -rf omm"
        (status, output) = subprocess.getstatusoutput(cmd)
        if (status != 0):
            self.result.val += "Failed to delete omm user. Error:%s\n" % output
        else:
            self.result.val += "Successfully deleted omm user.\n"
