#!/usr/bin/env python3
#-*- coding:utf-8 -*-
try:
    import sys
    import importlib
    importlib.reload(sys)
    import _thread as thread
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
    from gspylib.os.gsnetwork import g_network
except ImportError as ie:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(ie))

DEFAULT_PARALLEL_NUM = 12
g_lock = thread.allocate_lock()
noPassIPs = []


class CheckPing(BaseItem):
    def __init__(self):
        super(CheckPing, self).__init__(self.__class__.__name__)

    def doCheck(self):
        global noPassIPs
        allIP = []
        LocalNodeInfo = self.cluster.getDbNodeByName(self.host)
        allIP += LocalNodeInfo.backIps
        allIP += LocalNodeInfo.sshIps
        for dbInstance in LocalNodeInfo.cmservers:
            allIP += dbInstance.haIps
            allIP += dbInstance.listenIps
        for dbInstance in LocalNodeInfo.coordinators:
            allIP += dbInstance.haIps
            allIP += dbInstance.listenIps
        for dbInstance in LocalNodeInfo.datanodes:
            allIP += dbInstance.haIps
            allIP += dbInstance.listenIps
        for dbInstance in LocalNodeInfo.gtms:
            allIP += dbInstance.haIps
            allIP += dbInstance.listenIps
        if (hasattr(LocalNodeInfo, 'etcds')):
            for etcdInst in LocalNodeInfo.etcds:
                allIP += etcdInst.haIps
                allIP += etcdInst.listenIps

        allIP.sort()
        for i in range(len(allIP) - 2, -1, -1):
            if allIP.count(allIP[i]) > 1:
                del allIP[i]
        noPassIPs = g_network.checkIpAddressList(allIP)
        if noPassIPs == []:
            self.result.rst = ResultStatus.OK
            self.result.raw = "All IP can pinged."
        else:
            self.result.rst = ResultStatus.NG
            self.result.raw = "The following IP can not pinged: \n%s" % noPassIPs
