#!/usr/bin/env python3
#-*- coding:utf-8 -*-
try:
    import sys
    import importlib
    importlib.reload(sys)
    from gspylib.inspection.common import SharedFuncs
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
except ImportError as e:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(e))


class CheckPgxcRedistb(BaseItem):
    def __init__(self):
        super(CheckPgxcRedistb, self).__init__(self.__class__.__name__)
        self.version = None

    def doCheck(self):
        databaseListSql = "select datname from pg_catalog.pg_database where datname != 'template0';"
        output = SharedFuncs.runSqlCmd(databaseListSql, self.user, "", self.port, self.tmpPath, "postgres",
                                       self.mpprcFile)
        dbList = output.split("\n")
        residue = False
        residueTableSql = "select * from pg_catalog.pg_tables where tablename='pgxc_redistb';"
        residueSchemaSql = "select * from pg_catalog.pg_namespace where nspname='data_redis';"

        self.result.raw = residueTableSql + residueSchemaSql
        for dbName in dbList:
            #Check temporary table residue
            output = SharedFuncs.runSqlCmd(residueTableSql, self.user, "", self.port, self.tmpPath, dbName,
                                           self.mpprcFile)
            if output:
                residue = True
                self.result.val += "Redistributed temporary table pgxc_redistb has existed in database %s." % dbName
            #Check temporary schema residues
            output = SharedFuncs.runSqlCmd(residueSchemaSql, self.user, "", self.port, self.tmpPath, dbName,
                                           self.mpprcFile)
            if output:
                residue = True
                self.result.val += "Redistributed temporary schema data_redis has existed in database %s." % dbName

        if (residue):
            self.result.rst = ResultStatus.NG
        else:
            self.result.rst = ResultStatus.OK
            self.result.val += "Residue Table pgxc_redistb and residue schema data_redis do not exist in the cluster."
