#!/usr/bin/env python3
# -*- coding:utf-8 -*-

try:
    import sys
    import importlib
    importlib.reload(sys)
    from gspylib.inspection.common import SharedFuncs
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
except ImportError as e:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(e))


class CheckGaussVer(BaseItem):
    def __init__(self):
        super(CheckGaussVer, self).__init__(self.__class__.__name__)

    def doCheck(self):
        # Get the version
        cmd = "gaussdb -V | awk -F '(' '{print $2}' |awk -F ')' '{print $1}'"
        self.result.raw = cmd + "\n"
        gaussdbVersion = SharedFuncs.runShellCmd(cmd, "", self.mpprcFile)
        if (gaussdbVersion[-1] == ")"):
            gaussdbVersion = gaussdbVersion[:-1]
        # Get the version
        cmd = "gsql -V | awk -F '(' '{print $2}' |awk -F ')' '{print $1}'"
        self.result.raw += cmd
        gsqlVersion = SharedFuncs.runShellCmd(cmd, "", self.mpprcFile)
        if (gsqlVersion[-1] == ")"):
            gsqlVersion = gsqlVersion[:-1]
        # Compare the two version numbers are the same
        if (not (gaussdbVersion == "" or gaussdbVersion is None)) and (gaussdbVersion == gsqlVersion):
            self.result.rst = ResultStatus.OK
        else:
            self.result.rst = ResultStatus.NG
        self.result.val = "gaussdb Version: %s \ngsql Version: %s" % (gaussdbVersion, gsqlVersion)
