SET
IsInplaceUpgrade = on;
DO
$$
DECLARE
CURSOR ev_cursor IS
SELECT /*+ nestloop(n c) indexscan(c) */c.oid
FROM pg_class c
         INNER JOIN pg_namespace n ON n.oid = c.relnamespace
WHERE relkind = 'v'
  AND nspname IN ('pg_catalog', 'information_schema', 'sys');
rd
RECORD;
updateStr
text;
viewdef
text;
BEGIN
OPEN ev_cursor;
LOOP
FETCH ev_cursor INTO rd;
EXIT
WHEN NOT FOUND;
BEGIN
PERFORM
pg_get_viewdef(rd.oid);
EXCEPTION WHEN OTHERS THEN
updateStr := 'UPDATE pg_catalog.pg_rewrite SET ev_enabled=''D'' WHERE ev_class = ' || rd.oid;
EXECUTE updateStr;
SELECT pg_get_viewdef(rd.oid, 1, 1)
INTO viewdef;
EXECUTE viewdef;
RAISE
NOTICE E'REBUILD VIEW % WITH DEFINATION \n %', rd.oid::regclass, viewdef;
END;
END LOOP;
CLOSE ev_cursor;
END $$;
