/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.sqlgen;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLData;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.BreakIterator;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.postgresql.pljava.ResultSetHandle;
import org.postgresql.pljava.ResultSetProvider;
import org.postgresql.pljava.TriggerData;
import org.postgresql.pljava.annotation.BaseUDT;
import org.postgresql.pljava.annotation.Function;
import org.postgresql.pljava.annotation.MappedUDT;
import org.postgresql.pljava.annotation.SQLAction;
import org.postgresql.pljava.annotation.SQLActions;
import org.postgresql.pljava.annotation.SQLType;
import org.postgresql.pljava.annotation.Trigger;
import org.postgresql.pljava.sqlgen.AnnotationValueException;
import org.postgresql.pljava.sqlgen.Commentable;
import org.postgresql.pljava.sqlgen.DDRWriter;
import org.postgresql.pljava.sqlgen.Snippet;
import org.postgresql.pljava.sqlgen.TriggerNamer;
import org.postgresql.pljava.sqlgen.Vertex;

class DDRProcessorImpl {
    final Elements elmu;
    final Filer filr;
    final Locale loca;
    final Messager msgr;
    final Map<String, String> opts;
    final SourceVersion srcv;
    final Types typu;
    final TypeMapper tmpr;
    final String nameTrusted;
    final String nameUntrusted;
    final String output;
    final String defaultImplementor;
    final DeclaredType TY_ITERATOR;
    final DeclaredType TY_OBJECT;
    final DeclaredType TY_RESULTSET;
    final DeclaredType TY_RESULTSETPROVIDER;
    final DeclaredType TY_RESULTSETHANDLE;
    final DeclaredType TY_SQLDATA;
    final DeclaredType TY_SQLINPUT;
    final DeclaredType TY_SQLOUTPUT;
    final DeclaredType TY_STRING;
    final DeclaredType TY_TRIGGERDATA;
    final NoType TY_VOID;
    final TypeElement AN_FUNCTION;
    final TypeElement AN_SQLACTION;
    final TypeElement AN_SQLACTIONS;
    final TypeElement AN_SQLTYPE;
    final TypeElement AN_TRIGGER;
    final TypeElement AN_BASEUDT;
    final TypeElement AN_MAPPEDUDT;
    Map<SnippetsKey, Snippet> snippets = new HashMap<SnippetsKey, Snippet>();
    Queue<Vertex<Snippet>> snippetQueue = new LinkedList<Vertex<Snippet>>();
    Map<String, Vertex<Snippet>> provider = new HashMap<String, Vertex<Snippet>>();
    Set<String> consumer = new HashSet<String>();
    static final Pattern arrayish = Pattern.compile("(?si:(?:\\[\\s*\\d*\\s*\\]|ARRAY)\\s*)$");

    DDRProcessorImpl(ProcessingEnvironment processingEnvironment) {
        this.elmu = processingEnvironment.getElementUtils();
        this.filr = processingEnvironment.getFiler();
        this.loca = processingEnvironment.getLocale();
        this.msgr = processingEnvironment.getMessager();
        this.opts = processingEnvironment.getOptions();
        this.srcv = processingEnvironment.getSourceVersion();
        this.typu = processingEnvironment.getTypeUtils();
        this.tmpr = new TypeMapper();
        String string = this.opts.get("ddr.name.trusted");
        this.nameTrusted = null != string ? string : "java";
        string = this.opts.get("ddr.name.untrusted");
        this.nameUntrusted = null != string ? string : "javaU";
        string = this.opts.get("ddr.implementor");
        this.defaultImplementor = null != string ? ("-".equals(string) ? null : string) : "PostgreSQL";
        string = this.opts.get("ddr.output");
        this.output = null != string ? string : "pljava.ddr";
        this.TY_ITERATOR = this.typu.getDeclaredType(this.elmu.getTypeElement(Iterator.class.getName()), new TypeMirror[0]);
        this.TY_OBJECT = this.typu.getDeclaredType(this.elmu.getTypeElement(Object.class.getName()), new TypeMirror[0]);
        this.TY_RESULTSET = this.typu.getDeclaredType(this.elmu.getTypeElement(ResultSet.class.getName()), new TypeMirror[0]);
        this.TY_RESULTSETPROVIDER = this.typu.getDeclaredType(this.elmu.getTypeElement(ResultSetProvider.class.getName()), new TypeMirror[0]);
        this.TY_RESULTSETHANDLE = this.typu.getDeclaredType(this.elmu.getTypeElement(ResultSetHandle.class.getName()), new TypeMirror[0]);
        this.TY_SQLDATA = this.typu.getDeclaredType(this.elmu.getTypeElement(SQLData.class.getName()), new TypeMirror[0]);
        this.TY_SQLINPUT = this.typu.getDeclaredType(this.elmu.getTypeElement(SQLInput.class.getName()), new TypeMirror[0]);
        this.TY_SQLOUTPUT = this.typu.getDeclaredType(this.elmu.getTypeElement(SQLOutput.class.getName()), new TypeMirror[0]);
        this.TY_STRING = this.typu.getDeclaredType(this.elmu.getTypeElement(String.class.getName()), new TypeMirror[0]);
        this.TY_TRIGGERDATA = this.typu.getDeclaredType(this.elmu.getTypeElement(TriggerData.class.getName()), new TypeMirror[0]);
        this.TY_VOID = this.typu.getNoType(TypeKind.VOID);
        this.AN_FUNCTION = this.elmu.getTypeElement(Function.class.getName());
        this.AN_SQLACTION = this.elmu.getTypeElement(SQLAction.class.getName());
        this.AN_SQLACTIONS = this.elmu.getTypeElement(SQLActions.class.getName());
        this.AN_SQLTYPE = this.elmu.getTypeElement(SQLType.class.getName());
        this.AN_TRIGGER = this.elmu.getTypeElement(Trigger.class.getName());
        this.AN_BASEUDT = this.elmu.getTypeElement(BaseUDT.class.getName());
        this.AN_MAPPEDUDT = this.elmu.getTypeElement(MappedUDT.class.getName());
    }

    void msg(Diagnostic.Kind kind, String string, Object ... objectArray) {
        this.msgr.printMessage(kind, String.format(string, objectArray));
    }

    void msg(Diagnostic.Kind kind, Element element, String string, Object ... objectArray) {
        this.msgr.printMessage(kind, String.format(string, objectArray), element);
    }

    void msg(Diagnostic.Kind kind, Element element, AnnotationMirror annotationMirror, String string, Object ... objectArray) {
        this.msgr.printMessage(kind, String.format(string, objectArray), element, annotationMirror);
    }

    void msg(Diagnostic.Kind kind, Element element, AnnotationMirror annotationMirror, AnnotationValue annotationValue, String string, Object ... objectArray) {
        this.msgr.printMessage(kind, String.format(string, objectArray), element, annotationMirror, annotationValue);
    }

    <S extends Snippet> S getSnippet(Object object, Class<S> clazz) {
        return (S)this.snippets.get(new SnippetsKey(object, clazz));
    }

    void putSnippet(Object object, Snippet snippet) {
        this.snippets.put(new SnippetsKey(object, snippet.getClass()), snippet);
    }

    boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = true;
        for (TypeElement element : set) {
            if (this.AN_FUNCTION.equals(element)) {
                bl = true;
                continue;
            }
            if (this.AN_SQLACTION.equals(element)) {
                bl2 = true;
                continue;
            }
            if (this.AN_SQLACTIONS.equals(element)) {
                bl3 = true;
                continue;
            }
            if (this.AN_BASEUDT.equals(element)) {
                bl4 = true;
                continue;
            }
            if (this.AN_MAPPEDUDT.equals(element)) {
                bl5 = true;
                continue;
            }
            if (this.AN_SQLTYPE.equals(element)) continue;
            this.msg(Diagnostic.Kind.WARNING, (Element)element, "pljava annotation processor version may be older than this annotation:\n%s", element.toString());
            bl6 = false;
        }
        if (bl4) {
            for (Element element : roundEnvironment.getElementsAnnotatedWith(this.AN_BASEUDT)) {
                this.processUDT(element, UDTKind.BASE);
            }
        }
        if (bl5) {
            for (Element element : roundEnvironment.getElementsAnnotatedWith(this.AN_MAPPEDUDT)) {
                this.processUDT(element, UDTKind.MAPPED);
            }
        }
        if (bl) {
            for (Element element : roundEnvironment.getElementsAnnotatedWith(this.AN_FUNCTION)) {
                this.processFunction(element);
            }
        }
        if (bl2) {
            for (Element element : roundEnvironment.getElementsAnnotatedWith(this.AN_SQLACTION)) {
                this.processSQLAction(element);
            }
        }
        if (bl3) {
            for (Element element : roundEnvironment.getElementsAnnotatedWith(this.AN_SQLACTIONS)) {
                this.processSQLActions(element);
            }
        }
        this.tmpr.workAroundJava7Breakage();
        if (!roundEnvironment.processingOver()) {
            this.defensiveEarlyCharacterize();
        } else if (!roundEnvironment.errorRaised()) {
            this.generateDescriptor();
        }
        return bl6;
    }

    void defensiveEarlyCharacterize() {
        for (Snippet snippet : this.snippets.values()) {
            if (!snippet.characterize()) continue;
            Vertex<Snippet> vertex = new Vertex<Snippet>(snippet);
            this.snippetQueue.add(vertex);
            for (String string : snippet.provides()) {
                if (null == this.provider.put(string, vertex)) continue;
                this.msg(Diagnostic.Kind.ERROR, "tag %s has more than one provider", string);
            }
            for (String string : snippet.requires()) {
                this.consumer.add(string);
            }
        }
        this.snippets.clear();
    }

    void generateDescriptor() {
        Snippet[] snippetArray;
        block13: {
            boolean bl = false;
            for (Vertex object2 : this.snippetQueue) {
                for (String n2 : ((Snippet)object2.payload).requires()) {
                    Vertex<Snippet> n3 = this.provider.get(n2);
                    if (null != n3) {
                        n3.precede(object2);
                        continue;
                    }
                    if (n2 == ((Snippet)object2.payload).implementor()) {
                        if (this.defaultImplementor.equals(n2)) continue;
                        ++object2.indegree;
                        continue;
                    }
                    this.msg(Diagnostic.Kind.ERROR, "tag \"%s\" is required but nowhere provided", n2);
                    bl = true;
                }
            }
            if (bl) {
                return;
            }
            snippetArray = new Snippet[this.snippetQueue.size()];
            LinkedList linkedList = new LinkedList();
            Iterator n = this.snippetQueue.iterator();
            while (n.hasNext()) {
                Vertex iterator2 = (Vertex)n.next();
                if (0 != iterator2.indegree) continue;
                linkedList.add(iterator2);
                n.remove();
            }
            int iOException = 0;
            block5: while (true) {
                String[] string;
                Iterator<String> iterator;
                if (!linkedList.isEmpty()) {
                    iterator = (Vertex)linkedList.remove();
                    snippetArray[iOException++] = (Snippet)((Vertex)((Object)iterator)).payload;
                    ((Vertex)((Object)iterator)).use(linkedList, this.snippetQueue);
                    string = ((Snippet)((Vertex)((Object)iterator)).payload).provides();
                    int n2 = string.length;
                    int n3 = 0;
                    while (true) {
                        if (n3 >= n2) continue block5;
                        String string2 = string[n3];
                        this.consumer.remove(string2);
                        ++n3;
                    }
                }
                if (this.snippetQueue.isEmpty()) break block13;
                iterator = this.snippetQueue.iterator();
                while (iterator.hasNext()) {
                    string = (String[])iterator.next();
                    if (1 < string.indegree || null == ((Snippet)string.payload).implementor() || this.provider.containsKey(((Snippet)string.payload).implementor())) continue;
                    --string.indegree;
                    iterator.remove();
                    linkedList.add(string);
                    continue block5;
                }
                break;
            }
            for (String string : this.consumer) {
                this.msg(Diagnostic.Kind.ERROR, "requirement in a cycle: %s", string);
            }
            return;
        }
        try {
            DDRWriter.emit(snippetArray, this);
        }
        catch (IOException iOException) {
            this.msg(Diagnostic.Kind.ERROR, "while writing %s: %s", this.output, iOException.getMessage());
        }
    }

    void processSQLAction(Element element) {
        SQLActionImpl sQLActionImpl = this.getSnippet(element, SQLActionImpl.class);
        if (null == sQLActionImpl) {
            sQLActionImpl = new SQLActionImpl();
            this.putSnippet(element, sQLActionImpl);
        }
        for (AnnotationMirror annotationMirror : this.elmu.getAllAnnotationMirrors(element)) {
            if (!annotationMirror.getAnnotationType().asElement().equals(this.AN_SQLACTION)) continue;
            this.populateAnnotationImpl(sQLActionImpl, element, annotationMirror);
        }
    }

    void processSQLActions(Element element) {
        for (AnnotationMirror annotationMirror : this.elmu.getAllAnnotationMirrors(element)) {
            if (!annotationMirror.getAnnotationType().asElement().equals(this.AN_SQLACTIONS)) continue;
            SQLActionsImpl sQLActionsImpl = new SQLActionsImpl();
            this.populateAnnotationImpl(sQLActionsImpl, element, annotationMirror);
            for (SQLAction sQLAction : sQLActionsImpl.value()) {
                this.putSnippet(sQLAction, (Snippet)((Object)sQLAction));
            }
        }
    }

    void processUDT(Element element, UDTKind uDTKind) {
        Object object;
        switch (element.getKind()) {
            case CLASS: {
                break;
            }
            case ANNOTATION_TYPE: 
            case ENUM: 
            case INTERFACE: {
                this.msg(Diagnostic.Kind.ERROR, element, "A pljava UDT must be a class", new Object[0]);
            }
            default: {
                return;
            }
        }
        Set<Modifier> set = element.getModifiers();
        if (!set.contains((Object)Modifier.PUBLIC)) {
            this.msg(Diagnostic.Kind.ERROR, element, "A pljava UDT must be public", new Object[0]);
        }
        if (set.contains((Object)Modifier.ABSTRACT)) {
            this.msg(Diagnostic.Kind.ERROR, element, "A pljava UDT must not be abstract", new Object[0]);
        }
        if (!((TypeElement)element).getNestingKind().equals((Object)NestingKind.TOP_LEVEL)) {
            if (!set.contains((Object)Modifier.STATIC)) {
                this.msg(Diagnostic.Kind.ERROR, element, "When nested, a pljava UDT must be static (not inner)", new Object[0]);
            }
            object = element;
            while (null != (object = object.getEnclosingElement())) {
                if (!object.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    this.msg(Diagnostic.Kind.ERROR, (Element)object, "A pljava UDT must not have a non-public enclosing class", new Object[0]);
                }
                if (!((TypeElement)object).getNestingKind().equals((Object)NestingKind.TOP_LEVEL)) continue;
            }
        }
        switch (uDTKind) {
            case BASE: {
                object = this.getSnippet(element, BaseUDTImpl.class);
                if (null == object) {
                    object = new BaseUDTImpl((TypeElement)element);
                    this.putSnippet(element, (Snippet)object);
                }
                for (AnnotationMirror annotationMirror : this.elmu.getAllAnnotationMirrors(element)) {
                    if (!annotationMirror.getAnnotationType().asElement().equals(this.AN_BASEUDT)) continue;
                    this.populateAnnotationImpl((AbstractAnnotationImpl)object, element, annotationMirror);
                }
                ((BaseUDTImpl)object).registerFunctions();
                break;
            }
            case MAPPED: {
                MappedUDTImpl mappedUDTImpl = this.getSnippet(element, MappedUDTImpl.class);
                if (null == mappedUDTImpl) {
                    mappedUDTImpl = new MappedUDTImpl((TypeElement)element);
                    this.putSnippet(element, mappedUDTImpl);
                }
                for (AnnotationMirror annotationMirror : this.elmu.getAllAnnotationMirrors(element)) {
                    if (!annotationMirror.getAnnotationType().asElement().equals(this.AN_MAPPEDUDT)) continue;
                    this.populateAnnotationImpl(mappedUDTImpl, element, annotationMirror);
                }
                break;
            }
        }
    }

    ExecutableElement huntFor(List<ExecutableElement> list, String string, boolean bl, TypeMirror typeMirror, TypeMirror ... typeMirrorArray) {
        ExecutableElement executableElement = null;
        block0: for (ExecutableElement executableElement2 : list) {
            List<? extends TypeMirror> list2;
            if (null != string && !executableElement2.getSimpleName().contentEquals(string) || executableElement2.isVarArgs() || null != typeMirror && !this.typu.isSameType(executableElement2.getReturnType(), typeMirror) || (list2 = ((ExecutableType)executableElement2.asType()).getParameterTypes()).size() != typeMirrorArray.length) continue;
            for (int i = 0; i < typeMirrorArray.length; ++i) {
                if (!this.typu.isSameType(list2.get(i), typeMirrorArray[i])) continue block0;
            }
            Set<Modifier> set = executableElement2.getModifiers();
            if (!set.contains((Object)Modifier.PUBLIC) || bl && !set.contains((Object)Modifier.STATIC)) continue;
            if (null == executableElement) {
                executableElement = executableElement2;
                continue;
            }
            this.msg(Diagnostic.Kind.ERROR, (Element)executableElement2, "Found more than one candidate " + (null == string ? "constructor" : string + " method"), new Object[0]);
        }
        return executableElement;
    }

    void processFunction(Element element) {
        if (!ElementKind.METHOD.equals((Object)element.getKind())) {
            return;
        }
        Set<Modifier> set = element.getModifiers();
        if (!set.contains((Object)Modifier.PUBLIC)) {
            this.msg(Diagnostic.Kind.ERROR, element, "A pljava function must be public", new Object[0]);
        }
        Object object = element;
        while (null != (object = object.getEnclosingElement())) {
            if (!ElementKind.CLASS.equals((Object)object.getKind())) continue;
            if (!object.getModifiers().contains((Object)Modifier.PUBLIC)) {
                this.msg(Diagnostic.Kind.ERROR, (Element)object, "A pljava function must not have a non-public enclosing class", new Object[0]);
            }
            if (!((TypeElement)object).getNestingKind().equals((Object)NestingKind.TOP_LEVEL)) continue;
        }
        if (null == (object = this.getSnippet(element, FunctionImpl.class))) {
            object = new FunctionImpl((ExecutableElement)element);
            this.putSnippet(element, (Snippet)object);
        }
        for (AnnotationMirror annotationMirror : this.elmu.getAllAnnotationMirrors(element)) {
            if (!annotationMirror.getAnnotationType().asElement().equals(this.AN_FUNCTION)) continue;
            this.populateAnnotationImpl((AbstractAnnotationImpl)object, element, annotationMirror);
        }
    }

    static <T> T[] avToArray(Object object, Class<T> clazz) {
        boolean bl = clazz.isEnum();
        List list = (List)object;
        Object[] objectArray = (Object[])Array.newInstance(clazz, list.size());
        int n = 0;
        for (AnnotationValue annotationValue : list) {
            Object object2 = DDRProcessorImpl.getValue(annotationValue);
            if (bl) {
                object2 = Enum.valueOf(clazz.asSubclass(Enum.class), ((VariableElement)object2).getSimpleName().toString());
            }
            objectArray[n++] = clazz.cast(object2);
        }
        return objectArray;
    }

    void populateAnnotationImpl(AbstractAnnotationImpl abstractAnnotationImpl, Element element, AnnotationMirror annotationMirror) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
        Map<? extends ExecutableElement, ? extends AnnotationValue> map2 = this.elmu.getElementValuesWithDefaults(annotationMirror);
        Element element2 = annotationMirror.getAnnotationType().asElement();
        List<ExecutableElement> list = ElementFilter.methodsIn(element2.getEnclosedElements());
        for (ExecutableElement object : list) {
            if (map2.containsKey(object)) continue;
            this.msg(Diagnostic.Kind.ERROR, element, annotationMirror, "annotation missing required element \"%s\"", object.getSimpleName());
        }
        for (Map.Entry entry : map2.entrySet()) {
            Object object;
            Object noSuchMethodException;
            ExecutableElement executableElement = (ExecutableElement)entry.getKey();
            AnnotationValue annotationValue = (AnnotationValue)entry.getValue();
            boolean bl = map.containsKey(executableElement);
            String string = executableElement.getSimpleName().toString();
            Class<?> clazz = abstractAnnotationImpl.getClass();
            try {
                noSuchMethodException = DDRProcessorImpl.getValue(annotationValue);
                clazz.getMethod("set" + string.substring(0, 1).toUpperCase() + string.substring(1), Object.class, Boolean.TYPE, Element.class).invoke((Object)abstractAnnotationImpl, noSuchMethodException, bl, element);
            }
            catch (AnnotationValueException illegalAccessException) {
                this.msg(Diagnostic.Kind.ERROR, element, annotationMirror, "unresolved value for annotation member \"%s\" (check for missing/misspelled import, etc.)", string);
            }
            catch (NoSuchMethodException invocationTargetException) {
                object = DDRProcessorImpl.getValue(annotationValue);
                try {
                    Field illegalAccessException = clazz.getField("_" + string);
                    Class<?> clazz2 = illegalAccessException.getType();
                    if (!bl && null != illegalAccessException.get(abstractAnnotationImpl)) continue;
                    if (clazz2.isArray()) {
                        try {
                            illegalAccessException.set(abstractAnnotationImpl, DDRProcessorImpl.avToArray(object, clazz2.getComponentType()));
                        }
                        catch (AnnotationValueException annotationValueException) {
                            this.msg(Diagnostic.Kind.ERROR, element, annotationMirror, "unresolved value for an element of annotation member \"%s\" (check for missing/misspelled import, etc.)", string);
                        }
                    } else if (clazz2.isEnum()) {
                        illegalAccessException.set(abstractAnnotationImpl, Enum.valueOf(clazz2.asSubclass(Enum.class), ((VariableElement)object).getSimpleName().toString()));
                    } else {
                        illegalAccessException.set(abstractAnnotationImpl, object);
                    }
                    noSuchMethodException = null;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                if (null == noSuchMethodException) continue;
                throw new RuntimeException("Incomplete implementation in annotation processor", (Throwable)noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("Incorrect implementation of annotation processor", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                object = invocationTargetException.getCause().getMessage();
                this.msg(Diagnostic.Kind.ERROR, element, annotationMirror, annotationValue, "%s", object);
            }
        }
    }

    static Object getValue(AnnotationValue annotationValue) {
        if ("com.sun.tools.javac.code.Attribute.Error".equals(annotationValue.getClass().getCanonicalName())) {
            throw new AnnotationValueException();
        }
        return annotationValue.getValue();
    }

    class TypeMapper {
        ArrayList<Map.Entry<Class<?>, String>> protoMappings = new ArrayList();
        ArrayList<Map.Entry<TypeMirror, String>> finalMappings;

        TypeMapper() {
            this.addMap(Boolean.TYPE, "boolean");
            this.addMap(Boolean.class, "boolean");
            this.addMap(Byte.TYPE, "smallint");
            this.addMap(Byte.class, "smallint");
            this.addMap(Character.TYPE, "smallint");
            this.addMap(Character.class, "smallint");
            this.addMap(Double.TYPE, "double precision");
            this.addMap(Double.class, "double precision");
            this.addMap(Float.TYPE, "real");
            this.addMap(Float.class, "real");
            this.addMap(Integer.TYPE, "integer");
            this.addMap(Integer.class, "integer");
            this.addMap(Long.TYPE, "bigint");
            this.addMap(Long.class, "bigint");
            this.addMap(Short.TYPE, "smallint");
            this.addMap(Short.class, "smallint");
            this.addMap(Number.class, "numeric");
            this.addMap(String.class, "varchar");
            this.addMap(Date.class, "timestamp");
            this.addMap(Timestamp.class, "timestamp");
            this.addMap(Time.class, "time");
            this.addMap(java.sql.Date.class, "date");
            this.addMap(BigInteger.class, "numeric");
            this.addMap(BigDecimal.class, "numeric");
            this.addMap(ResultSet.class, "record");
            this.addMap(Object.class, "\"any\"");
            this.addMap(byte[].class, "bytea");
        }

        private void workAroundJava7Breakage() {
            Object object;
            if (null != this.finalMappings) {
                return;
            }
            ArrayList arrayList = new ArrayList(this.protoMappings.size());
            for (Map.Entry<Class<?>, String> object32 : this.protoMappings) {
                arrayList.add(new Vertex(object32));
            }
            int n = arrayList.size();
            while (n-- > 1) {
                Vertex vertex = (Vertex)arrayList.get(n);
                Class clazz = (Class)((Map.Entry)vertex.payload).getKey();
                int n2 = n;
                while (n2-- > 0) {
                    object = (Vertex)arrayList.get(n2);
                    Class clazz2 = (Class)((Map.Entry)((Vertex)object).payload).getKey();
                    boolean bl = clazz.isAssignableFrom(clazz2);
                    boolean bl2 = clazz2.isAssignableFrom(clazz);
                    if (bl2 == bl) continue;
                    if (bl) {
                        ((Vertex)object).precede(vertex);
                        continue;
                    }
                    vertex.precede(object);
                }
            }
            LinkedList linkedList = new LinkedList();
            for (Vertex vertex : arrayList) {
                if (0 != vertex.indegree) continue;
                linkedList.add(vertex);
            }
            this.finalMappings = new ArrayList(this.protoMappings.size());
            this.protoMappings.clear();
            while (!linkedList.isEmpty()) {
                TypeMirror typeMirror;
                Vertex vertex = (Vertex)linkedList.remove();
                vertex.use(linkedList);
                Class clazz = (Class)((Map.Entry)vertex.payload).getKey();
                if (clazz.isPrimitive()) {
                    object = TypeKind.valueOf(clazz.getName().toUpperCase());
                    typeMirror = DDRProcessorImpl.this.typu.getPrimitiveType((TypeKind)((Object)object));
                } else {
                    object = DDRProcessorImpl.this.elmu.getTypeElement(clazz.getName());
                    if (null == object) {
                        DDRProcessorImpl.this.msg(Diagnostic.Kind.WARNING, "Found no TypeElement for %s", clazz.getName());
                        continue;
                    }
                    typeMirror = object.asType();
                }
                this.finalMappings.add(new AbstractMap.SimpleImmutableEntry((PrimitiveType)typeMirror, ((Map.Entry)vertex.payload).getValue()));
            }
        }

        void addMap(Class<?> clazz, String string) {
            if (null != this.finalMappings) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, "addMap(%s, %s)\ncalled after workAroundJava7Breakage", clazz.getName(), string);
                return;
            }
            this.protoMappings.add(new AbstractMap.SimpleImmutableEntry(clazz, string));
        }

        String getSQLType(TypeMirror typeMirror, Element element) {
            return this.getSQLType(typeMirror, element, false, false);
        }

        String getSQLType(TypeMirror typeMirror, Element element, boolean bl, boolean bl2) {
            boolean bl3 = false;
            String string = null;
            String[] stringArray = null;
            ArrayList arrayList = DDRProcessorImpl.this.elmu.getAllAnnotationMirrors(element).iterator();
            while (arrayList.hasNext()) {
                AnnotationMirror annotationMirror = arrayList.next();
                if (!annotationMirror.getAnnotationType().asElement().equals(DDRProcessorImpl.this.AN_SQLTYPE)) continue;
                Object object = new SQLTypeImpl();
                DDRProcessorImpl.this.populateAnnotationImpl((AbstractAnnotationImpl)object, element, annotationMirror);
                string = ((SQLTypeImpl)object).value();
                stringArray = ((SQLTypeImpl)object).defaultValue();
            }
            if (typeMirror.getKind().equals((Object)TypeKind.ARRAY) && !(arrayList = (ArrayType)typeMirror).getComponentType().getKind().equals((Object)TypeKind.BYTE)) {
                bl3 = true;
                typeMirror = arrayList.getComponentType();
            }
            if (null != string) {
                return this.typeWithDefault(string, bl3, stringArray, bl2);
            }
            if (typeMirror.getKind().equals((Object)TypeKind.VOID)) {
                return "void";
            }
            if (typeMirror.getKind().equals((Object)TypeKind.ERROR)) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, element, "Cannot determine mapping to SQL type for unresolved type", new Object[0]);
                string = typeMirror.toString();
            } else {
                arrayList = this.finalMappings;
                if (bl) {
                    arrayList = (ArrayList)arrayList.clone();
                    Collections.reverse(arrayList);
                }
                for (Object object : arrayList) {
                    TypeMirror typeMirror2 = (TypeMirror)object.getKey();
                    if (typeMirror2 instanceof PrimitiveType) {
                        if (!DDRProcessorImpl.this.typu.isSameType(typeMirror, typeMirror2)) continue;
                        string = (String)object.getValue();
                        break;
                    }
                    boolean bl4 = bl ? DDRProcessorImpl.this.typu.isAssignable(typeMirror2, typeMirror) : DDRProcessorImpl.this.typu.isAssignable(typeMirror, typeMirror2);
                    if (!bl4) continue;
                    if (!bl && DDRProcessorImpl.this.typu.isSameType(typeMirror2, DDRProcessorImpl.this.TY_OBJECT)) break;
                    string = (String)object.getValue();
                    break;
                }
            }
            if (null == string) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, element, "No known mapping to an SQL type", new Object[0]);
                string = typeMirror.toString();
            }
            if (bl3) {
                string = string + "[]";
            }
            return this.typeWithDefault(string, bl3, stringArray, bl2);
        }

        String typeWithDefault(String string, boolean bl, String[] stringArray, boolean bl2) {
            if (null == stringArray || !bl2) {
                return string;
            }
            int n = stringArray.length;
            if (n != 1) {
                bl = true;
            } else if (!bl) {
                bl = arrayish.matcher(string).matches();
            }
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.append(" DEFAULT CAST(");
            if (bl) {
                stringBuilder.append("ARRAY[");
            }
            if (n != 1) {
                stringBuilder.append("\n\t");
            }
            for (String string2 : stringArray) {
                stringBuilder.append(DDRWriter.eQuote(string2));
                if (0 >= --n) continue;
                stringBuilder.append(",\n\t");
            }
            if (bl) {
                stringBuilder.append(']');
            }
            stringBuilder.append(" AS ").append(string).append(')');
            return stringBuilder.toString();
        }
    }

    class BaseUDTImpl
    extends AbstractUDTImpl
    implements BaseUDT {
        BaseUDTFunctionImpl in;
        BaseUDTFunctionImpl out;
        BaseUDTFunctionImpl recv;
        BaseUDTFunctionImpl send;
        public String _typeModifierInput;
        public String _typeModifierOutput;
        public String _analyze;
        int _internalLength;
        public Boolean _passedByValue;
        BaseUDT.Alignment _alignment;
        BaseUDT.Storage _storage;
        public String _like;
        char _category;
        public Boolean _preferred;
        String _defaultValue;
        public String _element;
        char _delimiter;
        public Boolean _collatable;
        boolean lengthExplicit;
        boolean alignmentExplicit;
        boolean storageExplicit;
        boolean categoryExplicit;
        boolean delimiterExplicit;

        @Override
        public String typeModifierInput() {
            return this._typeModifierInput;
        }

        @Override
        public String typeModifierOutput() {
            return this._typeModifierOutput;
        }

        @Override
        public String analyze() {
            return this._analyze;
        }

        @Override
        public int internalLength() {
            return this._internalLength;
        }

        @Override
        public boolean passedByValue() {
            return this._passedByValue;
        }

        @Override
        public BaseUDT.Alignment alignment() {
            return this._alignment;
        }

        @Override
        public BaseUDT.Storage storage() {
            return this._storage;
        }

        @Override
        public String like() {
            return this._like;
        }

        @Override
        public char category() {
            return this._category;
        }

        @Override
        public boolean preferred() {
            return this._preferred;
        }

        @Override
        public String defaultValue() {
            return this._defaultValue;
        }

        @Override
        public String element() {
            return this._element;
        }

        @Override
        public char delimiter() {
            return this._delimiter;
        }

        @Override
        public boolean collatable() {
            return this._collatable;
        }

        public void setInternalLength(Object object, boolean bl, Element element) {
            this._internalLength = (Integer)object;
            this.lengthExplicit = bl;
        }

        public void setAlignment(Object object, boolean bl, Element element) {
            this._alignment = BaseUDT.Alignment.valueOf(((VariableElement)object).getSimpleName().toString());
            this.alignmentExplicit = bl;
        }

        public void setStorage(Object object, boolean bl, Element element) {
            this._storage = BaseUDT.Storage.valueOf(((VariableElement)object).getSimpleName().toString());
            this.categoryExplicit = bl;
        }

        public void setDefaultValue(Object object, boolean bl, Element element) {
            if (bl) {
                this._defaultValue = (String)object;
            }
        }

        public void setCategory(Object object, boolean bl, Element element) {
            this._category = ((Character)object).charValue();
            this.categoryExplicit = bl;
        }

        public void setDelimiter(Object object, boolean bl, Element element) {
            this._delimiter = ((Character)object).charValue();
            this.delimiterExplicit = bl;
        }

        BaseUDTImpl(TypeElement typeElement) {
            super(typeElement);
        }

        void registerFunctions() {
            this.setQname();
            ExecutableElement executableElement = DDRProcessorImpl.this.huntFor(ElementFilter.methodsIn(this.tclass.getEnclosedElements()), "readSQL", false, DDRProcessorImpl.this.TY_VOID, DDRProcessorImpl.this.TY_SQLINPUT, DDRProcessorImpl.this.TY_STRING);
            ExecutableElement executableElement2 = DDRProcessorImpl.this.huntFor(ElementFilter.methodsIn(this.tclass.getEnclosedElements()), "writeSQL", false, DDRProcessorImpl.this.TY_VOID, DDRProcessorImpl.this.TY_SQLOUTPUT);
            ExecutableElement executableElement3 = DDRProcessorImpl.this.huntFor(ElementFilter.methodsIn(this.tclass.getEnclosedElements()), "toString", false, DDRProcessorImpl.this.TY_STRING, new TypeMirror[0]);
            ExecutableElement executableElement4 = DDRProcessorImpl.this.huntFor(ElementFilter.methodsIn(this.tclass.getEnclosedElements()), "parse", true, this.tclass.asType(), DDRProcessorImpl.this.TY_STRING, DDRProcessorImpl.this.TY_STRING);
            if (null == executableElement4) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.tclass, "A pljava UDT must have a public static parse(String,String) method that returns the UDT", new Object[0]);
            } else {
                this.in = new BaseUDTFunctionImpl(this, this.tclass, BaseUDTFunctionID.INPUT);
                DDRProcessorImpl.this.putSnippet(executableElement4, this.in);
            }
            this.out = new BaseUDTFunctionImpl(this, this.tclass, BaseUDTFunctionID.OUTPUT);
            DDRProcessorImpl.this.putSnippet(null != executableElement3 ? executableElement3 : this.out, this.out);
            this.recv = new BaseUDTFunctionImpl(this, this.tclass, BaseUDTFunctionID.RECEIVE);
            DDRProcessorImpl.this.putSnippet(null != executableElement ? executableElement : this.recv, this.recv);
            this.send = new BaseUDTFunctionImpl(this, this.tclass, BaseUDTFunctionID.SEND);
            DDRProcessorImpl.this.putSnippet(null != executableElement2 ? executableElement2 : this.send, this.send);
        }

        @Override
        public boolean characterize() {
            if ("".equals(this.typeModifierInput()) && !"".equals(this.typeModifierOutput())) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.tclass, "UDT typeModifierOutput useless without typeModifierInput", new Object[0]);
            }
            if (1 > this.internalLength() && -1 != this.internalLength()) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.tclass, "UDT internalLength must be positive, or -1 for varying", new Object[0]);
            }
            if (this.passedByValue() && (8 < this.internalLength() || -1 == this.internalLength())) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.tclass, "Only a UDT of fixed length <= 8 can be passed by value", new Object[0]);
            }
            if (-1 == this.internalLength() && -1 == this.alignment().compareTo(BaseUDT.Alignment.INT4)) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.tclass, "A variable-length UDT must have alignment at least INT4", new Object[0]);
            }
            if (-1 != this.internalLength() && BaseUDT.Storage.PLAIN != this.storage()) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.tclass, "Storage for a fixed-length UDT must be PLAIN", new Object[0]);
            }
            if (' ' > this.category() || this.category() > '~') {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.tclass, "UDT category must be a printable ASCII character", new Object[0]);
            }
            this._requires = this.augmentRequires(this._requires, this.implementor());
            return true;
        }

        @Override
        public String[] deployStrings() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("CREATE TYPE " + this.qname);
            arrayList.addAll(Arrays.asList(this.in.deployStrings()));
            arrayList.addAll(Arrays.asList(this.out.deployStrings()));
            arrayList.addAll(Arrays.asList(this.recv.deployStrings()));
            arrayList.addAll(Arrays.asList(this.send.deployStrings()));
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CREATE TYPE ").append(this.qname).append(" (\n\t");
            this.in.appendTypeOp(stringBuilder).append(",\n\t");
            this.out.appendTypeOp(stringBuilder).append(",\n\t");
            this.recv.appendTypeOp(stringBuilder).append(",\n\t");
            this.send.appendTypeOp(stringBuilder);
            if (!"".equals(this.typeModifierInput())) {
                stringBuilder.append(",\n\tTYPMOD_IN = ").append(this.typeModifierInput());
            }
            if (!"".equals(this.typeModifierOutput())) {
                stringBuilder.append(",\n\tTYPMOD_OUT = ").append(this.typeModifierOutput());
            }
            if (!"".equals(this.analyze())) {
                stringBuilder.append(",\n\tANALYZE = ").append(this.typeModifierOutput());
            }
            if (this.lengthExplicit || "".equals(this.like())) {
                stringBuilder.append(",\n\tINTERNALLENGTH = ").append(-1 == this.internalLength() ? "VARIABLE" : String.valueOf(this.internalLength()));
            }
            if (this.passedByValue()) {
                stringBuilder.append(",\n\tPASSEDBYVALUE");
            }
            if (this.alignmentExplicit || "".equals(this.like())) {
                stringBuilder.append(",\n\tALIGNMENT = ").append(this.alignment().name());
            }
            if (this.storageExplicit || "".equals(this.like())) {
                stringBuilder.append(",\n\tSTORAGE = ").append(this.storage().name());
            }
            if (!"".equals(this.like())) {
                stringBuilder.append(",\n\tLIKE = ").append(this.like());
            }
            if (this.categoryExplicit) {
                stringBuilder.append(",\n\tCATEGORY = '").append(DDRWriter.eQuote(String.valueOf(this.category())));
            }
            if (this.preferred()) {
                stringBuilder.append(",\n\tPREFERRED = true");
            }
            if (null != this.defaultValue()) {
                stringBuilder.append(",\n\tDEFAULT = ").append(DDRWriter.eQuote(this.defaultValue()));
            }
            if (!"".equals(this.element())) {
                stringBuilder.append(",\n\tELEMENT = ").append(this.element());
            }
            if (this.delimiterExplicit) {
                stringBuilder.append(",\n\tDELIMITER = '").append(DDRWriter.eQuote(String.valueOf(this.delimiter())));
            }
            if (this.collatable()) {
                stringBuilder.append(",\n\tCOLLATABLE = true");
            }
            arrayList.add(stringBuilder.append("\n)").toString());
            this.addComment(arrayList);
            return arrayList.toArray(new String[arrayList.size()]);
        }

        @Override
        public String[] undeployStrings() {
            return new String[]{"DROP TYPE " + this.qname + " CASCADE"};
        }
    }

    class MappedUDTImpl
    extends AbstractUDTImpl
    implements MappedUDT {
        String[] _structure;

        @Override
        public String[] structure() {
            return this._structure;
        }

        public void setStructure(Object object, boolean bl, Element element) {
            if (bl) {
                this._structure = DDRProcessorImpl.avToArray(object, String.class);
            }
        }

        MappedUDTImpl(TypeElement typeElement) {
            super(typeElement);
        }

        @Override
        public boolean characterize() {
            this.setQname();
            this._requires = this.augmentRequires(this._requires, this.implementor());
            return true;
        }

        @Override
        public String[] deployStrings() {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (null != this.structure()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("CREATE TYPE ").append(this.qname).append(" AS (");
                int n = this.structure().length;
                for (String string : this.structure()) {
                    stringBuilder.append("\n\t").append(string).append(0 < --n ? (char)',' : '\n');
                }
                stringBuilder.append(')');
                arrayList.add(stringBuilder.toString());
            }
            arrayList.add("SELECT sqlj.add_type_mapping(" + DDRWriter.eQuote(this.qname) + ", " + DDRWriter.eQuote(this.tclass.toString()) + ')');
            this.addComment(arrayList);
            return arrayList.toArray(new String[arrayList.size()]);
        }

        @Override
        public String[] undeployStrings() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("SELECT sqlj.drop_type_mapping(" + DDRWriter.eQuote(this.qname) + ')');
            if (null != this.structure()) {
                arrayList.add("DROP TYPE " + this.qname);
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
    }

    abstract class AbstractUDTImpl
    extends AbstractAnnotationImpl
    implements Snippet,
    Commentable {
        public String[] _provides;
        public String[] _requires;
        public String _name;
        public String _schema;
        TypeElement tclass;
        String qname;

        public String name() {
            return this._name;
        }

        public String schema() {
            return this._schema;
        }

        @Override
        public String[] provides() {
            return this._provides;
        }

        @Override
        public String[] requires() {
            return this._requires;
        }

        AbstractUDTImpl(TypeElement typeElement) {
            ExecutableElement executableElement;
            this.tclass = typeElement;
            if (!DDRProcessorImpl.this.typu.isAssignable(typeElement.asType(), DDRProcessorImpl.this.TY_SQLDATA)) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)typeElement, "A pljava UDT must implement %s", DDRProcessorImpl.this.TY_SQLDATA);
            }
            if (null == (executableElement = DDRProcessorImpl.this.huntFor(ElementFilter.constructorsIn(this.tclass.getEnclosedElements()), null, false, null, new TypeMirror[0]))) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.tclass, "A pljava UDT must have a public no-arg constructor", new Object[0]);
            }
        }

        protected void setQname() {
            if ("".equals(this._name)) {
                this._name = this.tclass.getSimpleName().toString();
            }
            this.qname = "".equals(this._schema) ? this._name : this._schema + "." + this._name;
        }

        protected void addComment(ArrayList<String> arrayList) {
            String string = this.comment();
            if (null == string) {
                return;
            }
            arrayList.add("COMMENT ON TYPE " + this.qname + "\nIS " + DDRWriter.eQuote(string));
        }
    }

    class BaseUDTFunctionImpl
    extends FunctionImpl {
        BaseUDTImpl ui;
        TypeElement te;
        BaseUDTFunctionID id;

        BaseUDTFunctionImpl(BaseUDTImpl baseUDTImpl, TypeElement typeElement, BaseUDTFunctionID baseUDTFunctionID) {
            super(null);
            this.ui = baseUDTImpl;
            this.te = typeElement;
            this.id = baseUDTFunctionID;
            this._type = baseUDTFunctionID.getRet(baseUDTImpl);
            this._name = baseUDTImpl.name() + '_' + baseUDTFunctionID.getSuffix();
            this._schema = baseUDTImpl.schema();
            this._cost = -1;
            this._rows = -1;
            this._onNullInput = Function.OnNullInput.CALLED;
            this._security = Function.Security.INVOKER;
            this._effects = Function.Effects.VOLATILE;
            this._trust = Function.Trust.SANDBOXED;
            this._leakproof = false;
            this._settings = new String[0];
            this._triggers = new Trigger[0];
            this._provides = this._settings;
            this._requires = this._settings;
        }

        @Override
        void appendParams(StringBuilder stringBuilder, boolean bl) {
            stringBuilder.append(this.id.getParam(this.ui));
        }

        @Override
        void appendAS(StringBuilder stringBuilder) {
            stringBuilder.append("UDT[").append(this.te.toString()).append("] ");
            stringBuilder.append(this.id.name());
        }

        StringBuilder appendTypeOp(StringBuilder stringBuilder) {
            stringBuilder.append(this.id.name()).append(" = ");
            if (!"".equals(this.schema())) {
                stringBuilder.append(this.schema()).append('.');
            }
            return stringBuilder.append(this.name());
        }

        @Override
        public boolean characterize() {
            return false;
        }

        public void setType(Object object, boolean bl, Element element) {
            if (bl) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, element, "The type of a UDT function may not be changed", new Object[0]);
            }
        }

        @Override
        public void setRows(Object object, boolean bl, Element element) {
            if (bl) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, element, "The rows attribute of a UDT function may not be set", new Object[0]);
            }
        }

        public void setProvides(Object object, boolean bl, Element element) {
            if (bl) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, element, "A UDT function does not have its own provides/requires", new Object[0]);
            }
        }

        public void setRequires(Object object, boolean bl, Element element) {
            if (bl) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, element, "A UDT function does not have its own provides/requires", new Object[0]);
            }
        }

        @Override
        public void setTriggers(Object object, boolean bl, Element element) {
            if (bl) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, element, "A UDT function may not have associated triggers", new Object[0]);
            }
        }

        @Override
        public void setImplementor(Object object, boolean bl, Element element) {
            if (bl) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, element, "A UDT function does not have its own implementor", new Object[0]);
            }
        }

        @Override
        public String implementor() {
            return this.ui.implementor();
        }

        @Override
        public String derivedComment(Element element) {
            String string = super.derivedComment(element);
            if (null != string) {
                return string;
            }
            return this.id.name() + " method for type " + this.ui.qname;
        }
    }

    static enum BaseUDTFunctionID {
        INPUT("in", "cstring, oid, integer", null),
        OUTPUT("out", null, "cstring"),
        RECEIVE("recv", "internal, oid, integer", null),
        SEND("send", null, "bytea");

        private String suffix;
        private String param;
        private String ret;

        private BaseUDTFunctionID(String string2, String string3, String string4) {
            this.suffix = string2;
            this.param = string3;
            this.ret = string4;
        }

        String getSuffix() {
            return this.suffix;
        }

        String getParam(BaseUDTImpl baseUDTImpl) {
            if (null != this.param) {
                return this.param;
            }
            return baseUDTImpl.qname;
        }

        String getRet(BaseUDTImpl baseUDTImpl) {
            if (null != this.ret) {
                return this.ret;
            }
            return baseUDTImpl.qname;
        }
    }

    class FunctionImpl
    extends AbstractAnnotationImpl
    implements Function,
    Snippet,
    Commentable {
        ExecutableElement func;
        public String _type;
        public String _name;
        public String _schema;
        public Function.OnNullInput _onNullInput;
        public Function.Security _security;
        public Function.Effects _effects;
        public Function.Trust _trust;
        public Boolean _leakproof;
        int _cost;
        int _rows;
        public String[] _settings;
        public String[] _provides;
        public String[] _requires;
        Trigger[] _triggers;
        boolean complexViaInOut;
        boolean setof;
        TypeMirror setofComponent;
        boolean trigger;

        @Override
        public String type() {
            return this._type;
        }

        @Override
        public String name() {
            return this._name;
        }

        @Override
        public String schema() {
            return this._schema;
        }

        @Override
        public Function.OnNullInput onNullInput() {
            return this._onNullInput;
        }

        @Override
        public Function.Security security() {
            return this._security;
        }

        @Override
        public Function.Effects effects() {
            return this._effects;
        }

        @Override
        public Function.Trust trust() {
            return this._trust;
        }

        @Override
        public boolean leakproof() {
            return this._leakproof;
        }

        @Override
        public int cost() {
            return this._cost;
        }

        @Override
        public int rows() {
            return this._rows;
        }

        @Override
        public String[] settings() {
            return this._settings;
        }

        @Override
        public String[] provides() {
            return this._provides;
        }

        @Override
        public String[] requires() {
            return this._requires;
        }

        @Override
        public Trigger[] triggers() {
            return this._triggers;
        }

        FunctionImpl(ExecutableElement executableElement) {
            this.complexViaInOut = false;
            this.setof = false;
            this.setofComponent = null;
            this.trigger = false;
            this.func = executableElement;
        }

        public void setCost(Object object, boolean bl, Element element) {
            this._cost = (Integer)object;
            if (this._cost < 0 && bl) {
                throw new IllegalArgumentException("cost must be nonnegative");
            }
        }

        public void setRows(Object object, boolean bl, Element element) {
            this._rows = (Integer)object;
            if (this._rows < 0 && bl) {
                throw new IllegalArgumentException("rows must be nonnegative");
            }
        }

        public void setTriggers(Object object, boolean bl, Element element) {
            AnnotationMirror[] annotationMirrorArray = DDRProcessorImpl.avToArray(object, AnnotationMirror.class);
            this._triggers = new Trigger[annotationMirrorArray.length];
            int n = 0;
            for (AnnotationMirror annotationMirror : annotationMirrorArray) {
                TriggerImpl triggerImpl = new TriggerImpl(this, annotationMirror);
                DDRProcessorImpl.this.populateAnnotationImpl(triggerImpl, element, annotationMirror);
                this._triggers[n++] = triggerImpl;
            }
        }

        @Override
        public boolean characterize() {
            TypeMirror typeMirror;
            TypeMirror typeMirror2;
            Set<Modifier> set;
            if ("".equals(this._name)) {
                this._name = this.func.getSimpleName().toString();
            }
            if (!(set = this.func.getModifiers()).contains((Object)Modifier.STATIC)) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.func, "A pljava function must be static", new Object[0]);
            }
            if ((typeMirror2 = this.func.getReturnType()).getKind().equals((Object)TypeKind.ERROR)) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.func, "Unable to resolve return type of function", new Object[0]);
                return false;
            }
            ExecutableType executableType = (ExecutableType)this.func.asType();
            List<? extends TypeMirror> list = executableType.getParameterTypes();
            int n = list.size();
            if (!"".equals(this.type()) && typeMirror2.getKind().equals((Object)TypeKind.BOOLEAN)) {
                this.complexViaInOut = true;
                TypeMirror object = list.get(n - 1);
                if (object.getKind().equals((Object)TypeKind.ERROR) || !DDRProcessorImpl.this.typu.isSameType(object, DDRProcessorImpl.this.TY_RESULTSET)) {
                    DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.func.getParameters().get(n - 1), "Last parameter of complex-type-returning function must be ResultSet", new Object[0]);
                    return false;
                }
            } else if (DDRProcessorImpl.this.typu.isAssignable(DDRProcessorImpl.this.typu.erasure(typeMirror2), DDRProcessorImpl.this.TY_ITERATOR)) {
                this.setof = true;
                LinkedList<? extends TypeMirror> linkedList = new LinkedList<TypeMirror>();
                linkedList.add(typeMirror2);
                while (!linkedList.isEmpty()) {
                    TypeMirror typeMirror3 = (TypeMirror)linkedList.remove(0);
                    if (DDRProcessorImpl.this.typu.isSameType(DDRProcessorImpl.this.typu.erasure(typeMirror3), DDRProcessorImpl.this.TY_ITERATOR)) {
                        DeclaredType declaredType = (DeclaredType)typeMirror3;
                        List<? extends TypeMirror> list2 = declaredType.getTypeArguments();
                        if (1 != list2.size()) {
                            DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.func, "Need one type argument for Iterator return type", new Object[0]);
                            return false;
                        }
                        this.setofComponent = list2.get(0);
                        break;
                    }
                    linkedList.addAll(DDRProcessorImpl.this.typu.directSupertypes(typeMirror3));
                }
                if (null == this.setofComponent) {
                    DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.func, "Failed to find setof component type", new Object[0]);
                    return false;
                }
            } else if (DDRProcessorImpl.this.typu.isAssignable(typeMirror2, DDRProcessorImpl.this.TY_RESULTSETPROVIDER) || DDRProcessorImpl.this.typu.isAssignable(typeMirror2, DDRProcessorImpl.this.TY_RESULTSETHANDLE)) {
                this.setof = true;
            } else if (typeMirror2.getKind().equals((Object)TypeKind.VOID) && 1 == n && !(typeMirror = list.get(0)).getKind().equals((Object)TypeKind.ERROR) && DDRProcessorImpl.this.typu.isSameType(typeMirror, DDRProcessorImpl.this.TY_TRIGGERDATA)) {
                this.trigger = true;
            }
            if (!this.setof && -1 != this.rows()) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.func, "ROWS specified on a function not returning SETOF", new Object[0]);
            }
            if (!this.trigger && 0 != this._triggers.length) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.func, "a function with triggers needs void return and one TriggerData parameter", new Object[0]);
            }
            this.deployStrings();
            this._requires = this.augmentRequires(this._requires, this.implementor());
            for (Trigger trigger : this.triggers()) {
                ((TriggerImpl)trigger).characterize();
            }
            return true;
        }

        void appendNameAndParams(StringBuilder stringBuilder, boolean bl) {
            if (!"".equals(this.schema())) {
                stringBuilder.append(this.schema()).append('.');
            }
            stringBuilder.append(this.name()).append('(');
            this.appendParams(stringBuilder, bl);
            stringBuilder.append(')');
        }

        void appendParams(StringBuilder stringBuilder, boolean bl) {
            if (!this.trigger) {
                ExecutableType executableType = (ExecutableType)this.func.asType();
                List<? extends TypeMirror> list = executableType.getParameterTypes();
                Iterator<? extends VariableElement> iterator = this.func.getParameters().iterator();
                if (this.complexViaInOut) {
                    list = list.subList(0, list.size() - 1);
                }
                int n = list.size();
                for (TypeMirror typeMirror : list) {
                    VariableElement variableElement = iterator.next();
                    stringBuilder.append("\n\t").append(variableElement.getSimpleName().toString());
                    stringBuilder.append(' ');
                    stringBuilder.append(DDRProcessorImpl.this.tmpr.getSQLType(typeMirror, variableElement, true, bl));
                    if (0 >= --n) continue;
                    stringBuilder.append(',');
                }
            }
        }

        void appendAS(StringBuilder stringBuilder) {
            Element element = this.func.getEnclosingElement();
            if (!element.getKind().equals((Object)ElementKind.CLASS)) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.func, "Somehow this method got enclosed by something other than a class", new Object[0]);
            }
            stringBuilder.append(element.toString()).append('.');
            stringBuilder.append(this.trigger ? this.func.getSimpleName() : this.func.toString());
        }

        @Override
        public String[] deployStrings() {
            ArrayList<String> arrayList = new ArrayList<String>();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CREATE OR REPLACE FUNCTION ");
            this.appendNameAndParams(stringBuilder, true);
            stringBuilder.append("\n\tRETURNS ");
            if (this.trigger) {
                stringBuilder.append("trigger");
            } else {
                if (this.setof) {
                    stringBuilder.append("SETOF ");
                }
                if (!"".equals(this.type())) {
                    stringBuilder.append(this.type());
                } else if (null != this.setofComponent) {
                    stringBuilder.append(DDRProcessorImpl.this.tmpr.getSQLType(this.setofComponent, this.func));
                } else if (this.setof) {
                    stringBuilder.append("RECORD");
                } else {
                    stringBuilder.append(DDRProcessorImpl.this.tmpr.getSQLType(this.func.getReturnType(), this.func));
                }
            }
            stringBuilder.append("\n\tLANGUAGE ");
            if (Function.Trust.SANDBOXED.equals((Object)this.trust())) {
                stringBuilder.append(DDRProcessorImpl.this.nameTrusted);
            } else {
                stringBuilder.append(DDRProcessorImpl.this.nameUntrusted);
            }
            stringBuilder.append(' ').append((Object)this.effects());
            if (this.leakproof()) {
                stringBuilder.append(" LEAKPROOF");
            }
            stringBuilder.append('\n');
            if (Function.OnNullInput.RETURNS_NULL.equals((Object)this.onNullInput())) {
                stringBuilder.append("\tRETURNS NULL ON NULL INPUT\n");
            }
            if (Function.Security.DEFINER.equals((Object)this.security())) {
                stringBuilder.append("\tSECURITY DEFINER\n");
            }
            if (-1 != this.cost()) {
                stringBuilder.append("\tCOST ").append(this.cost()).append('\n');
            }
            if (-1 != this.rows()) {
                stringBuilder.append("\tROWS ").append(this.rows()).append('\n');
            }
            for (String string : this.settings()) {
                stringBuilder.append("\tSET ").append(string).append('\n');
            }
            stringBuilder.append("\tAS '");
            this.appendAS(stringBuilder);
            stringBuilder.append('\'');
            arrayList.add(stringBuilder.toString());
            String string = this.comment();
            if (null != string) {
                stringBuilder.setLength(0);
                stringBuilder.append("COMMENT ON FUNCTION ");
                this.appendNameAndParams(stringBuilder, false);
                stringBuilder.append("\nIS ");
                stringBuilder.append(DDRWriter.eQuote(string));
                arrayList.add(stringBuilder.toString());
            }
            for (Trigger trigger : this.triggers()) {
                for (String string2 : ((TriggerImpl)trigger).deployStrings()) {
                    arrayList.add(string2);
                }
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }

        @Override
        public String[] undeployStrings() {
            String[] stringArray = new String[1 + this.triggers().length];
            int n = stringArray.length - 1;
            for (Trigger trigger : this.triggers()) {
                for (String string : ((TriggerImpl)trigger).undeployStrings()) {
                    stringArray[--n] = string;
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("DROP FUNCTION ");
            this.appendNameAndParams(stringBuilder, false);
            stringArray[stringArray.length - 1] = stringBuilder.toString();
            return stringArray;
        }
    }

    class TriggerImpl
    extends AbstractAnnotationImpl
    implements Trigger,
    Snippet,
    Commentable {
        public String[] _arguments;
        public Trigger.Event[] _events;
        public String _name;
        public String _schema;
        public String _table;
        public Trigger.Scope _scope;
        public Trigger.Called _called;
        public String _when;
        public String[] _columns;
        FunctionImpl func;
        AnnotationMirror origin;

        @Override
        public String[] arguments() {
            return this._arguments;
        }

        @Override
        public Trigger.Event[] events() {
            return this._events;
        }

        @Override
        public String name() {
            return this._name;
        }

        @Override
        public String schema() {
            return this._schema;
        }

        @Override
        public String table() {
            return this._table;
        }

        @Override
        public Trigger.Scope scope() {
            return this._scope;
        }

        @Override
        public Trigger.Called called() {
            return this._called;
        }

        @Override
        public String when() {
            return this._when;
        }

        @Override
        public String[] columns() {
            return this._columns;
        }

        @Override
        public String[] provides() {
            return new String[0];
        }

        @Override
        public String[] requires() {
            return new String[0];
        }

        TriggerImpl(FunctionImpl functionImpl, AnnotationMirror annotationMirror) {
            this.func = functionImpl;
            this.origin = annotationMirror;
        }

        @Override
        public boolean characterize() {
            if (Trigger.Scope.ROW.equals((Object)this._scope)) {
                for (Trigger.Event event : this._events) {
                    if (!Trigger.Event.TRUNCATE.equals((Object)event)) continue;
                    DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.func.func, this.origin, "TRUNCATE trigger cannot be FOR EACH ROW", new Object[0]);
                }
            } else if (Trigger.Called.INSTEAD_OF.equals((Object)this._called)) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.func.func, this.origin, "INSTEAD OF trigger cannot be FOR EACH STATEMENT", new Object[0]);
            }
            if (!"".equals(this._when) && Trigger.Called.INSTEAD_OF.equals((Object)this._called)) {
                DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.func.func, this.origin, "INSTEAD OF triggers do not support WHEN conditions", new Object[0]);
            }
            if (0 < this._columns.length) {
                if (Trigger.Called.INSTEAD_OF.equals((Object)this._called)) {
                    DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.func.func, this.origin, "INSTEAD OF triggers do not support lists of columns", new Object[0]);
                }
                boolean bl = false;
                for (Trigger.Event event : this._events) {
                    if (!Trigger.Event.UPDATE.equals((Object)event)) continue;
                    bl = true;
                }
                if (!bl) {
                    DDRProcessorImpl.this.msg(Diagnostic.Kind.ERROR, (Element)this.func.func, this.origin, "Column list is meaningless unless UPDATE is a trigger event", new Object[0]);
                }
            }
            if ("".equals(this._name)) {
                this._name = TriggerNamer.synthesizeName(this);
            }
            return false;
        }

        @Override
        public String[] deployStrings() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CREATE TRIGGER ").append(this.name()).append("\n\t");
            switch (this.called()) {
                case BEFORE: {
                    stringBuilder.append("BEFORE ");
                    break;
                }
                case AFTER: {
                    stringBuilder.append("AFTER ");
                    break;
                }
                case INSTEAD_OF: {
                    stringBuilder.append("INSTEAD OF ");
                }
            }
            int n = this._events.length;
            for (Trigger.Event event : this._events) {
                stringBuilder.append(event.toString());
                if (Trigger.Event.UPDATE.equals((Object)event) && 0 < this._columns.length) {
                    stringBuilder.append(" OF ");
                    int n2 = this._columns.length;
                    for (String string : this._columns) {
                        stringBuilder.append(string);
                        if (0 >= --n2) continue;
                        stringBuilder.append(", ");
                    }
                }
                if (0 >= --n) continue;
                stringBuilder.append(" OR ");
            }
            stringBuilder.append("\n\tON ");
            if (!"".equals(this.schema())) {
                stringBuilder.append(this.schema()).append('.');
            }
            stringBuilder.append(this.table()).append("\n\tFOR EACH ");
            stringBuilder.append(this.scope().toString());
            if (!"".equals(this._when)) {
                stringBuilder.append("\n\tWHEN ").append(this._when);
            }
            stringBuilder.append("\n\tEXECUTE PROCEDURE ");
            this.func.appendNameAndParams(stringBuilder, false);
            stringBuilder.setLength(stringBuilder.length() - 1);
            n = this._arguments.length;
            for (String string : this._arguments) {
                stringBuilder.append("\n\t").append(DDRWriter.eQuote(string));
                if (0 >= --n) continue;
                stringBuilder.append(',');
            }
            stringBuilder.append(')');
            String string = this.comment();
            if (null == string) {
                return new String[]{stringBuilder.toString()};
            }
            return new String[]{stringBuilder.toString(), "COMMENT ON TRIGGER " + this.name() + " ON " + ("".equals(this.schema()) ? "" : this.schema() + '.') + this.table() + "\nIS " + DDRWriter.eQuote(string)};
        }

        @Override
        public String[] undeployStrings() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("DROP TRIGGER ").append(this.name()).append("\n\tON ");
            if (!"".equals(this.schema())) {
                stringBuilder.append(this.schema()).append('.');
            }
            stringBuilder.append(this.table());
            return new String[]{stringBuilder.toString()};
        }
    }

    class SQLActionImpl
    extends AbstractAnnotationImpl
    implements SQLAction,
    Snippet {
        public String[] _install;
        public String[] _remove;
        public String[] _provides;
        public String[] _requires;

        SQLActionImpl() {
        }

        @Override
        public String[] install() {
            return this._install;
        }

        @Override
        public String[] remove() {
            return this._remove;
        }

        @Override
        public String[] provides() {
            return this._provides;
        }

        @Override
        public String[] requires() {
            return this._requires;
        }

        @Override
        public String[] deployStrings() {
            return this._install;
        }

        @Override
        public String[] undeployStrings() {
            return this._remove;
        }

        @Override
        public boolean characterize() {
            this._requires = this.augmentRequires(this._requires, this.implementor());
            return true;
        }
    }

    class SQLActionsImpl
    extends AbstractAnnotationImpl
    implements SQLActions {
        SQLAction[] _value;

        SQLActionsImpl() {
        }

        @Override
        public SQLAction[] value() {
            return this._value;
        }

        public void setValue(Object object, boolean bl, Element element) {
            AnnotationMirror[] annotationMirrorArray = DDRProcessorImpl.avToArray(object, AnnotationMirror.class);
            this._value = new SQLAction[annotationMirrorArray.length];
            int n = 0;
            for (AnnotationMirror annotationMirror : annotationMirrorArray) {
                SQLActionImpl sQLActionImpl = new SQLActionImpl();
                DDRProcessorImpl.this.populateAnnotationImpl(sQLActionImpl, element, annotationMirror);
                this._value[n++] = sQLActionImpl;
            }
        }
    }

    class SQLTypeImpl
    extends AbstractAnnotationImpl
    implements SQLType {
        String _value;
        String[] _defaultValue;

        SQLTypeImpl() {
        }

        @Override
        public String value() {
            return this._value;
        }

        @Override
        public String[] defaultValue() {
            return this._defaultValue;
        }

        public void setValue(Object object, boolean bl, Element element) {
            if (bl) {
                this._value = (String)object;
            }
        }

        public void setDefaultValue(Object object, boolean bl, Element element) {
            if (bl) {
                this._defaultValue = DDRProcessorImpl.avToArray(object, String.class);
            }
        }
    }

    class AbstractAnnotationImpl
    implements Annotation {
        String _implementor;
        String _comment;

        AbstractAnnotationImpl() {
            this._implementor = DDRProcessorImpl.this.defaultImplementor;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            throw new UnsupportedOperationException();
        }

        public String implementor() {
            return this._implementor;
        }

        public void setImplementor(Object object, boolean bl, Element element) {
            if (bl) {
                this._implementor = "".equals(object) ? null : (String)object;
            }
        }

        protected String[] augmentRequires(String[] stringArray, String string) {
            if (null == string) {
                return stringArray;
            }
            String[] stringArray2 = new String[1 + stringArray.length];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = string;
            return stringArray2;
        }

        public String comment() {
            return this._comment;
        }

        public void setComment(Object object, boolean bl, Element element) {
            if (bl) {
                this._comment = (String)object;
                if ("".equals(this._comment)) {
                    this._comment = null;
                }
            } else {
                this._comment = ((Commentable)((Object)this)).derivedComment(element);
            }
        }

        public String derivedComment(Element element) {
            String string = DDRProcessorImpl.this.elmu.getDocComment(element);
            if (null == string) {
                return null;
            }
            return this.firstSentence(string);
        }

        public String firstSentence(String string) {
            BreakIterator breakIterator = BreakIterator.getSentenceInstance(DDRProcessorImpl.this.loca);
            breakIterator.setText(string);
            int n = breakIterator.first();
            int n2 = breakIterator.next();
            if (-1 == n2) {
                return null;
            }
            return string.substring(n, n2).trim();
        }
    }

    static enum UDTKind {
        BASE,
        MAPPED;

    }

    static final class SnippetsKey {
        final Object o;
        final Class<? extends Snippet> c;

        SnippetsKey(Object object, Class<? extends Snippet> clazz) {
            assert (Snippet.class != clazz) : "Snippet key must be a subtype";
            this.o = object;
            this.c = clazz;
        }

        public boolean equals(Object object) {
            if (!(object instanceof SnippetsKey)) {
                return false;
            }
            SnippetsKey snippetsKey = (SnippetsKey)object;
            return this.o.equals(snippetsKey.o) && (this.c.isAssignableFrom(snippetsKey.c) || snippetsKey.c.isAssignableFrom(this.c));
        }

        public int hashCode() {
            return this.o.hashCode();
        }
    }
}

