/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLOutput;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import org.postgresql.pljava.internal.Tuple;
import org.postgresql.pljava.internal.TupleDesc;
import org.postgresql.pljava.jdbc.BlobValue;
import org.postgresql.pljava.jdbc.ClobValue;

public class SQLOutputToTuple
implements SQLOutput {
    private final Object[] m_values;
    private final TupleDesc m_tupleDesc;
    private int m_index;
    private Tuple m_tuple;

    public SQLOutputToTuple(TupleDesc tupleDesc) {
        this.m_tupleDesc = tupleDesc;
        this.m_values = new Object[tupleDesc.size()];
        this.m_index = 0;
    }

    public long getTuple() throws SQLException {
        if (this.m_tuple != null) {
            return this.m_tuple.getNativePointer();
        }
        if (this.m_index < this.m_values.length) {
            throw new SQLException("Too few values have been written");
        }
        this.m_tuple = this.m_tupleDesc.formTuple(this.m_values);
        return this.m_tuple.getNativePointer();
    }

    @Override
    public void writeArray(Array array) throws SQLException {
        this.writeValue(array);
    }

    @Override
    public void writeAsciiStream(InputStream inputStream) throws SQLException {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "US-ASCII"));
            this.writeClob(new ClobValue(bufferedReader, ClobValue.getReaderLength(bufferedReader)));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException(unsupportedEncodingException.toString());
        }
    }

    @Override
    public void writeBigDecimal(BigDecimal bigDecimal) throws SQLException {
        this.writeValue(bigDecimal);
    }

    @Override
    public void writeBinaryStream(InputStream inputStream) throws SQLException {
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        this.writeBlob(new BlobValue(inputStream, BlobValue.getStreamLength(inputStream)));
    }

    @Override
    public void writeBlob(Blob blob) throws SQLException {
        this.writeValue(blob);
    }

    @Override
    public void writeBoolean(boolean bl) throws SQLException {
        this.writeValue(bl ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void writeByte(byte by) throws SQLException {
        this.writeValue(new Byte(by));
    }

    @Override
    public void writeBytes(byte[] byArray) throws SQLException {
        this.writeValue(byArray);
    }

    @Override
    public void writeCharacterStream(Reader reader) throws SQLException {
        if (!reader.markSupported()) {
            reader = new BufferedReader(reader);
        }
        this.writeClob(new ClobValue(reader, ClobValue.getReaderLength(reader)));
    }

    @Override
    public void writeClob(Clob clob) throws SQLException {
        this.writeValue(clob);
    }

    @Override
    public void writeDate(Date date) throws SQLException {
        this.writeValue(date);
    }

    @Override
    public void writeDouble(double d) throws SQLException {
        this.writeValue(new Double(d));
    }

    @Override
    public void writeFloat(float f) throws SQLException {
        this.writeValue(new Float(f));
    }

    @Override
    public void writeInt(int n) throws SQLException {
        this.writeValue(new Integer(n));
    }

    @Override
    public void writeLong(long l) throws SQLException {
        this.writeValue(new Long(l));
    }

    @Override
    public void writeObject(SQLData sQLData) throws SQLException {
        this.writeValue(sQLData);
    }

    @Override
    public void writeRef(Ref ref) throws SQLException {
        this.writeValue(ref);
    }

    @Override
    public void writeShort(short s) throws SQLException {
        this.writeValue(new Short(s));
    }

    @Override
    public void writeString(String string) throws SQLException {
        this.writeValue(string);
    }

    @Override
    public void writeStruct(Struct struct) throws SQLException {
        this.writeValue(struct);
    }

    @Override
    public void writeTime(Time time) throws SQLException {
        this.writeValue(time);
    }

    @Override
    public void writeTimestamp(Timestamp timestamp) throws SQLException {
        this.writeValue(timestamp);
    }

    @Override
    public void writeURL(URL uRL) throws SQLException {
        this.writeValue(uRL.toString());
    }

    @Override
    public void writeNClob(NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".writeNClob( NClob ) not implemented yet.", "0A000");
    }

    @Override
    public void writeNString(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".writeNString( String ) not implemented yet.", "0A000");
    }

    @Override
    public void writeRowId(RowId rowId) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".writeRowId( RowId ) not implemented yet.", "0A000");
    }

    @Override
    public void writeSQLXML(SQLXML sQLXML) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".writeSQLXML( SQLXML ) not implemented yet.", "0A000");
    }

    private void writeValue(Object object) throws SQLException {
        if (this.m_index >= this.m_values.length) {
            throw new SQLException("Tuple cannot take more values");
        }
        this.m_values[this.m_index++] = object;
    }
}

