/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientException;
import java.sql.SQLOutput;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import org.postgresql.pljava.internal.Backend;

public class SQLOutputToChunk
implements SQLOutput {
    private static final byte[] s_byteBuffer = new byte[8];
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private long m_handle;
    private ByteBuffer m_bb;
    private static ByteOrder scalarOrder;
    private static ByteOrder mirrorOrder;

    public SQLOutputToChunk(long l, ByteBuffer byteBuffer, boolean bl) throws SQLException {
        this.m_handle = l;
        this.m_bb = byteBuffer;
        if (bl) {
            if (null == scalarOrder) {
                scalarOrder = this.getOrder(true);
            }
            this.m_bb.order(scalarOrder);
        } else {
            if (null == mirrorOrder) {
                mirrorOrder = this.getOrder(false);
            }
            this.m_bb.order(mirrorOrder);
        }
    }

    private ByteOrder getOrder(boolean bl) throws SQLException {
        ByteOrder byteOrder;
        String string = "org.postgresql.pljava.udt.byteorder." + (bl ? "scalar" : "mirror") + ".j2p";
        String string2 = System.getProperty(string);
        if ("big_endian".equals(string2)) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        } else if ("little_endian".equals(string2)) {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else if ("native".equals(string2)) {
            byteOrder = ByteOrder.nativeOrder();
        } else {
            throw new SQLNonTransientException("System property " + string + " must be big_endian, little_endian, or native", "F0000");
        }
        return byteOrder;
    }

    @Override
    public void writeArray(Array array) throws SQLException {
        throw this.unsupportedOperationException("writeArray");
    }

    @Override
    public void writeAsciiStream(InputStream inputStream) throws SQLException {
        throw this.unsupportedOperationException("writeAsciiStream");
    }

    @Override
    public void writeBigDecimal(BigDecimal bigDecimal) throws SQLException {
        this.writeString(bigDecimal.toString());
    }

    @Override
    public void writeBinaryStream(InputStream inputStream) throws SQLException {
        int n;
        byte[] byArray = new byte[65536];
        try {
            n = inputStream.read(byArray);
        }
        catch (IOException iOException) {
            throw new SQLException("Error making binary form of user-defined type from input stream", "58030", iOException);
        }
        if (-1 == n) {
            n = 0;
        }
        if (65535 < n) {
            throw this.badRepresentation("writeBinaryStream");
        }
        this.ensureCapacity(2 + n);
        this.m_bb.putShort((short)n).put(byArray, 0, n);
    }

    @Override
    public void writeBlob(Blob blob) throws SQLException {
        throw this.unsupportedOperationException("writeBlob");
    }

    @Override
    public void writeBoolean(boolean bl) throws SQLException {
        this.writeByte(bl ? (byte)1 : 0);
    }

    @Override
    public void writeByte(byte by) throws SQLException {
        try {
            this.m_bb.put(by);
        }
        catch (Exception exception) {
            this.throwOrRetry(exception, 1, "writeByte");
            this.m_bb.put(by);
        }
    }

    @Override
    public void writeBytes(byte[] byArray) throws SQLException {
        if (65535 < byArray.length) {
            throw this.badRepresentation("writeBytes");
        }
        this.ensureCapacity(2 + byArray.length);
        this.m_bb.putShort((short)byArray.length).put(byArray);
    }

    @Override
    public void writeCharacterStream(Reader reader) throws SQLException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(65535);
        CharBuffer charBuffer = CharBuffer.allocate(1024);
        CharsetEncoder charsetEncoder = UTF8.newEncoder();
        try {
            CoderResult coderResult;
            while (-1 != reader.read(charBuffer)) {
                charBuffer.flip();
                coderResult = charsetEncoder.encode(charBuffer, byteBuffer, false);
                if (!coderResult.isUnderflow()) {
                    coderResult.throwException();
                }
                charBuffer.clear();
            }
            charBuffer.flip();
            coderResult = charsetEncoder.encode(charBuffer, byteBuffer, true);
            if (coderResult.isUnderflow()) {
                coderResult = charsetEncoder.flush(byteBuffer);
            }
            if (!coderResult.isUnderflow()) {
                coderResult.throwException();
            }
            byteBuffer.flip();
            this.ensureCapacity(2 + byteBuffer.limit());
            this.m_bb.putShort((short)byteBuffer.limit()).put(byteBuffer);
        }
        catch (Exception exception) {
            throw this.badRepresentation(exception);
        }
    }

    @Override
    public void writeClob(Clob clob) throws SQLException {
        throw this.unsupportedOperationException("writeClob");
    }

    @Override
    public void writeDate(Date date) throws SQLException {
        long l = date.getTime();
        try {
            this.m_bb.putLong(l);
        }
        catch (Exception exception) {
            this.throwOrRetry(exception, 8, "writeDate");
            this.m_bb.putLong(l);
        }
    }

    @Override
    public void writeDouble(double d) throws SQLException {
        try {
            this.m_bb.putDouble(d);
        }
        catch (Exception exception) {
            this.throwOrRetry(exception, 8, "writeDouble");
            this.m_bb.putDouble(d);
        }
    }

    @Override
    public void writeFloat(float f) throws SQLException {
        try {
            this.m_bb.putFloat(f);
        }
        catch (Exception exception) {
            this.throwOrRetry(exception, 4, "writeFloat");
            this.m_bb.putFloat(f);
        }
    }

    @Override
    public void writeInt(int n) throws SQLException {
        try {
            this.m_bb.putInt(n);
        }
        catch (Exception exception) {
            this.throwOrRetry(exception, 4, "writeInt");
            this.m_bb.putInt(n);
        }
    }

    @Override
    public void writeLong(long l) throws SQLException {
        try {
            this.m_bb.putLong(l);
        }
        catch (Exception exception) {
            this.throwOrRetry(exception, 8, "writeLong");
            this.m_bb.putLong(l);
        }
    }

    @Override
    public void writeObject(SQLData sQLData) throws SQLException {
        throw this.unsupportedOperationException("writeObject");
    }

    @Override
    public void writeRef(Ref ref) throws SQLException {
        throw this.unsupportedOperationException("writeRef");
    }

    @Override
    public void writeShort(short s) throws SQLException {
        try {
            this.m_bb.putShort(s);
        }
        catch (Exception exception) {
            this.throwOrRetry(exception, 2, "writeShort");
            this.m_bb.putShort(s);
        }
    }

    @Override
    public void writeString(String string) throws SQLException {
        CharBuffer charBuffer = CharBuffer.wrap(string);
        try {
            CharsetEncoder charsetEncoder = UTF8.newEncoder();
            ByteBuffer byteBuffer = charsetEncoder.encode(charBuffer);
            int n = byteBuffer.limit();
            if (65535 < n) {
                throw this.badRepresentation("writeString");
            }
            this.ensureCapacity(2 + n);
            this.m_bb.putShort((short)n).put(byteBuffer);
        }
        catch (Exception exception) {
            throw this.badRepresentation(exception);
        }
    }

    @Override
    public void writeStruct(Struct struct) throws SQLException {
        throw this.unsupportedOperationException("writeStruct");
    }

    @Override
    public void writeTime(Time time) throws SQLException {
        long l = time.getTime();
        try {
            this.m_bb.putLong(l);
        }
        catch (Exception exception) {
            this.throwOrRetry(exception, 8, "writeTime");
            this.m_bb.putLong(l);
        }
    }

    @Override
    public void writeTimestamp(Timestamp timestamp) throws SQLException {
        long l = timestamp.getTime();
        try {
            this.m_bb.putLong(l);
        }
        catch (Exception exception) {
            this.throwOrRetry(exception, 8, "writeTimestamp");
            this.m_bb.putLong(l);
        }
    }

    @Override
    public void writeURL(URL uRL) throws SQLException {
        this.writeString(uRL.toString());
    }

    void close() throws SQLException {
        if (0L == this.m_handle) {
            return;
        }
        this.ensureCapacity(0);
        this.m_handle = 0L;
        this.m_bb = null;
    }

    private void throwOrRetry(Exception exception, int n, String string) throws SQLException {
        if (exception instanceof BufferOverflowException) {
            this.ensureCapacity(n);
            return;
        }
        throw this.badRepresentation(exception);
    }

    private SQLException unsupportedOperationException(String string) {
        return new SQLFeatureNotSupportedException(this.getClass() + "." + string + " not implemented yet.", "0A000");
    }

    private SQLException badRepresentation(String string) {
        return new SQLNonTransientException("Limit of 65535 bytes exceeded in " + string + "for user-defined type", "54000");
    }

    private SQLException badRepresentation(Exception exception) {
        if (exception instanceof NullPointerException) {
            return new SQLNonTransientException("attempted write via SQLOutput after closing it", "55000", exception);
        }
        if (exception instanceof BufferOverflowException) {
            return new SQLNonTransientException("Byte limit exceeded for user-defined type", "54000");
        }
        if (exception instanceof UnmappableCharacterException) {
            return new SQLDataException("Character not available in destination encoding", "22P05", exception);
        }
        if (exception instanceof MalformedInputException) {
            return new SQLDataException("Input that does not encode a valid character", "22021", exception);
        }
        return new SQLDataException("Could not form binary representation of user-defined type", "22P03", exception);
    }

    @Override
    public void writeNClob(NClob nClob) throws SQLException {
        throw this.unsupportedOperationException("writeNClob( NClob )");
    }

    @Override
    public void writeNString(String string) throws SQLException {
        throw this.unsupportedOperationException("writeNString( String )");
    }

    @Override
    public void writeRowId(RowId rowId) throws SQLException {
        throw this.unsupportedOperationException("writeRowId( RowId )");
    }

    @Override
    public void writeSQLXML(SQLXML sQLXML) throws SQLException {
        throw this.unsupportedOperationException("writeSQLXML( SQLXML )");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCapacity(int n) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            if (this.m_handle == 0L) {
                throw new SQLException("Stream is closed");
            }
            ByteBuffer byteBuffer = this.m_bb;
            this.m_bb = SQLOutputToChunk._ensureCapacity(this.m_handle, this.m_bb, this.m_bb.position(), n);
            if (this.m_bb != byteBuffer) {
                this.m_bb.order(byteBuffer.order());
            }
        }
    }

    private static native ByteBuffer _ensureCapacity(long var0, ByteBuffer var2, int var3, int var4);
}

