#!/usr/bin/env python3
#-*- coding:utf-8 -*-

try:
    import sys
    import importlib
    importlib.reload(sys)
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
    from gspylib.os.gsOSlib import g_OSlib
except ImportError as ie:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(ie))


class CheckTimeZone(BaseItem):
    def __init__(self):
        super(CheckTimeZone, self).__init__(self.__class__.__name__)

    def doCheck(self):
        output = g_OSlib.getDate()
        timeZone = output.split()[-1]
        self.result.rst = ResultStatus.OK
        self.result.raw = output
        self.result.val = timeZone
