#!/usr/bin/env python3
#-*- coding:utf-8 -*-
try:
    import sys
    import importlib
    importlib.reload(sys)
    import subprocess
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
except ImportError as ie:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(ie))


class CheckProcessLeft(BaseItem):
    def __init__(self):
        super(CheckProcessLeft, self).__init__(self.__class__.__name__)

    def doCheck(self):
        parRes = ""
        flag = 0
        processList = ['gaussdb', 'omm']
        for process in processList:
            cmd = "ps -ef | grep '%s ' -m 20 | grep -v 'grep'" % process
            (_, output) = subprocess.getstatusoutput(cmd)
            if (output.find(process) >= 0):
                parRes += "the process is left over: \n%s" % output
                flag = 1

        if (flag == 1):
            self.result.rst = ResultStatus.NG
        else:
            self.result.rst = ResultStatus.OK
        self.result.val = parRes
        self.result.raw = output

    def doSet(self):
        processList = ['gaussdb', 'omm']
        for process in processList:
            cmd = "ps -eo pid,user,comm | grep -E '\<%s\>' | grep -v 'grep' | awk '{print $1}'|xargs kill -9" % process
            (status, output) = subprocess.getstatusoutput(cmd)
            if (status != 0):
                self.result.val = "Failed to kill process.Error:\n%s\n" % output
            else:
                self.result.val = "Successfully killed the gauss and omm user process.\n"
