#!/usr/bin/env python3
#-*- coding:utf-8 -*-
try:
    import sys
    import importlib
    importlib.reload(sys)
    from gspylib.inspection.common import SharedFuncs
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
except ImportError as e:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(e))


class CheckKernelVer(BaseItem):
    def __init__(self):
        super(CheckKernelVer, self).__init__(self.__class__.__name__)

    def doCheck(self):
        cmd = "uname -r"
        output = SharedFuncs.runShellCmd(cmd)
        if (output != ""):
            self.result.rst = ResultStatus.OK
            self.result.val = output
        else:
            self.result.rst = ResultStatus.NG
            self.result.val = "Failed to get kernel version."
        self.result.raw = cmd
