#!/usr/bin/env python3
# coding: UTF-8
try:
    import subprocess
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
except ImportError as e:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(e))


class CheckDropCache(BaseItem):
    def __init__(self):
        super(CheckDropCache, self).__init__(self.__class__.__name__)

    def doCheck(self):
        checkdropCacheCmd = "ps -ef| grep 'dropc'|grep -v 'grep'"
        (status, output) = subprocess.getstatusoutput(checkdropCacheCmd)
        if(status == 0):
            if(output):
                self.result.rst = ResultStatus.OK
                self.result.val = "The DropCache process is running"
            else:
                self.result.rst = ResultStatus.WARNING
                self.result.val = "No DropCache process is running"
        else:
            self.result.rst = ResultStatus.WARNING
            self.result.val = "No DropCache process is running"
