#!/usr/bin/env python3
# -*- coding:utf-8 -*-
try:
    import time
    from gspylib.inspection.common import SharedFuncs
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
except ImportError as e:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(e))


class CheckIRQ(BaseItem):
    def __init__(self):
        super(CheckIRQ, self).__init__(self.__class__.__name__)

    def doCheck(self):
        cmd = "top -n 1 -bw 100| grep ksoftirqd | grep -v grep"
        output = SharedFuncs.runShellCmd(cmd)
        if (not output):
            self.result.rst = ResultStatus.OK
            return
        topIRQ = float(-1)
        result = ""
        for line in output.splitlines():
            tmpIRQ = float(line.split()[8])
            if (tmpIRQ > topIRQ):
                topIRQ = tmpIRQ
                result = line
        if topIRQ >= 90:
            self.result.rst = ResultStatus.WARNING
            self.result.val = "Soft interrupt CPU usage exception : %s;%s"\
                              % (time.asctime(time.localtime(time.time())), result)
        else:
            self.result.rst = ResultStatus.OK
            self.result.val = "Soft interrupt CPU usage : %s;%s" % (time.asctime(time.localtime(time.time())), result)
