#!/usr/bin/env python3
# -*- coding:utf-8 -*-

try:
    import sys
    import importlib

    importlib.reload(sys)
    import os
    import subprocess
    from gspylib.inspection.common import SharedFuncs
    from gspylib.inspection.common.CheckItem import BaseItem
    from gspylib.inspection.common.CheckResult import ResultStatus
    from gspylib.os.gsfile import g_file
except ImportError as ie:
    raise Exception("[GAUSS-52200] : Unable to import module: %s." % str(ie))

g_needRepair = []
expectedScheduler = "32768"


class CheckIOrequestqueue(BaseItem):
    def __init__(self):
        super(CheckIOrequestqueue, self).__init__(self.__class__.__name__)

    def obtainDataDir(self, nodeInfo):
        dataDirList = []
        for inst in nodeInfo.datanodes:
            dataDirList.append(inst.datadir)
        for inst in nodeInfo.cmservers:
            dataDirList.append(inst.datadir)
        for inst in nodeInfo.coordinators:
            dataDirList.append(inst.datadir)
        for inst in nodeInfo.gtms:
            dataDirList.append(inst.datadir)
        if hasattr(nodeInfo, 'etcds'):
            for inst in nodeInfo.etcds:
                dataDirList.append(inst.datadir)

        dataDirList.append(os.getenv("PGHOST"))
        dataDirList.append(os.getenv("GPHOME"))
        dataDirList.append(os.getenv("GAUSSHOME"))
        dataDirList.append(os.getenv("GAUSSLOG"))
        dataDirList.append("/tmp")
        return dataDirList

    def obtainDisk(self):
        """
        function: get disk name by partition
        input: partition list
        return: disk dict
        """
        cmd = "fdisk -l 2>/dev/null | grep 'Disk /dev/' | grep -v '/dev/mapper/' | awk '{ print $2 }'" \
              "| awk -F'/' '{ print $NF }'| sed s/:$//g"
        output = SharedFuncs.runShellCmd(cmd)
        return output.splitlines()

    def obtainDiskDir(self):
        cmd = "df -h -P /data* | grep -v 'Mounted' | awk '{print $6}'"
        output = SharedFuncs.runShellCmd(cmd)
        if output.lower().find("no such") >= 0:
            allDiskPath = ["/"]
        else:
            allDiskPath = output.split('\n')
        return allDiskPath

    def collectIORequest(self):
        """
        function : Collector ioRequest
        input    : NA
        output   : Dict
        """
        devices = []

        if self.cluster:
            pathList = self.obtainDataDir(self.cluster.getDbNodeByName(self.host))
        else:
            pathList = self.obtainDiskDir()
        diskList = self.obtainDisk()
        for path in pathList:
            cmd = "df -h %s" % path
            output = SharedFuncs.runShellCmd(cmd)
            partitionInfo = output.split('\n')[-1]
            partitionName = partitionInfo.split()[0]
            if partitionName not in devices:
                devices.append(partitionName)
        result = {}
        for d in devices:
            for disk in diskList:
                if d.find(disk) >= 0:
                    request = g_file.readFile("/sys/block/%s/queue/nr_requests" % disk)[0]
                    result[disk] = request.strip()

        return result

    def doCheck(self):
        global g_needRepair
        data = self.collectIORequest()
        flag = True
        resultList = []
        rawStr = ""
        if len(data) == 0:
            resultList.append("Not find IO Request file.")
        for i in data.keys():
            request = data[i]
            rawStr = "%s%s %s\n" % (rawStr, i, request)
            if i.startswith('loop') or i.startswith('ram'):
                continue
            if int(request) != int(expectedScheduler):
                g_needRepair.append(i)
                resultList.append("On device (%s) 'IO Request' RealValue '%s' ExpectedValue '%s'" % (
                    i, request.strip(), expectedScheduler))
                flag = False
        self.result.raw = rawStr
        self.result.val = "\n".join(resultList)
        if flag:
            self.result.rst = ResultStatus.OK
            self.result.val = "All disk IO request are normal."
        else:
            self.result.rst = ResultStatus.WARNING

    def doSet(self):
        result_str = ""
        for dev in g_needRepair:
            cmd = 'echo 32768 > /sys/block/%s/queue/nr_requests' % dev
            (status, output) = subprocess.getstatusoutput(cmd)
            if status != 0:
                result_str = "%sFailed to set dev %s.\n Error : %s" % (result_str, dev, output)
        if len(result_str) > 0:
            self.result.val = result_str
        else:
            self.result.val = "Set IOrequestqueue successfully."
