BEGIN
    BEGIN
        EXECUTE 'DROP TABLE IF EXISTS scheduler.pg_task';
    EXCEPTION WHEN OTHERS THEN
        RAISE NOTICE '%', SQLERRM;
    END;
    BEGIN
        EXECUTE 'CREATE SCHEMA scheduler';
    EXCEPTION WHEN OTHERS THEN
        RAISE NOTICE '%', SQLERRM;
    END;
    BEGIN
        EXECUTE 'CREATE TABLE IF NOT EXISTS scheduler.pg_task (
                    task_id bigserial,
                    what text not null,
                    log_user text,
                    db_name text,
                    name_space text,
                    category_id integer,
                    is_broken boolean,
                    interval text,
                    time_cons text,
                    start_time TIMESTAMP WITHOUT TIME ZONE,
                    end_time TIMESTAMP WITHOUT TIME ZONE,
                    parameter text
                  ) DISTRIBUTE BY HASH(task_id);';
    EXCEPTION WHEN OTHERS THEN
        RAISE NOTICE '%', SQLERRM;
    END;
END;