/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.sqlj;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Logger;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.sqlj.JarLoader;

public class Loader
extends ClassLoader {
    private static final String PUBLIC_SCHEMA = "public";
    private static final Map s_schemaLoaders = new HashMap();
    private static final Map s_typeMap = new HashMap();
    private static final Logger s_logger = Logger.getLogger(Loader.class.getName());
    private final LinkedList m_jarloaders = new LinkedList();
    private static String m_current_classpath;

    Loader(String string) throws SQLException {
        super(Loader.class.getClassLoader());
        String string2 = Backend.getLibraryPath() + "/java/";
        try {
            File file = new File(string2);
            if (file.isDirectory()) {
                LinkedList linkedList = new LinkedList();
                Loader.getJarFiles(file, linkedList);
                for (int i = 0; i < linkedList.size(); ++i) {
                    URL uRL = new URL("file:///" + (String)linkedList.get(i));
                    JarLoader jarLoader = new JarLoader(this, uRL);
                    this.m_jarloaders.add(jarLoader);
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new SQLException("Malformed URL Exception: " + malformedURLException.getMessage());
        }
        catch (IOException iOException) {
            throw new SQLException("IOException reading jar: " + iOException.getMessage());
        }
    }

    private static void getJarFiles(File file, final LinkedList linkedList) {
        file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    Loader.getJarFiles(file, linkedList);
                } else if (file.getPath().endsWith(".jar")) {
                    linkedList.add(file.getPath());
                    return true;
                }
                return false;
            }
        });
    }

    public static void clearSchemaLoaders() {
        s_schemaLoaders.clear();
        s_typeMap.clear();
        Backend.clearFunctionCache();
    }

    public static ClassLoader getCurrentLoader() throws SQLException {
        return Loader.getSchemaLoader(PUBLIC_SCHEMA);
    }

    public static ClassLoader getSchemaLoader(String string) throws SQLException {
        ClassLoader classLoader;
        String string2 = Backend.getConfigOption("pljava_classpath");
        if (string2 == null) {
            string2 = "";
        }
        if (!string2.equals(m_current_classpath)) {
            Loader.clearSchemaLoaders();
            m_current_classpath = string2;
        }
        if ((classLoader = (ClassLoader)s_schemaLoaders.get(string2)) == null) {
            classLoader = new Loader(string2);
            s_schemaLoaders.put(string2, classLoader);
        }
        return classLoader;
    }

    public static Map getTypeMap(String string) throws SQLException {
        return Collections.EMPTY_MAP;
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        ListIterator listIterator = this.m_jarloaders.listIterator();
        while (listIterator.hasNext()) {
            JarLoader jarLoader = (JarLoader)listIterator.next();
            try {
                Class clazz = jarLoader.findClass(string);
                if (clazz == null) continue;
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException(string);
    }

    @Override
    protected URL findResource(String string) {
        ListIterator listIterator = this.m_jarloaders.listIterator();
        while (listIterator.hasNext()) {
            JarLoader jarLoader = (JarLoader)listIterator.next();
            URL uRL = jarLoader.findResource(string);
            if (uRL == null) continue;
            return uRL;
        }
        return null;
    }
}

