/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.sqlj;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class JarLoader
extends ClassLoader {
    private final URL m_url;
    private final Map m_entries;
    private Map m_images;
    private Manifest m_manifest;

    JarLoader(ClassLoader classLoader, URL uRL) throws IOException {
        super(classLoader);
        this.m_url = uRL;
        this.m_entries = new HashMap();
        this.m_images = new HashMap();
        JarInputStream jarInputStream = new JarInputStream(uRL.openStream());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        JarEntry jarEntry = jarInputStream.getNextJarEntry();
        while (jarEntry != null) {
            if (!jarEntry.isDirectory()) {
                int n;
                String string = jarEntry.getName();
                Attributes attributes = jarEntry.getAttributes();
                byteArrayOutputStream.reset();
                while ((n = jarInputStream.read(byArray)) > 0) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                jarInputStream.closeEntry();
                this.m_entries.put(string, byteArrayOutputStream.toByteArray());
            }
            jarEntry = jarInputStream.getNextJarEntry();
        }
        this.m_manifest = jarInputStream.getManifest();
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        if (string.startsWith("java.") || string.startsWith("org.postgresql.pljava") && !string.startsWith("org.postgresql.pljava.example")) {
            throw new ClassNotFoundException(string);
        }
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz != null) {
            return clazz;
        }
        String string2 = string.replace('.', '/').concat(".class");
        byte[] byArray = (byte[])this.m_entries.get(string2);
        if (byArray == null) {
            throw new ClassNotFoundException(string);
        }
        this.definePackage(string);
        return this.defineClass(string, byArray, 0, byArray.length);
    }

    @Override
    protected URL findResource(String string) {
        Object v = this.m_entries.get(string);
        if (v == null) {
            return null;
        }
        try {
            URL uRL = new URL("jar", this.m_url.getHost(), "file:" + this.m_url.getPath() + "!/" + string);
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    protected void definePackage(String string) {
        int n = string.lastIndexOf(46);
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        URL uRL = null;
        if (n == -1) {
            return;
        }
        String string9 = string.substring(0, n);
        if (this.getPackage(string9) != null) {
            return;
        }
        if (this.m_manifest != null) {
            String string10 = string9.replace('.', '/') + "/";
            Attributes attributes = this.m_manifest.getAttributes(string10);
            Attributes attributes2 = this.m_manifest.getMainAttributes();
            if (attributes != null) {
                string2 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
                string3 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
                string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
                string5 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
                string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                string8 = attributes.getValue(Attributes.Name.SEALED);
            }
            if (attributes2 != null) {
                if (string2 == null) {
                    string2 = attributes2.getValue(Attributes.Name.SPECIFICATION_TITLE);
                }
                if (string3 == null) {
                    string3 = attributes2.getValue(Attributes.Name.SPECIFICATION_VENDOR);
                }
                if (string4 == null) {
                    string4 = attributes2.getValue(Attributes.Name.SPECIFICATION_VERSION);
                }
                if (string5 == null) {
                    string5 = attributes2.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                }
                if (string6 == null) {
                    string6 = attributes2.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
                }
                if (string7 == null) {
                    string7 = attributes2.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                }
                if (string8 == null) {
                    string8 = attributes2.getValue(Attributes.Name.SEALED);
                }
            }
        }
        if (string8 != null && string8.equalsIgnoreCase("true")) {
            uRL = this.m_url;
        }
        this.definePackage(string9, string2, string4, string3, string5, string7, string6, uRL);
    }
}

