/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.sqlgen;

import java.io.IOException;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;
import org.postgresql.pljava.sqlgen.DDRProcessorImpl;
import org.postgresql.pljava.sqlgen.Lexicals;
import org.postgresql.pljava.sqlgen.Snippet;

public class DDRWriter {
    static final Pattern checker = Pattern.compile("(?s:\\\\.|[^;'\"]|'(?:\\\\.|[^'])*+'|\"(?:\\\\.|[^\"])*+\")*+");
    static final String checkMsg = "%s command contains unquoted ; or unbalanced '/\": %s";
    static final Pattern equoter = Pattern.compile("\\\\|'");

    static void emit(Snippet[] snippetArray, DDRProcessorImpl dDRProcessorImpl) throws IOException {
        if (!DDRWriter.ensureLexable(snippetArray, dDRProcessorImpl)) {
            return;
        }
        Writer writer = dDRProcessorImpl.filr.createResource(StandardLocation.CLASS_OUTPUT, "", dDRProcessorImpl.output, new Element[0]).openWriter();
        writer.write("SQLActions[]={\n\"BEGIN INSTALL\n");
        for (Snippet snippet : snippetArray) {
            for (String string : snippet.deployStrings()) {
                DDRWriter.writeCommand(writer, string, snippet.implementor());
            }
        }
        writer.write("END INSTALL\",\n\"BEGIN REMOVE\n");
        int n = snippetArray.length;
        while (n-- > 0) {
            for (String string : snippetArray[n].undeployStrings()) {
                DDRWriter.writeCommand(writer, string, snippetArray[n].implementor());
            }
        }
        writer.write("END REMOVE\"\n}\n");
        writer.close();
    }

    static void writeCommand(Writer writer, String string, String string2) throws IOException {
        if (null != string2) {
            writer.write("BEGIN ");
            writer.write(string2);
            writer.write(10);
        }
        writer.write(string);
        if (null != string2) {
            writer.write("\nEND ");
            writer.write(string2);
        }
        writer.write(";\n");
    }

    static boolean ensureLexable(Snippet[] snippetArray, DDRProcessorImpl dDRProcessorImpl) {
        boolean bl = false;
        Matcher matcher = checker.matcher("");
        Matcher matcher2 = Lexicals.ISO_PG_JAVA_IDENTIFIER.matcher("");
        for (Snippet snippet : snippetArray) {
            String string = snippet.implementor();
            if (null != string) {
                matcher2.reset(string);
                if (!matcher2.matches()) {
                    dDRProcessorImpl.msg(Diagnostic.Kind.ERROR, "non-SQL- or -Java-structured implementor-name: %s", string);
                }
            }
            for (String string2 : snippet.deployStrings()) {
                matcher.reset(string2);
                if (matcher.matches()) continue;
                dDRProcessorImpl.msg(Diagnostic.Kind.ERROR, checkMsg, "install", string2);
                bl = true;
            }
            for (String string2 : snippet.undeployStrings()) {
                matcher.reset(string2);
                if (matcher.matches()) continue;
                dDRProcessorImpl.msg(Diagnostic.Kind.ERROR, checkMsg, "remove", string2);
                bl = true;
            }
        }
        return !bl;
    }

    public static String eQuote(CharSequence charSequence) {
        Matcher matcher = equoter.matcher(charSequence);
        return "e'" + matcher.replaceAll("$0$0") + '\'';
    }
}

