/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.management;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.jar.JarInputStream;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.postgresql.pljava.Session;
import org.postgresql.pljava.SessionManager;
import org.postgresql.pljava.annotation.Function;
import org.postgresql.pljava.annotation.SQLAction;
import org.postgresql.pljava.annotation.SQLType;
import org.postgresql.pljava.internal.AclId;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.Oid;
import org.postgresql.pljava.jdbc.SQLUtils;
import org.postgresql.pljava.management.SQLDeploymentDescriptor;
import org.postgresql.pljava.sqlj.Loader;

@SQLAction(install={"\tCREATE TABLE sqlj.jar_repository(\t\tjarId       SERIAL PRIMARY KEY,\t\tjarName     VARCHAR(100) UNIQUE NOT NULL,\t\tjarOrigin   VARCHAR(500) NOT NULL,\t\tjarOwner    NAME NOT NULL,\t\tjarManifest TEXT\t)", "\tCOMMENT ON TABLE sqlj.jar_repository IS\t'Information on jars loaded by PL/Java, one row per jar.'", "\tGRANT SELECT ON sqlj.jar_repository TO public", "\tCREATE TABLE sqlj.jar_entry(\t\tentryId     SERIAL PRIMARY KEY,\t\tentryName   VARCHAR(200) NOT NULL,\t\tjarId       INT NOT NULL\t\t\t\t\tREFERENCES sqlj.jar_repository ON DELETE CASCADE,\t\tentryImage  BYTEA NOT NULL,\t\tUNIQUE(jarId, entryName)\t)", "\tCOMMENT ON TABLE sqlj.jar_entry IS\t'Name and content of each entry in every jar loaded by PL/Java.'", "\tGRANT SELECT ON sqlj.jar_entry TO public", "\tCREATE TABLE sqlj.jar_descriptor(\t\tjarId       INT REFERENCES sqlj.jar_repository ON DELETE CASCADE,\t\tordinal     INT2,\t\tPRIMARY KEY (jarId, ordinal),\t\tentryId     INT NOT NULL REFERENCES sqlj.jar_entry ON DELETE CASCADE\t)", "\tCOMMENT ON TABLE sqlj.jar_descriptor IS\t'Associates each jar with zero-or-more deployment descriptors (a row for each), with ordinal indicating their order of mention in the manifest.'", "\tGRANT SELECT ON sqlj.jar_descriptor TO public", "\tCREATE TABLE sqlj.classpath_entry(\t\tschemaName  VARCHAR(30) NOT NULL,\t\tordinal     INT2 NOT NULL,\t\tjarId       INT NOT NULL\t\t\t\t\tREFERENCES sqlj.jar_repository ON DELETE CASCADE,\t\tPRIMARY KEY(schemaName, ordinal)\t)", "\tCOMMENT ON TABLE sqlj.classpath_entry IS\t'Associates each schema with zero-or-more jars (a row for each), with ordinal indicating their order of precedence in the classpath.'", "\tGRANT SELECT ON sqlj.classpath_entry TO public", "\tCREATE TABLE sqlj.typemap_entry(\t\tmapId       SERIAL PRIMARY KEY,\t\tjavaName    VARCHAR(200) NOT NULL,\t\tsqlName     NAME NOT NULL\t)", "\tCOMMENT ON TABLE sqlj.typemap_entry IS\t'A row for each SQL type <-> Java type custom mapping.'", "\tGRANT SELECT ON sqlj.typemap_entry TO public"}, remove={"\tDROP TABLE sqlj.typemap_entry", "\tDROP TABLE sqlj.jar_repository CASCADE"})
public class Commands {
    private static final Logger s_logger = Logger.getLogger(Commands.class.getName());
    private static final Pattern ddrSection = Pattern.compile("(?<=[\\r\\n])Name: ((?:.|(?:\\r\\n?|\\n) )+)(?:(?:\\r\\n?|\\n))(?:[^\\r\\n]+(?:\\r\\n?|\\n)(?![\\r\\n]))*SQLJDeploymentDescriptor: (?:(?:\\r\\n?|\\r) )*TRUE(?!\\S)", 2);
    private static final Pattern mfCont = Pattern.compile("(?:\\r\\n?|\\n) ");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addClassImages(int n, InputStream inputStream, int n2) throws SQLException {
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        PreparedStatement preparedStatement3 = null;
        ResultSet resultSet = null;
        try {
            int n3;
            Object object;
            Object object2;
            byte[] byArray = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            preparedStatement = SQLUtils.getDefaultConnection().prepareStatement("INSERT INTO sqlj.jar_entry(entryName, jarId, entryImage) VALUES(?, ?, ?)");
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            String string = Commands.rawManifest(bufferedInputStream, n2);
            JarInputStream jarInputStream = new JarInputStream(bufferedInputStream);
            if (string != null) {
                object2 = SQLUtils.getDefaultConnection().prepareStatement("UPDATE sqlj.jar_repository SET jarManifest = ? WHERE jarId = ?");
                try {
                    object2.setString(1, string);
                    object2.setInt(2, n);
                    if (object2.executeUpdate() != 1) {
                        throw new SQLException("Jar repository update did not update 1 row");
                    }
                }
                finally {
                    SQLUtils.close((Statement)object2);
                }
            }
            while ((object2 = jarInputStream.getNextJarEntry()) != null) {
                if (((ZipEntry)object2).isDirectory()) continue;
                object = ((ZipEntry)object2).getName();
                byteArrayOutputStream.reset();
                while ((n3 = jarInputStream.read(byArray)) > 0) {
                    byteArrayOutputStream.write(byArray, 0, n3);
                }
                jarInputStream.closeEntry();
                preparedStatement.setString(1, (String)object);
                preparedStatement.setInt(2, n);
                preparedStatement.setBytes(3, byteArrayOutputStream.toByteArray());
                if (preparedStatement.executeUpdate() == 1) continue;
                throw new SQLException("Jar entry insert did not insert 1 row");
            }
            object2 = ddrSection.matcher(null != string ? string : "");
            object = mfCont.matcher("");
            n3 = 0;
            while (((Matcher)object2).find()) {
                String string2 = ((Matcher)object).reset(((Matcher)object2).group(1)).replaceAll("");
                if (preparedStatement2 == null) {
                    preparedStatement2 = SQLUtils.getDefaultConnection().prepareStatement("SELECT entryId FROM sqlj.jar_entry WHERE jarId = ? AND entryName = ?");
                }
                preparedStatement2.setInt(1, n);
                preparedStatement2.setString(2, string2);
                resultSet = preparedStatement2.executeQuery();
                if (!resultSet.next()) {
                    throw new SQLException("Failed to refetch row in sqlj.jar_entry");
                }
                int n4 = resultSet.getInt(1);
                if (preparedStatement3 == null) {
                    preparedStatement3 = SQLUtils.getDefaultConnection().prepareStatement("INSERT INTO sqlj.jar_descriptor (jarId, entryId, ordinal) VALUES ( ?, ?, ? )");
                }
                preparedStatement3.setInt(1, n);
                preparedStatement3.setInt(2, n4);
                preparedStatement3.setInt(3, n3);
                if (preparedStatement3.executeUpdate() != 1) {
                    throw new SQLException("Jar deployment descriptor insert did not insert 1 row");
                }
                ++n3;
            }
        }
        catch (IOException iOException) {
            try {
                throw new SQLException("I/O exception reading jar file: " + iOException.getMessage(), "58030", iOException);
            }
            catch (Throwable throwable) {
                SQLUtils.close(resultSet);
                SQLUtils.close(preparedStatement3);
                SQLUtils.close(preparedStatement2);
                SQLUtils.close(preparedStatement);
                throw throwable;
            }
        }
        SQLUtils.close(resultSet);
        SQLUtils.close(preparedStatement3);
        SQLUtils.close(preparedStatement2);
        SQLUtils.close(preparedStatement);
    }

    private static String rawManifest(BufferedInputStream bufferedInputStream, int n) throws IOException {
        ZipEntry zipEntry;
        bufferedInputStream.mark(n > 0 ? n : 0x2000000);
        ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
        while (null != (zipEntry = zipInputStream.getNextEntry())) {
            if ("META-INF/MANIFEST.MF".equals(zipEntry.getName())) {
                int n2;
                StringBuilder stringBuilder = new StringBuilder();
                CharsetDecoder charsetDecoder = Charset.forName("UTF-8").newDecoder();
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)zipInputStream, charsetDecoder);
                char[] cArray = new char[512];
                while (-1 != (n2 = inputStreamReader.read(cArray))) {
                    stringBuilder.append(cArray, 0, n2);
                }
                zipInputStream.closeEntry();
                bufferedInputStream.reset();
                return stringBuilder.toString();
            }
            zipInputStream.closeEntry();
        }
        bufferedInputStream.reset();
        return null;
    }

    @Function(schema="sqlj", name="add_type_mapping", security=Function.Security.DEFINER)
    public static void addTypeMapping(String string, String string2) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            ClassLoader classLoader = Loader.getCurrentLoader();
            Class<?> clazz = classLoader.loadClass(string2);
            if (!SQLData.class.isAssignableFrom(clazz)) {
                throw new SQLException("Class " + string2 + " does not implement java.sql.SQLData");
            }
            string = Commands.getFullSqlNameOwned(string);
            preparedStatement = SQLUtils.getDefaultConnection().prepareStatement("INSERT INTO sqlj.typemap_entry(javaName, sqlName) VALUES(?,?)");
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string);
            preparedStatement.executeUpdate();
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                throw new SQLException("No such class: " + string2, "46103", classNotFoundException);
            }
            catch (Throwable throwable) {
                SQLUtils.close(preparedStatement);
                throw throwable;
            }
        }
        SQLUtils.close(preparedStatement);
        Loader.clearSchemaLoaders();
    }

    @Function(schema="sqlj", name="drop_type_mapping", security=Function.Security.DEFINER)
    public static void dropTypeMapping(String string) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            string = Commands.getFullSqlNameOwned(string);
            preparedStatement = SQLUtils.getDefaultConnection().prepareStatement("DELETE FROM sqlj.typemap_entry WHERE sqlName = ?");
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            SQLUtils.close(preparedStatement);
            throw throwable;
        }
        SQLUtils.close(preparedStatement);
        Loader.clearSchemaLoaders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Function(schema="sqlj", name="get_classpath", security=Function.Security.DEFINER)
    public static String getClassPath(String string) throws SQLException {
        String string2;
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        try {
            string = string == null || string.length() == 0 ? "public" : string.toLowerCase();
            preparedStatement = SQLUtils.getDefaultConnection().prepareStatement("SELECT r.jarName FROM sqlj.jar_repository r INNER JOIN sqlj.classpath_entry c ON r.jarId = c.jarId WHERE c.schemaName = ? ORDER BY c.ordinal");
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            StringBuffer stringBuffer = null;
            while (resultSet.next()) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                } else {
                    stringBuffer.append(':');
                }
                stringBuffer.append(resultSet.getString(1));
            }
            string2 = stringBuffer == null ? null : stringBuffer.toString();
        }
        catch (Throwable throwable) {
            SQLUtils.close(resultSet);
            SQLUtils.close(preparedStatement);
            throw throwable;
        }
        SQLUtils.close(resultSet);
        SQLUtils.close(preparedStatement);
        return string2;
    }

    public static String getCurrentSchema() throws SQLException {
        Session session = SessionManager.current();
        return ((org.postgresql.pljava.internal.Session)session).getOuterUserSchema();
    }

    @Function(schema="sqlj", name="install_jar", security=Function.Security.DEFINER)
    public static void installJar(@SQLType(value="bytea") byte[] byArray, String string, boolean bl) throws SQLException {
        Commands.installJar("streamed byte image", string, bl, byArray);
    }

    @Function(schema="sqlj", name="install_jar", security=Function.Security.DEFINER)
    public static void installJar(String string, String string2, boolean bl) throws SQLException {
        Commands.installJar(string, string2, bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Function(schema="sqlj", name="remove_jar", security=Function.Security.DEFINER)
    public static void removeJar(String string, boolean bl) throws SQLException {
        Commands.assertJarName(string);
        AclId[] aclIdArray = new AclId[1];
        int n = Commands.getJarId(string, aclIdArray);
        if (n < 0) {
            throw new SQLException("No Jar named '" + string + "' is known to the system", "4600B");
        }
        AclId aclId = AclId.getOuterUser();
        if (!aclId.isSuperuser() && !aclId.equals(aclIdArray[0])) {
            throw new SQLSyntaxErrorException("Only super user or owner can remove a jar", "42501");
        }
        if (bl) {
            Commands.deployRemove(n, string);
        }
        PreparedStatement preparedStatement = SQLUtils.getDefaultConnection().prepareStatement("DELETE FROM sqlj.jar_repository WHERE jarId = ?");
        try {
            preparedStatement.setInt(1, n);
            if (preparedStatement.executeUpdate() != 1) {
                throw new SQLException("Jar repository update did not update 1 row");
            }
        }
        finally {
            SQLUtils.close(preparedStatement);
        }
        Loader.clearSchemaLoaders();
    }

    @Function(schema="sqlj", name="replace_jar", security=Function.Security.DEFINER)
    public static void replaceJar(@SQLType(value="bytea") byte[] byArray, String string, boolean bl) throws SQLException {
        Commands.replaceJar("streamed byte image", string, bl, byArray);
    }

    @Function(schema="sqlj", name="replace_jar", security=Function.Security.DEFINER)
    public static void replaceJar(String string, String string2, boolean bl) throws SQLException {
        Commands.replaceJar(string, string2, bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Function(schema="sqlj", name="set_classpath", security=Function.Security.DEFINER)
    public static void setClassPath(String string, String string2) throws SQLException {
        int n;
        int n2;
        Object object;
        if (string == null || string.length() == 0) {
            string = "public";
        }
        if ("public".equals(string = string.toLowerCase())) {
            if (!AclId.getOuterUser().isSuperuser()) {
                throw new SQLSyntaxErrorException("Permission denied. Only a super user can set the classpath of the public schema", "42501");
            }
        } else {
            object = Commands.getSchemaId(string);
            if (object == null) {
                throw new SQLNonTransientException("No such schema: " + string, "3F000");
            }
            if (!AclId.getOuterUser().hasSchemaCreatePermission((Oid)object)) {
                throw new SQLSyntaxErrorException("Permission denied. User must have create permission on the target schema in order to set the classpath", "42501");
            }
        }
        ArrayList<Integer> arrayList = null;
        if (string2 != null && string2.length() > 0) {
            arrayList = new ArrayList<Integer>();
            object = SQLUtils.getDefaultConnection().prepareStatement("SELECT jarId FROM sqlj.jar_repository WHERE jarName = ?");
            try {
                do {
                    String string3;
                    if ((n2 = string2.indexOf(58)) >= 0) {
                        string3 = string2.substring(0, n2);
                        string2 = string2.substring(n2 + 1);
                    } else {
                        string3 = string2;
                    }
                    n = Commands.getJarId((PreparedStatement)object, string3, null);
                    if (n < 0) {
                        throw new SQLNonTransientException("No such jar: " + string3, "46102");
                    }
                    arrayList.add(new Integer(n));
                } while (n2 >= 0);
            }
            finally {
                SQLUtils.close((Statement)object);
            }
        }
        object = SQLUtils.getDefaultConnection().prepareStatement("DELETE FROM sqlj.classpath_entry WHERE schemaName = ?");
        try {
            object.setString(1, string);
            object.executeUpdate();
        }
        finally {
            SQLUtils.close((Statement)object);
        }
        if (arrayList != null) {
            object = SQLUtils.getDefaultConnection().prepareStatement("INSERT INTO sqlj.classpath_entry(schemaName, ordinal, jarId) VALUES(?, ?, ?)");
            try {
                n2 = arrayList.size();
                for (int i = 0; i < n2; ++i) {
                    n = (Integer)arrayList.get(i);
                    object.setString(1, string);
                    object.setInt(2, i + 1);
                    object.setInt(3, n);
                    object.executeUpdate();
                }
            }
            finally {
                SQLUtils.close((Statement)object);
            }
        }
        Loader.clearSchemaLoaders();
    }

    private static boolean assertInPath(String string, String[] stringArray) throws SQLException {
        String string2 = Commands.getCurrentSchema();
        String string3 = Commands.getClassPath(string2);
        stringArray[0] = string2;
        stringArray[1] = string3;
        if (string3 == null) {
            Commands.setClassPath(string2, string);
            return true;
        }
        String[] stringArray2 = string3.split(":");
        int n = stringArray2.length;
        boolean bl = false;
        while (--n >= 0) {
            if (!stringArray2[n].equals(string)) continue;
            bl = true;
            break;
        }
        if (bl) {
            return false;
        }
        Commands.setClassPath(string2, string + ':' + string3);
        return true;
    }

    private static void assertJarName(String string) throws SQLException {
        int n;
        if (string != null && (n = string.length()) > 0 && Character.isJavaIdentifierStart(string.charAt(0))) {
            int n2;
            for (n2 = 1; n2 < n && Character.isJavaIdentifierPart(string.charAt(n2)); ++n2) {
            }
            if (n2 == n) {
                return;
            }
        }
        throw new SQLNonTransientException("The jar name '" + string + "' is not a valid name", "46002");
    }

    private static void deployInstall(int n, String string) throws SQLException {
        SQLDeploymentDescriptor[] sQLDeploymentDescriptorArray = Commands.getDeploymentDescriptors(n);
        String[] stringArray = new String[2];
        boolean bl = Commands.assertInPath(string, stringArray);
        for (SQLDeploymentDescriptor sQLDeploymentDescriptor : sQLDeploymentDescriptorArray) {
            sQLDeploymentDescriptor.install(SQLUtils.getDefaultConnection());
        }
        if (bl) {
            Commands.setClassPath(stringArray[0], stringArray[1]);
        }
    }

    private static void deployRemove(int n, String string) throws SQLException {
        block4: {
            SQLDeploymentDescriptor[] sQLDeploymentDescriptorArray = Commands.getDeploymentDescriptors(n);
            String[] stringArray = new String[2];
            boolean bl = Commands.assertInPath(string, stringArray);
            int n2 = sQLDeploymentDescriptorArray.length;
            while (n2-- > 0) {
                sQLDeploymentDescriptorArray[n2].remove(SQLUtils.getDefaultConnection());
            }
            try {
                if (bl) {
                    Commands.setClassPath(stringArray[0], stringArray[1]);
                }
            }
            catch (SQLException sQLException) {
                if ("3F000".equals(sQLException.getSQLState())) break block4;
                throw sQLException;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SQLDeploymentDescriptor[] getDeploymentDescriptors(int n) throws SQLException {
        Object[] objectArray;
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = SQLUtils.getDefaultConnection().prepareStatement("SELECT e.entryImage FROM sqlj.jar_descriptor d INNER JOIN sqlj.jar_entry e   ON d.entryId = e.entryId WHERE d.jarId = ? ORDER BY d.ordinal");
        try {
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            ArrayList<SQLDeploymentDescriptor> arrayList = new ArrayList<SQLDeploymentDescriptor>();
            while (resultSet.next()) {
                objectArray = resultSet.getBytes(1);
                arrayList.add(new SQLDeploymentDescriptor(new String((byte[])objectArray, "UTF8")));
            }
            objectArray = arrayList.toArray(new SQLDeploymentDescriptor[arrayList.size()]);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                throw new SQLException("JVM does not support UTF8!!");
                catch (ParseException parseException) {
                    throw new SQLException(parseException.getMessage() + " at " + parseException.getErrorOffset());
                }
            }
            catch (Throwable throwable) {
                SQLUtils.close(resultSet);
                SQLUtils.close(preparedStatement);
                throw throwable;
            }
        }
        SQLUtils.close(resultSet);
        SQLUtils.close(preparedStatement);
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFullSqlNameOwned(String string) throws SQLException {
        String string2;
        Oid oid = Oid.forTypeName(string);
        s_logger.info("Type id = " + oid.toString());
        AclId aclId = AclId.getOuterUser();
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = SQLUtils.getDefaultConnection().prepareStatement("SELECT n.nspname, t.typname, pg_catalog.pg_has_role(?, t.typowner, 'USAGE') FROM pg_catalog.pg_type t, pg_catalog.pg_namespace n WHERE t.oid = ? AND n.oid = t.typnamespace");
        try {
            preparedStatement.setObject(1, aclId);
            preparedStatement.setObject(2, oid);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new SQLException("Unable to obtain type info for " + oid);
            }
            if (!resultSet.getBoolean(3)) {
                throw new SQLSyntaxErrorException("Permission denied. Only superuser or type's owner may add or drop a type mapping.", "42501");
            }
            string2 = resultSet.getString(1) + '.' + resultSet.getString(2);
        }
        catch (Throwable throwable) {
            SQLUtils.close(resultSet);
            SQLUtils.close(preparedStatement);
            throw throwable;
        }
        SQLUtils.close(resultSet);
        SQLUtils.close(preparedStatement);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getJarId(PreparedStatement preparedStatement, String string, AclId[] aclIdArray) throws SQLException {
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        try {
            if (!resultSet.next()) {
                int n = -1;
                return n;
            }
            int n = resultSet.getInt(1);
            if (aclIdArray != null) {
                String string2 = resultSet.getString(2);
                aclIdArray[0] = AclId.fromName(string2);
            }
            int n2 = n;
            return n2;
        }
        finally {
            SQLUtils.close(resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getJarId(String string, AclId[] aclIdArray) throws SQLException {
        PreparedStatement preparedStatement = SQLUtils.getDefaultConnection().prepareStatement("SELECT jarId, jarOwner FROM sqlj.jar_repository WHERE jarName = ?");
        try {
            int n = Commands.getJarId(preparedStatement, string, aclIdArray);
            return n;
        }
        finally {
            SQLUtils.close(preparedStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Oid getSchemaId(String string) throws SQLException {
        PreparedStatement preparedStatement;
        ResultSet resultSet;
        block3: {
            Oid oid;
            resultSet = null;
            preparedStatement = SQLUtils.getDefaultConnection().prepareStatement("SELECT oid FROM pg_catalog.pg_namespace WHERE nspname = ?");
            try {
                preparedStatement.setString(1, string);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) break block3;
                oid = null;
            }
            catch (Throwable throwable) {
                SQLUtils.close(resultSet);
                SQLUtils.close(preparedStatement);
                throw throwable;
            }
            SQLUtils.close(resultSet);
            SQLUtils.close(preparedStatement);
            return oid;
        }
        Oid oid = (Oid)resultSet.getObject(1);
        SQLUtils.close(resultSet);
        SQLUtils.close(preparedStatement);
        return oid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void installJar(String string, String string2, boolean bl, byte[] byArray) throws SQLException {
        if (Backend.isCreatingExtension()) {
            throw new SQLFeatureNotSupportedException("A jar cannot (yet) be installed as an extension in its own right.", "0A000");
        }
        Commands.assertJarName(string2);
        if (Commands.getJarId(string2, null) >= 0) {
            throw new SQLNonTransientException("A jar named '" + string2 + "' already exists", "46002");
        }
        PreparedStatement preparedStatement = SQLUtils.getDefaultConnection().prepareStatement("INSERT INTO sqlj.jar_repository(jarName, jarOrigin, jarOwner) VALUES(?, ?, ?)");
        try {
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, AclId.getOuterUser().getName());
            if (preparedStatement.executeUpdate() != 1) {
                throw new SQLException("Jar repository insert did not insert 1 row");
            }
        }
        finally {
            SQLUtils.close(preparedStatement);
        }
        AclId[] aclIdArray = new AclId[1];
        int n = Commands.getJarId(string2, aclIdArray);
        if (n < 0) {
            throw new SQLException("Unable to obtain id of '" + string2 + "'");
        }
        if (byArray == null) {
            Backend.addClassImages(n, string);
        } else {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            Commands.addClassImages(n, byteArrayInputStream, byArray.length);
        }
        Loader.clearSchemaLoaders();
        if (bl) {
            Commands.deployInstall(n, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void replaceJar(String string, String string2, boolean bl, byte[] byArray) throws SQLException {
        AclId[] aclIdArray = new AclId[1];
        int n = Commands.getJarId(string2, aclIdArray);
        if (n < 0) {
            throw new SQLNonTransientException("No Jar named '" + string2 + "' is known to the system", "4600A");
        }
        AclId aclId = AclId.getOuterUser();
        if (!aclId.isSuperuser() && !aclId.equals(aclIdArray[0])) {
            throw new SQLSyntaxErrorException("Only super user or owner can replace a jar", "42501");
        }
        if (bl) {
            Commands.deployRemove(n, string2);
        }
        PreparedStatement preparedStatement = SQLUtils.getDefaultConnection().prepareStatement("UPDATE sqlj.jar_repository SET jarOrigin = ?, jarOwner = ?, jarManifest = NULL WHERE jarId = ?");
        try {
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, aclId.getName());
            preparedStatement.setInt(3, n);
            if (preparedStatement.executeUpdate() != 1) {
                throw new SQLException("Jar repository update did not update 1 row");
            }
        }
        finally {
            SQLUtils.close(preparedStatement);
        }
        preparedStatement = SQLUtils.getDefaultConnection().prepareStatement("DELETE FROM sqlj.jar_entry WHERE jarId = ?");
        try {
            preparedStatement.setInt(1, n);
            preparedStatement.executeUpdate();
        }
        finally {
            SQLUtils.close(preparedStatement);
        }
        if (byArray == null) {
            Backend.addClassImages(n, string);
        } else {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            Commands.addClassImages(n, byteArrayInputStream, byArray.length);
        }
        Loader.clearSchemaLoaders();
        if (bl) {
            Commands.deployInstall(n, string2);
        }
    }
}

